from gee.test.Jytest import Jytest
from gee.event.EventDB import EventDB
from edu.sc.seis.fissuresUtil.mockFissures.IfEvent import MockEventAccessOperations
from edu.sc.seis.fissuresUtil.database import ConnMgr
from edu.sc.seis.fissuresUtil.flow import Message
from edu.sc.seis.fissuresUtil.flow.querier import EventFinderQuery
from edu.sc.seis.fissuresUtil.flow.extractor.event import MagnitudeValueExtractor
from gee.test.event.EventServerTest import MessageCounter
from edu.sc.seis.fissuresUtil.database import JDBCTearDown
from edu.iris.Fissures.model import MicroSecondDate

class EventDBTest(Jytest):
    def __init__(self, name): 
        Jytest.__init__(self, name)

    def tearDown(self):
        JDBCTearDown.cleanupDB()
    
    def testReceptionAdds(self):
        events = MockEventAccessOperations.createEvents()
        db = EventDB()
        for e in events: self.assertFalse(e in db)         
        for e in events: db.receive(Message(e))
        for e in events: self.assertTrue(e in db) 
        self.assertEquals(len(events), len(db))

    def testEventSending(self):
        events = MockEventAccessOperations.createEvents()
        mc = MessageCounter()
        db = EventDB(receiver=mc)
        for e in events: db.receive(Message(e))
        self.assertEquals(len(events), mc.count)
        for e in events: db.receive(Message(e))
        self.assertEquals(len(events), mc.count)

    def testMagnitudeFiltering(self):
        events = MockEventAccessOperations.createEvents()
        db = EventDB()
        for e in events: db.receive(Message(e))
        db.query.minMag = 7
        self.assertFalse(events[0] in db)
        mc = MessageCounter()
        db.addReceiver(mc)
        bigev = MockEventAccessOperations.createEvent(MicroSecondDate(), 7, 1)
        db.receive(Message(bigev))
        self.assertEquals(1, mc.count)
        self.assertTrue(bigev in db)
        smallev =  MockEventAccessOperations.createEvent(MicroSecondDate(), 3, 1)
        db.receive(Message(smallev))
        self.assertEquals(1, mc.count)
        self.assertFalse(smallev in db)

