from edu.sc.seis.fissuresUtil.map import OpenMap
from javax.swing import JPanel, JButton
from java.awt import BorderLayout
from gee.display import Toolbar

class Map(JPanel):
    def __init__(self):
        JPanel.__init__(self, BorderLayout())
        self.setName('World Map')
        #TODO - Turn this back on before releasing
        import com.bbn.openmap.MapBean
        com.bbn.openmap.MapBean.suppressCopyright = True
        self.map = OpenMap()
        self.add(self.map)
        self.toolbar = MapToolbar(self.map)
        self.add(self.toolbar, BorderLayout.NORTH)
        
class MapToolbar(Toolbar):
    def __init__(self, controlledMap):
        Toolbar.__init__(self, SelectionTool(controlledMap), 'selectors')
        self.add(ZoomInTool(controlledMap), 'controls')
        self.add(DistanceLineToggleTool(controlledMap), 'toggles')
        
class ZoomInTool(JButton):
    def __init__(self, m):
        JButton.__init__(self, self.__class__.__name__)
        
class SelectionTool(JButton):
    def __init__(self, m):
        JButton.__init__(self, self.__class__.__name__)
               
class DistanceLineToggleTool(JButton):
    def __init__(self, m):
        JButton.__init__(self, self.__class__.__name__)
       