from edu.sc.seis.fissuresUtil.flow import Sender

class SenderBase(Sender):
    def __init__(self, receiver=None):
        self.receivers = []
        if not receiver is None:
            self.addReceiver(receiver)

    def send(self, message):
        for receiver in self.receivers: receiver.receive(message)

    def addReceiver(self, receiver):
        self.receivers.append(receiver)

    def removeReceiver(self, receiver):
        self.receivers.remove(receiver)
