/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.holidays;

import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.components.DefaultDayRenderer;
import net.sf.nachocalendar.components.DefaultHeaderRenderer;
import net.sf.nachocalendar.holidays.HoliDayModel;
import net.sf.nachocalendar.holidays.HolidayDecorator;

public final class HoliDayCalendarFactory {
    private HoliDayCalendarFactory() {
    }

    public static DateField createDateField() {
        DateField datefield = new DateField();
        datefield.setRenderer(new HolidayDecorator(new DefaultDayRenderer()));
        datefield.setHeaderRenderer(new DefaultHeaderRenderer());
        datefield.setModel(new HoliDayModel());
        return datefield;
    }

    public static CalendarPanel createCalendarPanel(int quantity, int orientation) {
        CalendarPanel cp = new CalendarPanel(quantity, orientation);
        cp.setRenderer(new HolidayDecorator(new DefaultDayRenderer()));
        cp.setHeaderRenderer(new DefaultHeaderRenderer());
        cp.setModel(new HoliDayModel());
        return cp;
    }

    public static CalendarPanel createCalendarPanel() {
        CalendarPanel cp = new CalendarPanel();
        cp.setRenderer(new HolidayDecorator(new DefaultDayRenderer()));
        cp.setHeaderRenderer(new DefaultHeaderRenderer());
        cp.setModel(new HoliDayModel());
        return cp;
    }

    public static DatePanel createDatePanel() {
        DatePanel retorno = new DatePanel();
        HoliDayCalendarFactory.configureDatePanel(retorno);
        return retorno;
    }

    public static DatePanel createDatePanel(boolean showWeekNumbers) {
        DatePanel retorno = new DatePanel(showWeekNumbers);
        HoliDayCalendarFactory.configureDatePanel(retorno);
        return retorno;
    }

    private static void configureDatePanel(DatePanel dp) {
        dp.setRenderer(new DefaultDayRenderer());
        dp.setHeaderRenderer(new DefaultHeaderRenderer());
        dp.setModel(new HoliDayModel());
    }
}

