/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.nachocalendar.components.ArrowButton;
import net.sf.nachocalendar.event.YearChangeEvent;
import net.sf.nachocalendar.event.YearChangeListener;

public class MonthScroller
extends JPanel {
    private JButton bNext;
    private JButton bPrevious;
    private JComboBox cMonths;
    private transient ArrayList yearChangeListenerList;
    private transient ArrayList changeListenerList;

    public MonthScroller() {
        this.initComponents();
        DateFormatSymbols symbols = new DateFormatSymbols();
        String[] months = symbols.getMonths();
        for (int i = 0; i < months.length - 1; ++i) {
            months[i] = months[i].substring(0, 1).toUpperCase() + months[i].substring(1).toLowerCase();
        }
        this.cMonths.setModel(new DefaultComboBoxModel<String>(months));
        this.cMonths.removeItemAt(this.cMonths.getItemCount() - 1);
        Border border = this.cMonths.getBorder();
    }

    private void initComponents() {
        this.bPrevious = new ArrowButton(7);
        this.cMonths = new JComboBox();
        this.bNext = new ArrowButton(3);
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        this.bPrevious.addActionListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bPrevious, gridBagConstraints);
        this.cMonths.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.cMonths, gridBagConstraints);
        this.bNext.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bNext, gridBagConstraints);
    }

    private void cMonthsActionPerformed(ActionEvent evt) {
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    public void nextMonth() {
        int month = this.getMonth();
        if (month == 11) {
            this.setMonth(0);
            this.fireYearChangeListenerYearIncreased(new YearChangeEvent(this));
        } else {
            this.setMonth(month + 1);
        }
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    public void previousMonth() {
        int month = this.getMonth();
        if (month == 0) {
            this.setMonth(11);
            this.fireYearChangeListenerYearDecreased(new YearChangeEvent(this));
        } else {
            this.setMonth(month - 1);
        }
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    private void bNextActionPerformed(ActionEvent evt) {
        this.nextMonth();
    }

    private void bPreviousActionPerformed(ActionEvent evt) {
        this.previousMonth();
    }

    public void setMonth(int month) {
        this.cMonths.setSelectedIndex(month);
    }

    public int getMonth() {
        return this.cMonths.getSelectedIndex();
    }

    public void setNextIcon(Icon icon) {
        this.bNext.setIcon(icon);
    }

    public void setPreviousIcon(Icon icon) {
        this.bPrevious.setIcon(icon);
    }

    public void setNextText(String text) {
        this.bNext.setText(text);
    }

    public void setPreviousText(String text) {
        this.bPrevious.setText(text);
    }

    public synchronized void addYearChangeListener(YearChangeListener listener) {
        if (this.yearChangeListenerList == null) {
            this.yearChangeListenerList = new ArrayList();
        }
        this.yearChangeListenerList.add(listener);
    }

    public synchronized void removeYearChangeListener(YearChangeListener listener) {
        if (this.yearChangeListenerList != null) {
            this.yearChangeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireYearChangeListenerYearIncreased(YearChangeEvent event) {
        ArrayList list;
        MonthScroller monthScroller = this;
        synchronized (monthScroller) {
            if (this.yearChangeListenerList == null) {
                return;
            }
            list = (ArrayList)this.yearChangeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((YearChangeListener)list.get(i)).yearIncreased(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireYearChangeListenerYearDecreased(YearChangeEvent event) {
        ArrayList list;
        MonthScroller monthScroller = this;
        synchronized (monthScroller) {
            if (this.yearChangeListenerList == null) {
                return;
            }
            list = (ArrayList)this.yearChangeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((YearChangeListener)list.get(i)).yearDecreased(event);
        }
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged(ChangeEvent event) {
        ArrayList list;
        MonthScroller monthScroller = this;
        synchronized (monthScroller) {
            if (this.changeListenerList == null) {
                return;
            }
            list = (ArrayList)this.changeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void setEnabled(boolean b) {
        this.bNext.setEnabled(b);
        this.bPrevious.setEnabled(b);
        this.cMonths.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.cMonths.isEnabled();
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == MonthScroller.this.bPrevious) {
                MonthScroller.this.bPreviousActionPerformed(evt);
            } else if (evt.getSource() == MonthScroller.this.cMonths) {
                MonthScroller.this.cMonthsActionPerformed(evt);
            } else if (evt.getSource() == MonthScroller.this.bNext) {
                MonthScroller.this.bNextActionPerformed(evt);
            }
        }
    }
}

