/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EventDataListener;
import edu.sc.seis.fissuresUtil.display.EventTableModel;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.EventDestination;
import edu.sc.seis.gee.task.GUITask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableModel;
import org.apache.log4j.Category;

public class ShowEventsTask
implements GUITask,
EventDestination {
    JPanel panel = null;
    EventListenerList listenerList = new EventListenerList();
    protected EventTableModel tableModel = new EventTableModel();
    private ListSelectionModel selectionModel;
    JTable eventTable = new JTable((TableModel)this.tableModel);
    static Category logger = Category.getInstance((String)ShowEventsTask.class.getName());

    public ShowEventsTask() {
        this.eventTable.setRowSelectionAllowed(true);
        this.eventTable.setColumnSelectionAllowed(false);
        this.eventTable.setSelectionMode(0);
        this.eventTable.setAutoResizeMode(0);
        this.selectionModel = this.eventTable.getSelectionModel();
        this.tableModel.addEventDataListener(new EventDataListener(){

            public void eventDataChanged(EQDataEvent eqDataEvent) {
            }

            public void eventDataAppended(EQDataEvent eqDataEvent) {
            }

            public void eventDataCleared() {
                ShowEventsTask.this.selectionModel.clearSelection();
            }
        });
    }

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public JComponent getGUI() throws Exception {
        if (this.panel == null) {
            this.initGUI();
        }
        return this.panel;
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
    }

    @Override
    public void invoke() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateEvents(EventAccessOperations[] events) {
        if (events != null) {
            this.tableModel.updateEvents(events);
        }
    }

    @Override
    public void appendEvents(EventAccessOperations[] events) {
        if (events != null) {
            this.tableModel.appendEvents(events);
        }
    }

    public EventAccessOperations[] getSelectedEvents() {
        int min = this.selectionModel.getMinSelectionIndex();
        int max = this.selectionModel.getMaxSelectionIndex();
        ArrayList<EventAccessOperations> selected = new ArrayList<EventAccessOperations>();
        for (int i = min; i <= max; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            selected.add(this.tableModel.getEventForRow(i));
        }
        return selected.toArray(new EventAccessOperations[0]);
    }

    protected void initGUI() {
        JPanel contentPane = new JPanel();
        JPanel endPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(1000, 400);
        contentPane.setPreferredSize(dimension);
        contentPane.setMinimumSize(dimension);
        this.setColumnSizes();
        JScrollPane jsp = new JScrollPane(this.eventTable);
        contentPane.add((Component)jsp, "Center");
        contentPane.add((Component)endPane, "South");
        this.panel = contentPane;
    }

    public void setColumnSizes() {
        int columnCount = this.tableModel.getColumnCount();
        for (int counter = 0; counter < columnCount; ++counter) {
            String columnName = this.tableModel.getColumnName(counter);
            int width = 50;
            if (columnName.equals("Region")) {
                width = 250;
            } else if (columnName.equals("Origin Time")) {
                width = 200;
            } else if (columnName.equals("Latitude")) {
                width = 80;
            } else if (columnName.equals("Longitude")) {
                width = 80;
            } else if (columnName.equals("Depth")) {
                width = 100;
            } else if (columnName.equals("Magnitude")) {
                width = 80;
            } else if (columnName.equals("Catalog")) {
                width = 100;
            } else if (columnName.equals("Contributor")) {
                width = 100;
            }
            this.eventTable.getColumnModel().getColumn(counter).setPreferredWidth(width);
            this.eventTable.getColumnModel().getColumn(counter).setMinWidth(width);
        }
    }

    public EventTableModel getEventTableModel() {
        return this.tableModel;
    }

    public ListSelectionModel getEventSelectionModel() {
        return this.selectionModel;
    }
}

