/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeEvent;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeisDataErrorEvent;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.DataSetRealTimePlayerTask;
import edu.sc.seis.gee.task.LoadSeismogram;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class RTSeismogramDisplayTask
extends DataSetRealTimePlayerTask {
    private Timer reloadTimer = new Timer(120000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    });
    private DataSet realTimeDataSet = new MemoryDataSet("Real Time Data", "Real Time Data", "me", EMPTY_INFO);
    private boolean guiInitialized = false;
    private static AuditInfo[] EMPTY_INFO = new AuditInfo[0];
    private LoadSeismogram loadSeismogramTask;
    private static final TimeInterval TWENTY_MINUTES = new TimeInterval(20.0, UnitImpl.MINUTE);
    private static final TimeInterval TEN_MINUTES = new TimeInterval(10.0, UnitImpl.MINUTE);
    private static final TimeInterval TWO_MINUTES = new TimeInterval(2.0, UnitImpl.MINUTE);
    private static final TimeInterval TENTH_SECOND = new TimeInterval(100.0, UnitImpl.MILLISECOND);
    private Logger logger = Logger.getLogger(RTSeismogramDisplayTask.class);

    public RTSeismogramDisplayTask() {
        SeismogramDisplay.setCurrentTimeFlag((boolean)true);
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        super.configure(params);
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)params.get("loadSeismogramTask");
        TaskAction loadSeisTaskAction = commonAccess.getTaskAction(taskId);
        this.loadSeismogramTask = (LoadSeismogram)loadSeisTaskAction.getTask();
        if (this.loadSeismogramTask == null) {
            throw new ConfigurationException("Invalid configuration, loadSeismogramTask must not be null");
        }
    }

    @Override
    public void invoke() throws NoNetworkException, ConfigurationException {
        if (!NetworkGateKeeper.accessAllowed()) {
            throw new NoNetworkException();
        }
        super.invoke();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.reloadTimer != null) {
            this.reloadTimer.stop();
        }
    }

    public void addChannels(Channel[] channels) {
        RealTimeLoader loader = new RealTimeLoader(channels);
        JobTracker.getTracker().add((Job)loader);
        Thread t = new Thread((Runnable)((Object)loader));
        t.start();
    }

    public static Channel[] pruneChannelArray(Channel[] channels) {
        ArrayList<Channel> chanList = new ArrayList<Channel>();
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i] == null) continue;
            chanList.add(channels[i]);
        }
        return chanList.toArray(new Channel[0]);
    }

    class SeismogramReloader
    implements ActionListener {
        Timer timer;
        DataSetSeismogram seis;

        SeismogramReloader(DataSetSeismogram seis, Timer timer) {
            this.seis = seis;
            this.timer = timer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RTSeismogramDisplayTask.this.display.contains(this.seis)) {
                MicroSecondDate endTime = ClockUtil.now();
                MicroSecondDate beginTime = endTime.subtract(TWENTY_MINUTES);
                this.seis.setEndTime(endTime.getFissuresTime());
                this.seis.setBeginTime(beginTime.getFissuresTime());
                this.seis.retrieveData(new SeisDataChangeListener(){

                    public void pushData(SeisDataChangeEvent sdce) {
                    }

                    public void finished(SeisDataChangeEvent sdce) {
                    }

                    public void error(SeisDataErrorEvent sdce) {
                        GlobalExceptionHandler.handle((Throwable)sdce.getCausalException());
                    }
                });
            } else {
                this.timer.removeActionListener(this);
            }
        }
    }

    private class RealTimeLoader
    extends AbstractJob {
        private Channel[] channels;

        public RealTimeLoader(Channel[] channels) {
            super("Real Time Loader");
            this.channels = channels;
        }

        public void runJob() {
            this.setStatus("Getting selected channels");
            DataSetSeismogram[] currentSeis = RTSeismogramDisplayTask.this.display.getSeismograms();
            for (int i = 0; i < currentSeis.length; ++i) {
                String seisChanId = ChannelIdUtil.toString((ChannelId)currentSeis[i].getRequestFilter().channel_id);
                for (int j = 0; j < this.channels.length; ++j) {
                    String chanId;
                    if (this.channels[j] == null || !seisChanId.equals(chanId = ChannelIdUtil.toString((ChannelId)this.channels[j].get_id()))) continue;
                    this.channels[j] = null;
                }
            }
            this.channels = RTSeismogramDisplayTask.pruneChannelArray(this.channels);
            boolean displayedAny = false;
            MicroSecondDate endDate = ClockUtil.now();
            MicroSecondDate beginDate = endDate.subtract(TWENTY_MINUTES);
            ChannelId[] ids = new ChannelId[this.channels.length];
            for (int i = 0; i < this.channels.length; ++i) {
                ids[i] = this.channels[i].get_id();
                String channelParam = "edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)ids[i]);
                RTSeismogramDisplayTask.this.realTimeDataSet.addParameter(channelParam, (Object)this.channels[i], EMPTY_INFO);
            }
            DataSetSeismogram[] seis = new DataSetSeismogram[]{};
            try {
                this.setStatus("Retrieving seismograms for channels");
                seis = RTSeismogramDisplayTask.this.loadSeismogramTask.retrieveSeismograms(beginDate.getFissuresTime(), endDate.getFissuresTime(), ids);
                for (int i = 0; i < seis.length; ++i) {
                    RTSeismogramDisplayTask.this.realTimeDataSet.addDataSetSeismogram(seis[i], EMPTY_INFO);
                }
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Trouble Retrieving seismograms for real time", (Throwable)e);
            }
            this.setStatus("Displaying seismograms");
            for (int i = 0; i < seis.length; ++i) {
                RTSeismogramDisplayTask.this.addSeismogram(seis[i]);
                SeismogramReloader loader = new SeismogramReloader(seis[i], RTSeismogramDisplayTask.this.reloadTimer);
                RTSeismogramDisplayTask.this.reloadTimer.addActionListener(loader);
                displayedAny = true;
            }
            if (displayedAny) {
                RTSeismogramDisplayTask.this.reloadTimer.start();
                RTSeismogramDisplayTask.this.playButton.doClick();
            }
            this.setFinished();
        }
    }
}

