/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.BoxArea;
import edu.iris.Fissures.GlobalArea;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventSeqIterHolder;
import edu.iris.Fissures.PointDistanceArea;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.ProxyEventDC;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.BuildVersion;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.BoxAreaDisplay;
import edu.sc.seis.gee.task.CheckListBox;
import edu.sc.seis.gee.task.EventDestination;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.OpenMapTask;
import edu.sc.seis.gee.task.SAXTask;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.TaskUtils;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.sod.source.event.FdsnEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.text.DateFormatter;
import net.sf.nachocalendar.CalendarFactory;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DateField;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class QueryEventsTask
implements GUITask,
SAXTask {
    private static DateFormat configTimeParser = new SimpleDateFormat("yyyy-MM-dd");
    private int initialMinDepth = 0;
    private int initialMaxDepth = 1000;
    private float initialMinMag = 0.0f;
    private float initialMaxMag = 10.0f;
    private Date initialEndTime = ClockUtil.now();
    private int initialMinLat = -90;
    private int initialMaxLat = 90;
    private int initialMinLon = -180;
    private int initialMaxLon = 180;
    private Date initialStartTime = ClockUtil.now().subtract(new TimeInterval(1.0, UnitImpl.WEEK));
    private TimeEditor timeEditor;
    private BoxAreaDisplay boxArea;
    private DepthEditor depthEditor;
    private MagnitudeEditor magEditor;
    private CatalogEditor catEditor;
    private boolean disabled = false;
    private JComponent panel = null;
    private Map configParams;
    private EventDestination[] eventDestinations;
    private ProxyEventDC eventdc = null;
    public static final TimeInterval QUERY_INCREMENT = new TimeInterval(4.0, UnitImpl.WEEK);
    String serverDNS;
    String serverName;
    EventQuery query;
    protected boolean guiInitialized = false;
    private static Logger logger = Logger.getLogger(QueryEventsTask.class);
    private static final Insets HORIZONTAL_SPACER = new Insets(0, 5, 0, 5);
    private static final Insets ZERO = new Insets(0, 0, 0, 0);
    private static final String KILOMETER = "kilometers";
    private static final String METER = "meters";
    private static final String[] types = new String[]{"LG", "M", "MB", "MBL", "MD", "ML", "MS", "MsZ", "MW"};

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public JComponent getGUI() {
        this.disabled = false;
        if (!this.guiInitialized && this.panel == null) {
            this.guiInitialized = true;
            this.panel = this.createGUI();
        }
        return this.panel;
    }

    @Override
    public synchronized void invoke() {
        this.disabled = false;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        CommonAccess ca = CommonAccess.getCommonAccess();
        this.configParams = params;
        this.serverDNS = (String)this.configParams.get("serverDNS");
        this.serverName = (String)this.configParams.get("serverName");
        if (this.serverDNS == null || this.serverDNS.length() == 0 || this.serverName == null || this.serverName.length() == 0) {
            throw new ConfigurationException("Invlaid server specification: dns=" + this.serverDNS + " name=" + this.serverName);
        }
        String[] eventDestinationIds = TaskUtils.getParamStartsWith("eventDestinationId_", this.configParams);
        this.eventDestinations = new EventDestination[eventDestinationIds.length];
        for (int i = 0; i < eventDestinationIds.length; ++i) {
            TaskAction eventDestAction = ca.getTaskAction(eventDestinationIds[i]);
            if (eventDestAction != null) {
                this.eventDestinations[i] = (EventDestination)((Object)eventDestAction.getTask());
                continue;
            }
            logger.warn((Object)("Can't load event destination task for id=" + eventDestinationIds[i]));
        }
        if (params.containsKey("minDepth")) {
            this.initialMinDepth = Integer.parseInt((String)params.get("minDepth"));
        }
        if (params.containsKey("maxDepth")) {
            this.initialMaxDepth = Integer.parseInt((String)params.get("maxDepth"));
        }
        if (params.containsKey("minMag")) {
            this.initialMinMag = Float.parseFloat((String)params.get("minMag"));
        }
        if (params.containsKey("maxMag")) {
            this.initialMaxMag = Float.parseFloat((String)params.get("maxMag"));
        }
        if (params.containsKey("minLat")) {
            this.initialMinLat = Integer.parseInt((String)params.get("minLat"));
        }
        if (params.containsKey("maxLat")) {
            this.initialMaxLat = Integer.parseInt((String)params.get("maxLat"));
        }
        if (params.containsKey("minLon")) {
            this.initialMinLon = Integer.parseInt((String)params.get("minLon"));
        }
        if (params.containsKey("maxLon")) {
            this.initialMaxLon = Integer.parseInt((String)params.get("maxLon"));
        }
        if (params.containsKey("map")) {
            TaskAction mapTaskAction = ca.getTaskAction((String)params.get("map"));
            OpenMapTask mapTask = (OpenMapTask)mapTaskAction.getTask();
            this.boxArea = new BoxAreaDisplay(this.initialMinLat, this.initialMinLon, this.initialMaxLat, this.initialMaxLon, mapTask);
        } else {
            this.boxArea = new BoxAreaDisplay(this.initialMinLat, this.initialMinLon, this.initialMaxLat, this.initialMaxLon);
        }
        this.timeEditor = new TimeEditor();
        this.depthEditor = new DepthEditor();
        this.magEditor = new MagnitudeEditor();
        this.catEditor = new CatalogEditor();
        this.query = new EventQuery();
    }

    protected JComponent createGUI() {
        Box b = Box.createVerticalBox();
        b.add(this.timeEditor);
        b.add(this.boxArea);
        b.add(this.depthEditor);
        b.add(this.magEditor);
        b.add(Box.createVerticalStrut(10));
        b.add(this.catEditor);
        b.add(Box.createVerticalStrut(10));
        final JButton getEventsButton = new JButton("Get Earthquakes");
        getEventsButton.setFont(getEventsButton.getFont().deriveFont(1));
        Box getEventsBox = Box.createHorizontalBox();
        getEventsBox.add(Box.createHorizontalGlue());
        getEventsBox.add(getEventsButton);
        getEventsBox.add(Box.createHorizontalGlue());
        b.add(getEventsBox);
        b.add(Box.createVerticalStrut(10));
        final JLabel statusLabel = new JLabel("Status:");
        Box statusBox = Box.createHorizontalBox();
        statusBox.add(statusLabel);
        statusBox.add(Box.createHorizontalGlue());
        b.add(statusBox);
        getEventsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                getEventsButton.setEnabled(false);
                getEventsButton.setText("Getting Earthquakes");
                statusLabel.setText("Status: ");
                try {
                    WorkerThreadPool.getDefaultPool().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ProxyEventAccessOperations[] events = QueryEventsTask.this.queryEvents();
                                statusLabel.setText("Status: found " + events.length + " events.");
                            }
                            catch (NoNetworkException ee) {
                                ee.showMessage();
                            }
                            catch (Throwable ee) {
                                GlobalExceptionHandler.handle((String)"Unable to query for events", (Throwable)ee);
                            }
                            finally {
                                getEventsButton.setEnabled(true);
                                getEventsButton.setText("Get Earthquakes");
                            }
                        }
                    });
                }
                catch (Throwable ee) {
                    GlobalExceptionHandler.handle((Throwable)ee);
                }
            }
        });
        return b;
    }

    public ProxyEventAccessOperations[] queryEvents() throws ConfigurationException, NoNetworkException {
        Date endingDate;
        Date startingDate = this.timeEditor.getStart();
        if (startingDate.after(endingDate = this.timeEditor.getEnd())) {
            this.timeConflictError();
        }
        Area area = this.boxArea.getArea();
        Time startTime = new MicroSecondDate(startingDate).getFissuresTime();
        Time endTime = new MicroSecondDate(endingDate).getFissuresTime();
        TimeRange timeRange = new TimeRange(startTime, endTime);
        QuantityImpl minDepth = this.depthEditor.getMin();
        QuantityImpl maxDepth = this.depthEditor.getMax();
        String[] magTypes = new String[]{};
        System.err.println("Bad, mag types not from list");
        float minMag = this.magEditor.getMin();
        float maxMag = this.magEditor.getMax();
        String[] catalogs = this.catEditor.getCatalogs();
        String[] contributors = new String[]{};
        return this.queryEvents(area, (Quantity)minDepth, (Quantity)maxDepth, timeRange, magTypes, minMag, maxMag, catalogs, contributors);
    }

    public ProxyEventAccessOperations[] queryEvents(Area area, Quantity minDepth, Quantity maxDepth, TimeRange timeRange, String[] magTypes, float minMagnitude, float maxMagnitude, String[] catalogs, String[] contributors) throws ConfigurationException, NoNetworkException {
        return this.query.query(area, minDepth, maxDepth, timeRange, magTypes, minMagnitude, maxMagnitude, catalogs, contributors);
    }

    public EventAccessOperations[] queryEvents(Quantity minDepth, Quantity maxDepth, TimeRange timeRange, float minMagnitude, float maxMagnitude) throws ConfigurationException, NoNetworkException {
        String[] magTypes = new String[]{};
        String[] catalogs = new String[]{};
        String[] contributors = new String[]{};
        return this.queryEvents((Area)new GlobalAreaImpl(), minDepth, maxDepth, timeRange, magTypes, minMagnitude, maxMagnitude, catalogs, contributors);
    }

    public void updateEventDestinations(EventAccessOperations[] eventAccess) {
        for (int i = 0; i < this.eventDestinations.length; ++i) {
            this.eventDestinations[i].updateEvents(eventAccess);
        }
    }

    protected void appendEventDestinations(EventAccessOperations[] eventAccess) {
        if (eventAccess.length != 0) {
            for (int i = 0; i < this.eventDestinations.length; ++i) {
                this.eventDestinations[i].appendEvents(eventAccess);
            }
        }
    }

    private void populateUnitField(JComboBox comboBox) {
        comboBox.addItem(KILOMETER);
        comboBox.addItem(METER);
    }

    public Date getStartTime() {
        return this.timeEditor.getStart();
    }

    public Date getEndTime() {
        return this.timeEditor.getEnd();
    }

    public void timeConflictError() {
        JOptionPane.showMessageDialog(null, "The time range you selected is invalid! \nPlease make sure that the start time \nis before the end time.", "GEE", 2);
    }

    public void setStartTime(Date d) {
        this.timeEditor.setStart(d);
    }

    public void setEndTime(Date d) {
        this.timeEditor.setEnd(d);
    }

    @Override
    public AbstractHandler getConfigureHandler(String name, XMLReader parser, AbstractHandler parent) {
        return new DateParser(parser, parent, name);
    }

    static /* synthetic */ String[] access$900() {
        return types;
    }

    static /* synthetic */ float access$1000(QueryEventsTask x0) {
        return x0.initialMinMag;
    }

    static /* synthetic */ float access$1100(QueryEventsTask x0) {
        return x0.initialMaxMag;
    }

    class CatalogLoader
    implements Runnable {
        CheckListBox catalogDialog;

        CatalogLoader(CheckListBox catalogDialog) {
            this.catalogDialog = catalogDialog;
        }

        @Override
        public void run() {
            try {
                if (QueryEventsTask.this.disabled) {
                    return;
                }
                System.err.println("Bad, catalogs are not dynamic");
                String[] catalogTypes = new String[]{"NEIC PDE"};
                for (int i = 0; i < catalogTypes.length; ++i) {
                    this.catalogDialog.addItem(catalogTypes[i]);
                }
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Problem loading catalogs and contributors from Event service", (Throwable)e);
            }
        }
    }

    private class EventQuery
    extends AbstractJob {
        public EventQuery() {
            super("Event Query to " + QueryEventsTask.this.serverName);
            JobTracker.getTracker().add((Job)this);
            this.setFinished(true);
        }

        public ProxyEventAccessOperations[] query(Area area, Quantity minDepth, Quantity maxDepth, TimeRange timeRange, String[] magTypes, float minMagnitude, float maxMagnitude, String[] catalogs, String[] contributors) throws ConfigurationException, NoNetworkException {
            try {
                if (NetworkGateKeeper.accessAllowed() && !QueryEventsTask.this.disabled) {
                    this.setFinished(false);
                    EventSeqIterHolder iter = new EventSeqIterHolder();
                    this.setStatus("Getting events");
                    if (QueryEventsTask.this.disabled) {
                        ProxyEventAccessOperations[] proxyEventAccessOperationsArray = new ProxyEventAccessOperations[]{};
                        return proxyEventAccessOperationsArray;
                    }
                    MicroSecondDate start = new MicroSecondDate(timeRange.start_time);
                    MicroSecondDate end = new MicroSecondDate(timeRange.end_time);
                    MicroSecondDate useStartTime = start;
                    MicroSecondDate useEndTime = useStartTime.add(QUERY_INCREMENT);
                    if (useEndTime.after((Date)end)) {
                        useEndTime = end;
                    }
                    ProxyEventAccessOperations[] eventAccess = new ProxyEventAccessOperations[]{};
                    FDSNEventQueryParams qp = new FDSNEventQueryParams();
                    if (!(area instanceof GlobalArea)) {
                        if (area instanceof BoxArea) {
                            BoxArea box = (BoxArea)area;
                            qp.area(box.min_latitude, box.max_latitude, box.min_longitude, box.max_longitude);
                        } else if (area instanceof PointDistanceArea) {
                            PointDistanceArea pd = (PointDistanceArea)area;
                            qp.donut(pd.latitude, pd.longitude, (float)((QuantityImpl)pd.min_distance).getValue(UnitImpl.DEGREE), (float)((QuantityImpl)pd.max_distance).getValue(UnitImpl.DEGREE));
                        }
                    }
                    qp.setMinDepth((float)((QuantityImpl)minDepth).getValue(UnitImpl.KILOMETER));
                    qp.setMaxDepth((float)((QuantityImpl)maxDepth).getValue(UnitImpl.KILOMETER));
                    qp.setStartTime((Date)new MicroSecondDate(timeRange.start_time));
                    qp.setEndTime((Date)new MicroSecondDate(timeRange.end_time));
                    qp.setMinMagnitude(minMagnitude);
                    qp.setMaxMagnitude(maxMagnitude);
                    try {
                        logger.info((Object)("Events: " + qp.formURI()));
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    FdsnEvent fdsnEvent = new FdsnEvent(qp);
                    fdsnEvent.setLag(new TimeInterval(0.0, UnitImpl.SECOND));
                    fdsnEvent.setUserAgent("GEE/" + BuildVersion.getVersion());
                    FdsnEvent source = fdsnEvent;
                    boolean firstLoop = true;
                    while (source.getWaitBeforeNext().getValue() == 0.0 && source.hasNext()) {
                        CacheEvent[] events = source.next();
                        if (firstLoop) {
                            QueryEventsTask.this.updateEventDestinations((EventAccessOperations[])events);
                            firstLoop = false;
                        } else {
                            QueryEventsTask.this.appendEventDestinations((EventAccessOperations[])events);
                        }
                        ProxyEventAccessOperations[] tmp = new ProxyEventAccessOperations[eventAccess.length + events.length];
                        System.arraycopy(eventAccess, 0, tmp, 0, eventAccess.length);
                        System.arraycopy(events, 0, tmp, eventAccess.length, events.length);
                        eventAccess = tmp;
                    }
                    this.setFinished();
                    ProxyEventAccessOperations[] proxyEventAccessOperationsArray = eventAccess;
                    return proxyEventAccessOperationsArray;
                }
                this.setFinished();
                if (QueryEventsTask.this.disabled) {
                    ProxyEventAccessOperations[] proxyEventAccessOperationsArray = new ProxyEventAccessOperations[]{};
                    return proxyEventAccessOperationsArray;
                }
                throw new NoNetworkException();
            }
            finally {
                this.setFinished();
            }
        }

        public String toString() {
            return "Query on " + QueryEventsTask.this.serverDNS + "/" + QueryEventsTask.this.serverName;
        }

        public void runJob() {
        }
    }

    private class CatalogEditor
    extends JPanel {
        private CheckListBox catalogs;

        public CatalogEditor() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createHorizontalGlue());
            String[] catalogTypes = new String[]{};
            for (String key : QueryEventsTask.this.configParams.keySet()) {
                Object next = QueryEventsTask.this.configParams.get(key);
                if (!(next instanceof String) || !key.startsWith("selectedCatalog_")) continue;
                String[] tmpStr = new String[catalogTypes.length + 1];
                System.arraycopy(catalogTypes, 0, tmpStr, 0, catalogTypes.length);
                catalogTypes = tmpStr;
                catalogTypes[catalogTypes.length - 1] = (String)next;
            }
            this.catalogs = new CheckListBox(catalogTypes, "Catalog");
            this.catalogs.selectAll();
            Thread t = new Thread((Runnable)new CatalogLoader(this.catalogs), "CatalogContributorLoader");
            t.start();
            JButton catalogField = new JButton("Catalog");
            catalogField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CatalogEditor.this.catalogs.show();
                }
            });
            this.add(catalogField);
            this.add(Box.createHorizontalGlue());
        }

        public String[] getCatalogs() {
            return this.catalogs.getSelectedValues();
        }
    }

    private class MagnitudeEditor
    extends JPanel {
        private CheckListBox typeDialog = new CheckListBox(QueryEventsTask.access$900(), "Magnitude Types");
        private JSpinner min = new JSpinner(new SpinnerNumberModel(QueryEventsTask.access$1000(QueryEventsTask.this), 0.0, 10.0, 1.0));
        private JSpinner max = new JSpinner(new SpinnerNumberModel(QueryEventsTask.access$1100(QueryEventsTask.this), 0.0, 10.0, 1.0));

        public MagnitudeEditor() {
            this.setBorder(new TitledBorder("Magnitude"));
            this.typeDialog.selectAll();
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(layout);
            JLabel from = new JLabel("From");
            constraints.gridx = 0;
            constraints.insets = HORIZONTAL_SPACER;
            layout.setConstraints(from, constraints);
            this.add(from);
            ++constraints.gridx;
            constraints.insets = ZERO;
            layout.setConstraints(this.min, constraints);
            this.add(this.min);
            JLabel to = new JLabel("to");
            ++constraints.gridx;
            constraints.insets = HORIZONTAL_SPACER;
            layout.setConstraints(to, constraints);
            this.add(to);
            ++constraints.gridx;
            constraints.insets = ZERO;
            layout.setConstraints(this.max, constraints);
            this.add(this.max);
            JLabel in = new JLabel("of");
            ++constraints.gridx;
            constraints.insets = HORIZONTAL_SPACER;
            layout.setConstraints(in, constraints);
            this.add(in);
            JButton typeField = new JButton("Type");
            typeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MagnitudeEditor.this.typeDialog.show();
                }
            });
            ++constraints.gridx;
            constraints.insets = ZERO;
            layout.setConstraints(typeField, constraints);
            this.add(typeField);
        }

        public String[] getTypes() {
            return this.typeDialog.getSelectedValues();
        }

        public float getMin() {
            return ((Double)this.min.getValue()).floatValue();
        }

        public float getMax() {
            return ((Double)this.max.getValue()).floatValue();
        }
    }

    private class TimeEditor
    extends JPanel {
        private DateField startDF;
        private DateField endDF;
        private Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

        public TimeEditor() {
            this.setBorder(new TitledBorder("Time"));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(layout);
            SimpleDateFormat dFormat = new SimpleDateFormat("MMM dd, yyyy");
            dFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            DateFormatter dateFormatter = new DateFormatter(dFormat);
            this.startDF = CalendarFactory.createDateField((DateFormatter)dateFormatter);
            this.startDF.setValue((Object)QueryEventsTask.this.initialStartTime);
            this.endDF = CalendarFactory.createDateField((DateFormatter)dateFormatter);
            this.endDF.setValue((Object)QueryEventsTask.this.initialEndTime);
            constraints.gridx = 0;
            JLabel startDateLabel = new JLabel("From ");
            constraints.insets = HORIZONTAL_SPACER;
            layout.setConstraints(startDateLabel, constraints);
            this.add(startDateLabel);
            ++constraints.gridx;
            constraints.insets = ZERO;
            constraints.ipadx = 10;
            layout.setConstraints((Component)this.startDF, constraints);
            this.add((Component)this.startDF);
            JLabel endDateLabel = new JLabel("to");
            ++constraints.gridx;
            constraints.insets = HORIZONTAL_SPACER;
            constraints.ipadx = 0;
            layout.setConstraints(endDateLabel, constraints);
            this.add(endDateLabel);
            ++constraints.gridx;
            constraints.insets = ZERO;
            constraints.ipadx = 10;
            layout.setConstraints((Component)this.endDF, constraints);
            this.add((Component)this.endDF);
        }

        public Date getStart() {
            Date start = this.getDate(this.startDF, true);
            return start;
        }

        public Date getEnd() {
            Date end = this.getDate(this.endDF, false);
            return end;
        }

        public Date getDate(DateField control, boolean isStart) {
            try {
                return this.setTimeOnDate(CalendarUtils.convertToDate((Object)control.getValue()), isStart);
            }
            catch (ParseException e) {
                GlobalExceptionHandler.handle((String)"problem setting end date. returning now as the date", (Throwable)e);
                return ClockUtil.now();
            }
        }

        public void setStart(Date d) {
            this.setDate(this.startDF, d, true);
        }

        public void setEnd(Date d) {
            this.setDate(this.endDF, d, false);
        }

        private void setDate(DateField control, Date d, boolean isStart) {
            control.setValue((Object)this.setTimeOnDate(d, isStart));
        }

        private Date setTimeOnDate(Date d, boolean isStart) {
            this.cal.setTime(d);
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            int millis = 0;
            if (!isStart) {
                hours = 23;
                minutes = 59;
                seconds = 59;
                millis = 999;
            }
            this.cal.set(11, hours);
            this.cal.set(12, minutes);
            this.cal.set(13, seconds);
            this.cal.set(14, millis);
            MicroSecondDate adjDate = new MicroSecondDate(this.cal.getTime());
            return adjDate;
        }
    }

    private class DepthEditor
    extends JPanel {
        private JSpinner min;
        private JSpinner max;
        private JComboBox unit;

        public DepthEditor() {
            this.min = new JSpinner(new SpinnerNumberModel(QueryEventsTask.this.initialMinDepth, 0, 1000, 100));
            this.max = new JSpinner(new SpinnerNumberModel(QueryEventsTask.this.initialMaxDepth, 0, 1000, 100));
            this.unit = new JComboBox();
            this.setBorder(new TitledBorder("Depth"));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(layout);
            JLabel from = new JLabel("From");
            constraints.gridx = 0;
            constraints.insets = HORIZONTAL_SPACER;
            layout.setConstraints(from, constraints);
            this.add(from);
            ++constraints.gridx;
            constraints.insets = ZERO;
            layout.setConstraints(this.min, constraints);
            this.add(this.min);
            JLabel to = new JLabel("to");
            ++constraints.gridx;
            constraints.insets = HORIZONTAL_SPACER;
            layout.setConstraints(to, constraints);
            this.add(to);
            ++constraints.gridx;
            constraints.insets = ZERO;
            layout.setConstraints(this.max, constraints);
            this.add(this.max);
            JLabel in = new JLabel("in");
            ++constraints.gridx;
            constraints.insets = HORIZONTAL_SPACER;
            layout.setConstraints(in, constraints);
            this.add(in);
            QueryEventsTask.this.populateUnitField(this.unit);
            this.unit.setEditable(false);
            ++constraints.gridx;
            constraints.insets = ZERO;
            layout.setConstraints(this.unit, constraints);
            this.add(this.unit);
        }

        public QuantityImpl getMin() {
            return this.getQuantity((Integer)this.min.getValue());
        }

        public QuantityImpl getMax() {
            return this.getQuantity((Integer)this.max.getValue());
        }

        private QuantityImpl getQuantity(int val) {
            return new QuantityImpl((double)val, (Unit)this.getUnit());
        }

        private UnitImpl getUnit() {
            String selectedUnit = (String)this.unit.getSelectedItem();
            if (selectedUnit.equals(QueryEventsTask.KILOMETER)) {
                return UnitImpl.KILOMETER;
            }
            return UnitImpl.METER;
        }
    }

    private class DateParser
    extends AbstractHandler {
        private double value;
        private String name;
        private UnitImpl timeUnit;
        private MicroSecondDate d;
        private String lastString;

        private DateParser(XMLReader parser, AbstractHandler parent, String name) {
            super(parser, parent);
            this.value = 0.0;
            this.timeUnit = UnitImpl.DAY;
            this.d = ClockUtil.now();
            this.name = name;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("date")) {
                try {
                    this.d = new MicroSecondDate(configTimeParser.parse(this.lastString));
                }
                catch (ParseException e) {
                    throw new SAXException("Unable to parse " + this.lastString + " as an event query time.  It must be in the form yyyy-mm-dd", e);
                }
            } else if (localName.equals("unit")) {
                try {
                    this.timeUnit = UnitImpl.getUnitFromString((String)this.lastString);
                }
                catch (NoSuchFieldException e) {
                    throw new SAXException("Unable to find a unit named " + this.lastString + ". It must be the name of a field in UnitImpl.", e);
                }
            } else if (localName.equals("value")) {
                this.value = Double.parseDouble(this.lastString);
            } else {
                super.endElement(namespaceURI, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.lastString = new String(ch, start, length);
        }

        @Override
        public void finished() {
            this.d = this.d.subtract(new TimeInterval(this.value, this.timeUnit));
            if (this.name.equals("startTime")) {
                QueryEventsTask.this.initialStartTime = (Date)this.d;
            } else if (this.name.equals("endTime")) {
                QueryEventsTask.this.initialEndTime = (Date)this.d;
            }
        }

        public MicroSecondDate getDate() {
            return this.d;
        }
    }
}

