/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.tools.OpenMapTool;
import edu.sc.seis.fissuresUtil.map.tools.PanTool;
import edu.sc.seis.fissuresUtil.map.tools.ZoomTool;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.CursorUtil;
import edu.sc.seis.gee.task.OpenMapTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.Cursor;
import java.awt.Point;
import java.util.Map;

public class OpenMapToolTask
implements Task {
    private Map configParams;
    private String toolType;
    private OpenMap openMap;
    private MapMouseMode omTool;
    private Cursor modeCursor;
    private Cursor pressedCursor;
    public static final Point HOTPOINT_32X32 = new Point(16, 16);
    public static final Point HOTPOINT_24X24 = new Point(12, 12);
    public static final Point HOTPOINT_16X16 = new Point(8, 8);

    @Override
    public void invoke() throws Exception {
        if (this.toolType.equals("resetZoom")) {
            ((ZoomTool)this.omTool).reset();
        } else {
            this.openMap.setActiveMouseMode(this.omTool);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        String imageFilePath;
        this.configParams = params;
        String openMapTaskId = (String)params.get("openmaptask");
        if (openMapTaskId == null || openMapTaskId.length() == 0) {
            throw new ConfigurationException("OpenMap Task must be set in config file, OpenMapTask id = '" + openMapTaskId + "'");
        }
        TaskAction openMapTaskAction = CommonAccess.getCommonAccess().getTaskAction(openMapTaskId);
        OpenMapTask openMapTask = (OpenMapTask)openMapTaskAction.getTask();
        this.openMap = openMapTask.getOpenMap();
        if (!params.containsKey("toolType")) {
            throw new ConfigurationException("no tool specified");
        }
        this.toolType = (String)params.get("toolType");
        float x = 0.5f;
        float y = 0.5f;
        if (params.containsKey("hotspot_offset_x")) {
            String xString = (String)params.get("hotspot_offset_x");
            x = Float.parseFloat(xString);
        }
        if (params.containsKey("hotspot_offset_y")) {
            String yString = (String)params.get("hotspot_offset_y");
            y = Float.parseFloat(yString);
        }
        if (params.containsKey("modeCursor")) {
            imageFilePath = (String)params.get("modeCursor");
            imageFilePath = "edu/sc/seis/gee/data/images/" + imageFilePath;
            this.modeCursor = CursorUtil.getCursor(this.toolType, imageFilePath, x, y);
        } else {
            this.modeCursor = Cursor.getDefaultCursor();
        }
        if (params.containsKey("pressedCursor")) {
            imageFilePath = (String)params.get("pressedCursor");
            imageFilePath = "edu/sc/seis/gee/data/images/" + imageFilePath;
            this.pressedCursor = CursorUtil.getCursor(this.toolType + "pressedCursor", imageFilePath, x, y);
        } else {
            this.pressedCursor = Cursor.getDefaultCursor();
        }
        double zoomFactor = 1.0;
        if (this.toolType.startsWith("zoom")) {
            try {
                zoomFactor = Double.parseDouble((String)params.get("zoomFactor"));
            }
            catch (Exception e) {
                throw new ConfigurationException("no zoom factor set, or it is malformed", e);
            }
            this.omTool = new ZoomTool(this.openMap, (float)zoomFactor, this.toolType);
            this.setCursors();
        } else if (this.toolType.equals("resetZoom")) {
            this.omTool = new ZoomTool(this.openMap, (float)zoomFactor, this.toolType);
        } else if (this.toolType.equals("pan")) {
            this.omTool = new PanTool(this.openMap);
            this.setCursors();
        } else if (this.toolType.equals("selection")) {
            this.omTool = new SelectMouseMode();
        } else {
            throw new ConfigurationException(this.toolType + ": no such tool");
        }
        this.openMap.addMouseMode(this.omTool);
        if (this.toolType.equals("selection")) {
            this.openMap.setActiveMouseMode(this.omTool);
        }
    }

    public MapMouseMode getTool() {
        return this.omTool;
    }

    private void setCursors() {
        OpenMapTool omt = (OpenMapTool)this.omTool;
        omt.setModeCursor(this.modeCursor);
        omt.setPressedCursor(this.pressedCursor);
    }
}

