/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.DisplayAllTask;
import edu.sc.seis.gee.task.EventSeismogramTask;
import edu.sc.seis.gee.task.ShowEventsTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.util.Map;
import javax.swing.JOptionPane;

public class MapToDisplayTask
implements Task {
    private TaskAction colSeisTaskAction;
    private ShowEventsTask showEvents;
    private EventSeismogramTask eventSeisTask;
    private DisplayAllTask autoDisplay;
    private TaskAction chanChooserAction;

    @Override
    public void configure(Map params) throws ConfigurationException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)params.get("autoDisplayTask");
        TaskAction taskAction = commonAccess.getTaskAction(taskId);
        this.autoDisplay = (DisplayAllTask)taskAction.getTask();
        taskId = (String)params.get("showEvents");
        taskAction = commonAccess.getTaskAction(taskId);
        this.showEvents = (ShowEventsTask)taskAction.getTask();
        taskId = (String)params.get("timeForEarthquake");
        taskAction = commonAccess.getTaskAction(taskId);
        this.eventSeisTask = (EventSeismogramTask)taskAction.getTask();
        taskId = (String)params.get("chanChooser");
        this.chanChooserAction = commonAccess.getTaskAction(taskId);
        if (params.containsKey("dispEnclosingTask")) {
            taskId = (String)params.get("dispEnclosingTask");
            this.colSeisTaskAction = commonAccess.getTaskAction(taskId);
        }
    }

    @Override
    public void invoke() throws Exception {
        EventAccessOperations[] event = this.showEvents.getSelectedEvents();
        if (event.length == 0) {
            JOptionPane.showMessageDialog(null, "You must select at least one event(circle) from the map before trying to load seismograms", "No Event Selected", 2);
        } else {
            MicroSecondDate oTime = new MicroSecondDate(event[0].get_preferred_origin().getOriginTime());
            ChannelChooser chanChooser = ((ChannelChooserTask)this.chanChooserAction.getTask()).getChannelChooser();
            if (chanChooser.getSelectedChannels(oTime).length != 0) {
                this.colSeisTaskAction.checkDisplayLocation(true);
                this.eventSeisTask.loadSeismograms(event, "First P-wave", -2.0, "First S-wave", 10.0, this.autoDisplay);
            } else if (chanChooser.getSelectedStations(oTime).length != 0) {
                JOptionPane.showMessageDialog(null, "The stations you selected do not have any channels that match your selection at the time of the event so GEE cannot load seismograms.", "No Matching Channels", 2);
            } else {
                JOptionPane.showMessageDialog(null, "You must select at least one seismograph station (blue triangles) from the map before trying to load seismograms.", "No Stations Selected", 2);
            }
        }
    }

    @Override
    public void destroy() {
    }
}

