/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.IntervalChooser;
import edu.sc.seis.fissuresUtil.chooser.IntervalChooserOptions;
import edu.sc.seis.fissuresUtil.dataset.Organizer;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.DisplayAllTask;
import edu.sc.seis.gee.task.LoadSeismogram;
import edu.sc.seis.gee.task.ShowEventsTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.TauP;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Category;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class EventSeismogramTask
extends JPanel
implements Task {
    private String originPhase = "Origin Time";
    private String firstPPhase = "First P-wave";
    private String firstSPhase = "First S-wave";
    private IntervalChooser beginOffSet;
    private IntervalChooser endOffSet;
    private JComboBox beginPhase;
    private JComboBox endPhase;
    private boolean guiInitialized = false;
    protected Map configParams;
    private ShowEventsTask showEventsTask;
    private LoadSeismogram loadSeismogramTask;
    protected ChannelChooserTask channelChooserTask;
    private JProgressBar progressBar = new JProgressBar();
    private Thread progressOwner = null;
    private TauP taup = new TauP("");
    protected WorkerThreadPool seisLoader = new WorkerThreadPool("Event Seismogram Loader", 2);
    static Category logger = Category.getInstance((String)EventSeismogramTask.class.getName());

    @Override
    public void invoke() throws Exception {
        if (!this.guiInitialized) {
            this.guiInitialized = true;
            this.createGUI();
        }
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.configParams = params;
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)params.get("showEventsTask");
        TaskAction taskAction = commonAccess.getTaskAction(taskId);
        this.showEventsTask = (ShowEventsTask)taskAction.getTask();
        taskId = (String)params.get("loadSeismogramTask");
        taskAction = commonAccess.getTaskAction(taskId);
        this.loadSeismogramTask = (LoadSeismogram)taskAction.getTask();
        taskId = (String)params.get("channelChooserTask");
        taskAction = commonAccess.getTaskAction(taskId);
        this.channelChooserTask = (ChannelChooserTask)taskAction.getTask();
        if (this.showEventsTask == null) {
            throw new ConfigurationException("Invalid configuration, showEventsTask must not be null");
        }
        if (this.loadSeismogramTask == null) {
            throw new ConfigurationException("Invalid configuration, loadSeismogramTask must not be null");
        }
        if (this.channelChooserTask == null) {
            throw new ConfigurationException("Invalid configuration, channelChooserTask must not be null");
        }
    }

    @Override
    public void destroy() {
    }

    private void createGUI() {
        GridBagLayout bagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JButton okButton = new JButton("Load Seismograms");
        JPanel endPanel = new JPanel();
        endPanel.setLayout(new FlowLayout());
        endPanel.add(okButton);
        JLabel beginLabel = new JLabel("Begin");
        JLabel endLabel = new JLabel("End");
        JLabel phaseLabel = new JLabel("Phase");
        JLabel offsetLabel = new JLabel("offSet");
        this.beginPhase = new JComboBox();
        this.endPhase = new JComboBox();
        IntervalChooserOptions[] beginOffsetOptions = new IntervalChooserOptions[]{IntervalChooserOptions.SECOND, IntervalChooserOptions.MINUTE};
        IntervalChooserOptions[] endOffsetOptions = new IntervalChooserOptions[]{IntervalChooserOptions.SECOND, IntervalChooserOptions.MINUTE};
        this.beginOffSet = new IntervalChooser(beginOffsetOptions);
        this.endOffSet = new IntervalChooser(endOffsetOptions);
        this.beginOffSet.setEditable(true);
        this.endOffSet.setEditable(true);
        this.beginOffSet.setSelectedValue(-2);
        this.endOffSet.setSelectedValue(10);
        this.populatePhases(this.beginPhase);
        this.populatePhases(this.endPhase);
        this.beginPhase.setSelectedItem(this.firstPPhase);
        this.endPhase.setSelectedItem(this.firstSPhase);
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.setLayout(bagLayout);
        ++constraints.gridx;
        this.add((Component)phaseLabel, constraints);
        ++constraints.gridx;
        bagLayout.setConstraints(offsetLabel, constraints);
        this.add((Component)offsetLabel, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)beginLabel, constraints);
        ++constraints.gridx;
        this.add((Component)this.beginPhase, constraints);
        ++constraints.gridx;
        this.add((Component)this.beginOffSet, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)endLabel, constraints);
        ++constraints.gridx;
        this.add((Component)this.endPhase, constraints);
        ++constraints.gridx;
        this.add((Component)this.endOffSet, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 0;
        this.add((Component)endPanel, constraints);
        ++constraints.gridy;
        this.add((Component)this.progressBar, constraints);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventSeismogramTask.this.getSeismograms();
            }
        });
    }

    protected void getSeismograms() {
        if (this.progressOwner != null) {
            return;
        }
        EventAccessOperations[] eventAccess = this.showEventsTask.getSelectedEvents();
        if (eventAccess == null || eventAccess.length == 0) {
            JOptionPane.showMessageDialog(null, "No Events Selected. Select Events First From the Task Select Events", "No Selected Events", 1);
        }
        String bPhase = (String)this.beginPhase.getSelectedItem();
        String ePhase = (String)this.endPhase.getSelectedItem();
        TimeInterval beginInterval = this.beginOffSet.getInterval();
        TimeInterval endInterval = this.endOffSet.getInterval();
        this.seisLoader.invokeLater((Runnable)((Object)new SeismogramLoader(eventAccess, bPhase, beginInterval, ePhase, endInterval, this.taup)));
    }

    private void populatePhases(JComboBox comboBox) {
        String[] phases = new String[]{this.originPhase, this.firstPPhase, this.firstSPhase};
        for (int i = 0; i < phases.length; ++i) {
            comboBox.addItem(phases[i]);
        }
    }

    public void populateLocalDataSet(EventAccessOperations event, DataSetSeismogram seismogram, Channel channel) {
        Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
        AuditInfo[] audit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name", "GEE"), "loaded from EventSeismogram Task")};
        organizer.addSeismogram(seismogram, event, audit);
        organizer.addChannel(channel, event, audit);
    }

    public void populateLocalDataSet(CacheEvent cacheEvent, Channel[] channels, Time start_time, Time end_time) throws ConfigurationException, NotFound, CannotProceed, InvalidName, org.omg.CORBA.ORBPackage.InvalidName, NoNetworkException {
        Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
        for (int counter = 0; counter < channels.length; ++counter) {
            RequestFilter rf = new RequestFilter(channels[counter].get_id(), start_time, end_time);
            DataSetSeismogram dss = this.loadSeismogramTask.retrieveSeismogram(rf);
            if (dss == null) continue;
            dss.setName("DSS_" + ChannelIdUtil.toStringNoDates((ChannelId)channels[counter].get_id()));
            AuditInfo[] audit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded channel.")};
            organizer.addChannel(channels[counter], (EventAccessOperations)cacheEvent, audit);
            audit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded seismogram for event.")};
            organizer.addSeismogram(dss, (EventAccessOperations)cacheEvent, audit);
        }
    }

    protected void loadSeismograms(EventAccessOperations[] eventAccess, String bPhase, double timeBeforeBPhase, String ePhase, double timeAfterEPhase, DisplayAllTask display) {
        TimeInterval beginInterval = new TimeInterval(timeBeforeBPhase, UnitImpl.MINUTE);
        TimeInterval endInterval = new TimeInterval(timeAfterEPhase, UnitImpl.MINUTE);
        this.seisLoader.invokeLater((Runnable)((Object)new SeismogramLoader(eventAccess, bPhase, beginInterval, ePhase, endInterval, this.taup, display)));
    }

    protected void loadSeismograms(EventAccessOperations[] eventAccess, String bPhase, double timeBeforeBPhase, String ePhase, double timeAfterEPhase) {
        TimeInterval beginInterval = new TimeInterval(timeBeforeBPhase, UnitImpl.MINUTE);
        TimeInterval endInterval = new TimeInterval(timeAfterEPhase, UnitImpl.MINUTE);
        this.seisLoader.invokeLater((Runnable)((Object)new SeismogramLoader(eventAccess, bPhase, beginInterval, ePhase, endInterval, this.taup)));
    }

    protected synchronized void setProgressOwner(Thread t) {
        this.progressOwner = t;
    }

    protected synchronized void setProgressValue(Thread t, int value) {
        if (t.equals(this.progressOwner)) {
            this.progressBar.setValue(value);
        }
    }

    protected synchronized void setProgressMax(Thread t, int max) {
        if (t.equals(this.progressOwner)) {
            this.progressBar.setMaximum(max);
        }
    }

    public static Arrival[] getArrivals(Location event, Location here, String[] phases, TauP taup) {
        double distance = SphericalCoords.distance((double)here.latitude, (double)here.longitude, (double)event.latitude, (double)event.longitude);
        double depth = ((QuantityImpl)event.depth).convertTo((UnitImpl)UnitImpl.KILOMETER).value;
        return taup.calculate(distance, depth, phases);
    }

    protected class SeismogramLoader
    extends AbstractJob {
        EventAccessOperations[] eventAccess;
        String bPhase;
        TimeInterval beginInterval;
        String ePhase;
        TimeInterval endInterval;
        private TauP taup;
        private DisplayAllTask display;

        SeismogramLoader(EventAccessOperations[] eventAccess, String bPhase, TimeInterval beginInterval, String ePhase, TimeInterval endInterval, TauP taup) {
            super("Seismogram Loader");
            JobTracker.getTracker().add((Job)this);
            this.eventAccess = eventAccess;
            this.bPhase = bPhase;
            this.beginInterval = beginInterval;
            this.ePhase = ePhase;
            this.endInterval = endInterval;
            this.taup = taup;
        }

        SeismogramLoader(EventAccessOperations[] eventAccess, String bPhase, TimeInterval beginInterval, String ePhase, TimeInterval endInterval, TauP taup, DisplayAllTask display) {
            this(eventAccess, bPhase, beginInterval, ePhase, endInterval, taup);
            this.display = display;
        }

        public void runJob() {
            this.setStatus("Determining phase");
            if (this.bPhase.equals(EventSeismogramTask.this.firstPPhase)) {
                this.bPhase = "ttp";
            }
            if (this.ePhase.equals(EventSeismogramTask.this.firstPPhase)) {
                this.ePhase = "ttp";
            }
            if (this.bPhase.equals(EventSeismogramTask.this.firstSPhase)) {
                this.bPhase = "tts";
            }
            if (this.ePhase.equals(EventSeismogramTask.this.firstSPhase)) {
                this.ePhase = "tts";
            }
            EventSeismogramTask.this.setProgressOwner(Thread.currentThread());
            EventSeismogramTask.this.setProgressValue(Thread.currentThread(), 0);
            this.setStatus("Getting channels");
            int numSeismograms = 0;
            Origin origin = null;
            for (int eventNum = 0; eventNum < this.eventAccess.length; ++eventNum) {
                try {
                    origin = this.eventAccess[eventNum].get_preferred_origin();
                    MicroSecondDate originTime = new MicroSecondDate(origin.getOriginTime());
                    ChannelImpl[] channels = EventSeismogramTask.this.channelChooserTask.getChannelChooser().getSelectedChannels(originTime);
                    if (channels.length == 0) {
                        String mesg = (String)EventSeismogramTask.this.configParams.get("NoStationWithDataMessage");
                        if (mesg == null) {
                            mesg = "Either no stations were selected or the selected stations are not active for this earthquake";
                        }
                        JOptionPane.showMessageDialog(null, mesg, "No stations selected", 2);
                        this.setFinished();
                        return;
                    }
                    logger.debug((Object)("The beginPhase is " + this.bPhase));
                    logger.debug((Object)("The endPhase is " + this.ePhase));
                    logger.debug((Object)("The depth is " + origin.getLocation().depth.value));
                    logger.debug((Object)("Num Channel->" + channels.length));
                    for (int channelNum = 0; channelNum < channels.length; ++channelNum) {
                        MicroSecondDate endTime;
                        MicroSecondDate startTime;
                        String channelStatus = channelNum + 1 + "/" + channels.length;
                        this.setStatus("Loading channel " + channelStatus);
                        if (!this.bPhase.equals(EventSeismogramTask.this.originPhase)) {
                            String[] phase = new String[]{this.bPhase};
                            Arrival[] beginArrivals = EventSeismogramTask.getArrivals(origin.getLocation(), channels[channelNum].getSite().getLocation(), phase, this.taup);
                            if (beginArrivals.length == 0) {
                                logger.debug((Object)("No arrivals for begin at this station " + ChannelIdUtil.toString((ChannelId)channels[channelNum].get_id())));
                                continue;
                            }
                            startTime = originTime.add(new TimeInterval(beginArrivals[0].getTime(), UnitImpl.SECOND));
                        } else {
                            startTime = new MicroSecondDate(originTime);
                        }
                        startTime = startTime.add(this.beginInterval);
                        if (!this.ePhase.equals(EventSeismogramTask.this.originPhase)) {
                            String[] phase = new String[]{this.ePhase};
                            Arrival[] endArrivals = EventSeismogramTask.getArrivals(origin.getLocation(), channels[channelNum].getSite().getLocation(), phase, this.taup);
                            if (endArrivals.length == 0) {
                                logger.debug((Object)("No arrivals for begin at this station " + ChannelIdUtil.toString((ChannelId)channels[channelNum].get_id())));
                                continue;
                            }
                            endTime = originTime.add(new TimeInterval(endArrivals[0].getTime(), UnitImpl.SECOND));
                        } else {
                            endTime = new MicroSecondDate(originTime);
                        }
                        endTime = endTime.add(this.endInterval);
                        logger.debug((Object)("Before loadSeismogram call " + ChannelIdUtil.toString((ChannelId)channels[channelNum].get_id())));
                        this.setStatus("Loading seismogram for channel " + channelStatus);
                        DataSetSeismogram seismogram = EventSeismogramTask.this.loadSeismogramTask.retrieveSeismogram(startTime.getFissuresTime(), endTime.getFissuresTime(), channels[channelNum].get_id());
                        logger.debug((Object)("After loadSeismogram call " + ChannelIdUtil.toString((ChannelId)channels[channelNum].get_id())));
                        EventSeismogramTask.this.setProgressValue(Thread.currentThread(), 2 * (eventNum * channels.length + channelNum) + 2);
                        if (seismogram != null) {
                            EventSeismogramTask.this.populateLocalDataSet(this.eventAccess[eventNum], seismogram, (Channel)channels[channelNum]);
                            if (this.display != null) {
                                this.display.display(seismogram);
                            }
                            ++numSeismograms;
                        } else {
                            logger.info((Object)("No available data for " + ChannelIdUtil.toString((ChannelId)channels[channelNum].get_id())));
                        }
                        EventSeismogramTask.this.setProgressValue(Thread.currentThread(), 2 * (eventNum * channels.length + channelNum) + 3);
                    }
                    continue;
                }
                catch (Exception ex) {
                    GlobalExceptionHandler.handle((String)"Problem trying to get seismograms.", (Throwable)ex);
                }
            }
            this.setFinished();
            EventSeismogramTask.this.setProgressValue(Thread.currentThread(), EventSeismogramTask.this.progressBar.getMaximum());
            EventSeismogramTask.this.setProgressOwner(null);
        }
    }
}

