/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import javax.swing.JOptionPane;

public abstract class DataSetCrawler {
    private DataSetBrowser dataSetBrowser;
    private TaskAction dsbAction;
    private boolean promptIfNoOpenDatasets = true;

    public void initCrawler(TaskAction dsbAction) throws ConfigurationException {
        this.dsbAction = dsbAction;
        this.dataSetBrowser = (DataSetBrowser)dsbAction.getTask();
    }

    public boolean crawlDataSets() {
        boolean doneSomething = false;
        DataSet[] dataSets = this.dataSetBrowser.getSelectedDataSets();
        for (int counter = 0; counter < dataSets.length; ++counter) {
            this.crawl(dataSets[counter]);
        }
        dataSets = this.dataSetBrowser.getOpenDataSets();
        for (int i = 0; i < dataSets.length; ++i) {
            doneSomething = true;
            this.crawl(dataSets[i]);
        }
        if (!doneSomething) {
            if (this.getDataSetsWithSeisCount(CommonAccess.getCommonAccess().getDataSetRoot()) == 1 || !this.promptIfNoOpenDatasets) {
                this.crawl(CommonAccess.getCommonAccess().getDataSetRoot());
                doneSomething = true;
            } else {
                String message = "GEE doesn't know what data you want.  You can select the data you want in the data set editor and reload,\nselect everything in the data set editor, or cancel";
                String title = "More than one data set loaded";
                Object[] options = new Object[]{"Select Everything", "Open DataSet Editor", "Cancel"};
                int choice = JOptionPane.showOptionDialog(null, message, title, 1, 2, null, options, options[0]);
                if (choice == 0) {
                    this.crawl(CommonAccess.getCommonAccess().getDataSetRoot());
                    doneSomething = true;
                } else if (choice == 1) {
                    this.dataSetBrowser.invoke();
                    try {
                        this.dsbAction.checkDisplayLocation();
                    }
                    catch (ConfigurationException e) {
                        GlobalExceptionHandler.handle((String)"something wrong with DataSetBrowser", (Throwable)e);
                    }
                }
            }
        }
        return doneSomething;
    }

    private int getDataSetsWithSeisCount(DataSet ds) {
        int count = 0;
        if (ds.getDataSetSeismogramNames().length > 0) {
            ++count;
        }
        String[] dataSetNames = ds.getDataSetNames();
        for (int i = 0; i < dataSetNames.length && count < 2; count += this.getDataSetsWithSeisCount(ds.getDataSet(dataSetNames[i])), ++i) {
        }
        return count;
    }

    public void crawl(DataSet dataset) {
        if (dataset == null) {
            return;
        }
        String[] names = dataset.getDataSetSeismogramNames();
        for (int i = 0; i < names.length; ++i) {
            this.crawlAction(dataset.getDataSetSeismogram(names[i]));
        }
        names = dataset.getDataSetNames();
        for (int num = 0; num < names.length; ++num) {
            this.crawl(dataset.getDataSet(names[num]));
        }
    }

    public void setPromptIfNoOpenDataSets(boolean prompt) {
        this.promptIfNoOpenDatasets = prompt;
    }

    public abstract void crawlAction(DataSetSeismogram var1);
}

