/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CheckBoxDialog
extends JFrame {
    private JPanel panel;
    private JPanel toolPanel;
    private JList jList;
    private JTextField textField;
    private JButton addButton;
    private JButton closeButton;
    private DefaultListModel listModel = new DefaultListModel();

    public CheckBoxDialog(String[] values, String title) {
        super(title);
        this.panel = new JPanel();
        this.toolPanel = new JPanel();
        this.textField = new JTextField(10);
        this.addButton = new JButton("Add");
        this.closeButton = new JButton("Close");
        this.jList = new JList(this.listModel);
        this.jList.setSelectionMode(2);
        this.initGUI(values);
    }

    private void initGUI(String[] values) {
        this.toolPanel.setLayout(new FlowLayout());
        this.panel.setLayout(new BorderLayout());
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckBoxDialog.this.addItem(CheckBoxDialog.this.textField.getText());
                CheckBoxDialog.this.textField.setText("");
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckBoxDialog.this.closeDialog();
            }
        });
        this.toolPanel.add(new JLabel("Enter"));
        this.toolPanel.add(this.textField);
        this.toolPanel.add(this.addButton);
        this.toolPanel.add(this.closeButton);
        for (int counter = 0; counter < values.length; ++counter) {
            this.addItem(values[counter]);
        }
        this.panel.add((Component)new JLabel("Add Entry"), "North");
        this.panel.add((Component)this.toolPanel, "South");
        JScrollPane scrollPane = new JScrollPane(this.jList);
        this.panel.add((Component)scrollPane, "Center");
        this.getContentPane().add(this.panel);
    }

    public String[] getValues() {
        DefaultListModel model = (DefaultListModel)this.jList.getModel();
        Object[] out = new String[model.getSize()];
        model.copyInto(out);
        return out;
    }

    public void addItem(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.jList.getModel();
        if (model.indexOf(value) == -1) {
            model.addElement(value);
        }
    }

    public void removeItem(String value) {
        DefaultListModel model = (DefaultListModel)this.jList.getModel();
        model.removeElement(value);
    }

    public void setItems(String[] items) {
        DefaultListModel model = (DefaultListModel)this.jList.getModel();
        model.clear();
        for (int i = 0; i < items.length; ++i) {
            model.addElement(items[i]);
        }
    }

    public int indexOf(String item) {
        DefaultListModel model = (DefaultListModel)this.jList.getModel();
        return model.indexOf(item);
    }

    public void setSelectedIndex(int i) {
        this.jList.setSelectedIndex(i);
    }

    public void selectAll() {
        DefaultListModel model = (DefaultListModel)this.jList.getModel();
        this.jList.addSelectionInterval(0, model.getSize() - 1);
    }

    public void setSelectedIndices(int[] selectedIndices) {
        DefaultListModel model = (DefaultListModel)this.jList.getModel();
        this.jList.setSelectedIndices(selectedIndices);
    }

    public void showDialog() {
        this.setSize(new Dimension(400, 400));
        this.setVisible(true);
    }

    public void closeDialog() {
        this.setVisible(false);
    }

    public String getSelectedValue() {
        return (String)this.jList.getSelectedValue();
    }

    public String[] getSelectedValues() {
        Object[] values = this.jList.getSelectedValues();
        String[] rtn = new String[values.length];
        for (int counter = 0; counter < values.length; ++counter) {
            rtn[counter] = (String)values[counter];
        }
        return rtn;
    }
}

