/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import com.bbn.openmap.LatLonPoint;
import edu.iris.Fissures.Area;
import edu.iris.Fissures.model.BoxAreaImpl;
import edu.sc.seis.gee.task.OpenMapTask;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class BoxAreaDisplay
extends JPanel {
    private JSpinner minLatCtrl;
    private JSpinner maxLatCtrl;
    private JSpinner minLonCtrl;
    private JSpinner maxLonCtrl;

    public BoxAreaDisplay() {
        this(-90, -180, 90, 180);
    }

    public BoxAreaDisplay(int minlat, int minlon, int maxlat, int maxlon) {
        this(minlat, minlon, maxlat, maxlon, null);
    }

    public BoxAreaDisplay(int minlat, int minlon, int maxlat, int maxlon, final OpenMapTask mapTask) {
        this.minLatCtrl = new JSpinner(new SpinnerNumberModel(minlat, -90, 90, 20));
        this.minLonCtrl = new JSpinner(new SpinnerNumberModel(minlon, -180, 180, 40));
        this.maxLatCtrl = new JSpinner(new SpinnerNumberModel(maxlat, -90, 90, 20));
        this.maxLonCtrl = new JSpinner(new SpinnerNumberModel(maxlon, -180, 180, 40));
        this.setBorder(new TitledBorder("Area"));
        GridBagLayout gridLayout = new GridBagLayout();
        this.setLayout(gridLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        JButton worldwide = new JButton("Entire World");
        worldwide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxAreaDisplay.this.setAreaWorldwide();
            }
        });
        constraints.insets = new Insets(2, 5, 2, 5);
        if (mapTask != null) {
            JButton fromMap = new JButton("From Map");
            fromMap.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LatLonPoint upperLeft = mapTask.getUpperLeftCorner();
                    BoxAreaDisplay.this.maxLatCtrl.setValue(new Integer((int)upperLeft.getLatitude()));
                    BoxAreaDisplay.this.minLonCtrl.setValue(new Integer((int)upperLeft.getLongitude()));
                    LatLonPoint lowerRight = mapTask.getLowerRightCorner();
                    BoxAreaDisplay.this.minLatCtrl.setValue(new Integer((int)lowerRight.getLatitude()));
                    BoxAreaDisplay.this.maxLonCtrl.setValue(new Integer((int)lowerRight.getLongitude()));
                }
            });
            gridLayout.setConstraints(worldwide, constraints);
            this.add(worldwide);
            constraints.gridy = 1;
            constraints.gridx = 0;
            gridLayout.setConstraints(fromMap, constraints);
            this.add(fromMap);
            constraints.gridheight = 2;
        } else {
            constraints.gridheight = 2;
            gridLayout.setConstraints(worldwide, constraints);
            this.add(worldwide);
            constraints.gridheight = 1;
        }
        JPanel controls = this.makeLatLonSetters();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.ipadx = 0;
        gridLayout.setConstraints(controls, constraints);
        this.add(controls);
    }

    private void setAreaWorldwide() {
        this.minLatCtrl.setValue(new Integer(-90));
        this.minLonCtrl.setValue(new Integer(-180));
        this.maxLatCtrl.setValue(new Integer(90));
        this.maxLonCtrl.setValue(new Integer(180));
    }

    private JPanel makeLatLonSetters() {
        JPanel displayPanel = new JPanel();
        GridBagLayout gridLayout = new GridBagLayout();
        displayPanel.setLayout(gridLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        JLabel minLabel = new JLabel("Minimum");
        constraints.gridx = 1;
        gridLayout.setConstraints(minLabel, constraints);
        displayPanel.add(minLabel);
        JLabel maxLabel = new JLabel("Maximum");
        constraints.gridx = 2;
        gridLayout.setConstraints(maxLabel, constraints);
        displayPanel.add(maxLabel);
        JLabel latLabel = new JLabel("Latitude");
        constraints.gridx = 0;
        constraints.gridy = 1;
        gridLayout.setConstraints(latLabel, constraints);
        displayPanel.add(latLabel);
        constraints.gridx = 1;
        gridLayout.setConstraints(this.minLatCtrl, constraints);
        displayPanel.add(this.minLatCtrl);
        constraints.gridx = 2;
        gridLayout.setConstraints(this.maxLatCtrl, constraints);
        displayPanel.add(this.maxLatCtrl);
        JLabel lonLabel = new JLabel("Longitude");
        constraints.gridy = 2;
        constraints.gridx = 0;
        gridLayout.setConstraints(lonLabel, constraints);
        displayPanel.add(lonLabel);
        constraints.gridx = 1;
        gridLayout.setConstraints(this.minLonCtrl, constraints);
        displayPanel.add(this.minLonCtrl);
        constraints.gridx = 2;
        gridLayout.setConstraints(this.maxLonCtrl, constraints);
        displayPanel.add(this.maxLonCtrl);
        return displayPanel;
    }

    private static int getInt(Object o) {
        return (Integer)o;
    }

    public Area getArea() {
        int minLat = BoxAreaDisplay.getInt(this.minLatCtrl.getValue());
        int maxLat = BoxAreaDisplay.getInt(this.maxLatCtrl.getValue());
        int minLon = BoxAreaDisplay.getInt(this.minLonCtrl.getValue());
        int maxLon = BoxAreaDisplay.getInt(this.maxLonCtrl.getValue());
        return new BoxAreaImpl((float)minLat, (float)maxLat, (float)minLon, (float)maxLon);
    }
}

