/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.queue;

import com.isti.util.queue.NotifyThread;
import java.util.Vector;

public abstract class NotifyEventQueue
extends NotifyThread {
    protected Vector m_queue = new Vector();

    public NotifyEventQueue(String idStr) {
        super(idStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(Object event) {
        Vector vector = this.m_queue;
        synchronized (vector) {
            this.m_queue.addElement(event);
            this.m_queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEventBackNoNotify(Object event) {
        Vector vector = this.m_queue;
        synchronized (vector) {
            this.m_queue.add(0, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEventNoNotify(Object event) {
        Vector vector = this.m_queue;
        synchronized (vector) {
            this.m_queue.addElement(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pullEvent() {
        Vector vector = this.m_queue;
        synchronized (vector) {
            if (this.m_queue.size() == 0) {
                return null;
            }
            return this.m_queue.remove(0);
        }
    }

    public int getQueueSize() {
        return this.m_queue.size();
    }

    public boolean isEmpty() {
        return this.m_queue.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThread() {
        Vector vector = this.m_queue;
        synchronized (vector) {
            this.m_queue.notifyAll();
        }
    }

    public Object waitForEvent() {
        return this.waitForEvent(0L);
    }

    public Object waitForEvent(long waitTimeMs) {
        return this.checkForEvent(waitTimeMs) ? this.pullEvent() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForNotify(long waitTimeMs) {
        Vector vector = this.m_queue;
        synchronized (vector) {
            if (this.isRunning()) {
                try {
                    this.m_queue.wait(waitTimeMs);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
            }
            return this.m_queue.size();
        }
    }

    public int waitForNotify() {
        return this.waitForNotify(0L);
    }

    public boolean checkForEvent() {
        return this.checkForEvent(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForEvent(long waitTimeMs) {
        Vector vector = this.m_queue;
        synchronized (vector) {
            if (this.m_queue.isEmpty() && this.isRunning()) {
                try {
                    this.m_queue.wait(waitTimeMs);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
            }
            return !this.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishRunning() {
        if (this.shouldFinishWork()) {
            Vector vector = this.m_queue;
            synchronized (vector) {
                if (this.m_queue.isEmpty()) {
                    return true;
                }
            }
        }
        return !this.isRunning();
    }

    public void stopThread() {
        super.stopThread();
        this.notifyThread();
    }

    public void finishWorkAndStopThread() {
        super.finishWorkAndStopThread();
        this.notifyThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEvents() {
        Vector vector = this.m_queue;
        synchronized (vector) {
            this.m_queue.clear();
        }
    }
}

