/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UtilFns;
import com.isti.util.gui.FloatJTextField;
import com.isti.util.gui.IstiAbstractTimeRangePanel;
import com.isti.util.gui.IstiGridBagConstraints;
import com.isti.util.gui.IstiTimePanel;
import com.isti.util.gui.TimeJTextField;
import com.isti.util.gui.TimeRangeTitledBorder;
import com.isti.util.gui.TimeSlider;
import com.isti.util.gui.TransferFocusListener;
import com.isti.util.gui.UpdateHandler;
import com.isti.util.gui.UpdateListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;

public class IstiTimeRangePanel
extends IstiAbstractTimeRangePanel
implements UpdateListener {
    public static final long MS_PER_HOUR = 3600000L;
    public static final double FLOAT_MS_PER_HOUR = 3600000.0;
    protected static final Color FOREGROUND_COLOR = Color.black;
    protected static boolean showLabelsFlag = false;
    protected static boolean ignoreSlidersWhileValueIsAdjusting = false;
    protected static boolean debugFlag = false;
    public static final String DEFAULT_MIN_MAX_TITLE = "Min/Max";
    public static final String DEFAULT_START_TITLE = "Start";
    public static final String DEFAULT_END_TITLE = "End";
    public static final String DEFAULT_START_END_TITLE = "Start/End";
    public static final Double DEFAULT_MAX_DURATION_VALUE = null;
    private final String minMaxTitle;
    private final String startEndTitle;
    private long minTime = 0L;
    private Date minDate = null;
    private long maxTime = 0L;
    private Date maxDate = null;
    private long offsetTimeMax = 0L;
    private long durationTimeMax = 0L;
    private Double maxDurationValue = null;
    private long maxDurationMs = -1L;
    private final JPanel minMaxPanel = new JPanel();
    private final JPanel startEndPanel = new JPanel();
    private final JSlider minTimeSlider = new TimeSlider("Minimum");
    private final IstiTimePanel minTimePanel = new IstiTimePanel();
    private final JSlider maxTimeSlider = new TimeSlider("Maximum", 100);
    private final FloatJTextField minTimeOffsetText = new FloatJTextField();
    private final FloatJTextField maxTimeOffsetText = new FloatJTextField();
    private final IstiTimePanel maxTimePanel = new IstiTimePanel();
    private final JSlider startTimeSlider = new TimeSlider("Start");
    private final IstiTimePanel startTimePanel = new IstiTimePanel();
    private final FloatJTextField startTimeOffsetText = new FloatJTextField();
    private final JSlider endTimeSlider = new TimeSlider("End", 100);
    private final IstiTimePanel endTimePanel = new IstiTimePanel();
    private final FloatJTextField endTimeOffsetText = new FloatJTextField();
    private final JSlider durationTimeSlider = new TimeSlider("Duration", 100);
    private final FloatJTextField durationTimeOffsetText = new FloatJTextField();
    private boolean processUpdateFlag = true;
    protected final String maxTimeSliderTipText;
    protected final String minTimeSliderTipText;
    protected final String sliderTipTextSuffix;
    protected final String startTimeSliderTipText;
    protected final String endTimeSliderTipText;
    protected final String durationTimeSliderTipText;
    protected final String offsetTipTextSuffix;
    protected final String minOffsetTipText;
    protected final String maxOffsetTipText;
    protected final String offsetTipText;
    protected final String durationTextTipText;

    public IstiTimeRangePanel() {
        this(DEFAULT_MIN_MAX_TITLE, DEFAULT_START_END_TITLE);
    }

    public IstiTimeRangePanel(String minMaxTitle, String startEndTitle) {
        this(minMaxTitle, startEndTitle, null);
    }

    public IstiTimeRangePanel(String minMaxTitle, String startEndTitle, TimeZone value) {
        this(minMaxTitle, startEndTitle, value, DEFAULT_START_TITLE, DEFAULT_END_TITLE, DEFAULT_MAX_DURATION_VALUE);
    }

    public IstiTimeRangePanel(String minMaxTitle, String startEndTitle, TimeZone value, String startTitle, String endTitle, Double maxDurationValue) {
        this.minMaxTitle = minMaxTitle;
        this.startEndTitle = startEndTitle;
        if (value != null) {
            this.setTimeZone(value);
        }
        if (startTitle != null) {
            this.startTimePanel.setTitle(startTitle);
        }
        if (endTitle != null) {
            this.endTimePanel.setTitle(endTitle);
        }
        this.maxDurationValue = maxDurationValue;
        this.maxDurationMs = maxDurationValue != null ? (long)(maxDurationValue * 3600000.0) : -1L;
        this.updateTimeOffsets();
        this.maxTimeSliderTipText = "Latest available time";
        this.minTimeSliderTipText = "Earliest available time";
        this.sliderTipTextSuffix = " from minimum (left) to maximum (right)";
        this.startTimeSliderTipText = "Start time" + this.sliderTipTextSuffix;
        this.endTimeSliderTipText = "End time from" + this.sliderTipTextSuffix;
        this.durationTimeSliderTipText = "Duration of start/end time";
        this.offsetTipTextSuffix = " (in hours)";
        this.minOffsetTipText = "Minimum offset" + this.offsetTipTextSuffix;
        this.maxOffsetTipText = "Maximum offset" + this.offsetTipTextSuffix;
        this.offsetTipText = "Offset from minimum" + this.offsetTipTextSuffix;
        this.durationTextTipText = this.durationTimeSliderTipText + this.offsetTipTextSuffix;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setShowLabels(showLabelsFlag);
    }

    public IstiTimeRangePanel(TimeZone value) {
        this(DEFAULT_MIN_MAX_TITLE, DEFAULT_START_END_TITLE, value, DEFAULT_START_TITLE, DEFAULT_END_TITLE, DEFAULT_MAX_DURATION_VALUE);
    }

    public IstiTimeRangePanel(TimeZone value, Double maxDurationValue) {
        this(DEFAULT_MIN_MAX_TITLE, DEFAULT_START_END_TITLE, value, DEFAULT_START_TITLE, DEFAULT_END_TITLE, maxDurationValue);
    }

    public boolean isShowLabels() {
        return this.minTimePanel.isVisible();
    }

    public void setShowLabels(boolean b) {
        this.minTimePanel.setShowLabels(b);
        this.maxTimePanel.setShowLabels(b);
        this.startTimePanel.setShowLabels(b);
        this.endTimePanel.setShowLabels(b);
    }

    public void setTimeZone(TimeZone value) {
        this.minTimePanel.setTimeZone(value);
        this.maxTimePanel.setTimeZone(value);
        this.startTimePanel.setTimeZone(value);
        this.endTimePanel.setTimeZone(value);
    }

    public static void main(String[] args) {
        boolean debugFlag = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].toLowerCase().equals("debug")) continue;
            debugFlag = true;
        }
        TimeJTextField.debugFlag = debugFlag;
        IstiTimePanel.debugFlag = debugFlag;
        IstiTimeRangePanel.debugFlag = debugFlag;
        JFrame frameObj = new JFrame("IstiTimeRangePanel");
        IstiTimeRangePanel timeRangePanel = new IstiTimeRangePanel("Data Date/Time Range", "Choose a viewing window Date/Time", UtilFns.GMT_TIME_ZONE_OBJ, DEFAULT_START_TITLE, DEFAULT_END_TITLE, DEFAULT_MAX_DURATION_VALUE);
        GregorianCalendar calendar = new GregorianCalendar(timeRangePanel.getTimeZone());
        calendar.add(11, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.add(11, 1);
        Date endDate = calendar.getTime();
        calendar.setTime(new Date(0L));
        calendar.add(2, 1);
        calendar.add(1, -1);
        Date maxDate = new Date();
        timeRangePanel.setMaxDate(maxDate);
        Date minDate = calendar.getTime();
        timeRangePanel.setMinDate(minDate);
        timeRangePanel.setEndDate(endDate);
        timeRangePanel.setStartDate(startDate);
        frameObj.getContentPane().add(timeRangePanel);
        frameObj.setDefaultCloseOperation(3);
        frameObj.pack();
        frameObj.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.minMaxPanel.setLayout(new GridBagLayout());
        this.startEndPanel.setLayout(new GridBagLayout());
        this.minTimePanel.setBorder(null);
        this.maxTimePanel.setBorder(null);
        this.startTimePanel.setBorder(null);
        this.endTimePanel.setBorder(null);
        this.startTimeSlider.addChangeListener(new UpdateHandler(this.startTimeSlider, this));
        this.startTimePanel.addUpdateListener(new UpdateHandler(this.startTimePanel, this));
        this.startTimeOffsetText.addFocusListener(new UpdateHandler(this.startTimeOffsetText, this));
        this.startTimeOffsetText.addActionListener(TransferFocusListener.LISTENER);
        this.endTimeSlider.addChangeListener(new UpdateHandler(this.endTimeSlider, this));
        this.durationTimeSlider.addChangeListener(new UpdateHandler(this.durationTimeSlider, this));
        this.endTimePanel.addUpdateListener(new UpdateHandler(this.endTimePanel, this));
        this.endTimeOffsetText.addFocusListener(new UpdateHandler(this.endTimeOffsetText, this));
        this.endTimeOffsetText.addActionListener(TransferFocusListener.LISTENER);
        this.durationTimeOffsetText.addFocusListener(new UpdateHandler(this.durationTimeOffsetText, this));
        this.durationTimeOffsetText.addActionListener(TransferFocusListener.LISTENER);
        this.maxTimeSlider.setToolTipText(this.maxTimeSliderTipText);
        this.minTimeSlider.setToolTipText(this.minTimeSliderTipText);
        this.startTimeSlider.setToolTipText(this.startTimeSliderTipText);
        this.endTimeSlider.setToolTipText(this.endTimeSliderTipText);
        this.durationTimeSlider.setToolTipText(this.durationTimeSliderTipText);
        this.minTimeOffsetText.setToolTipText(this.minOffsetTipText);
        this.maxTimeOffsetText.setToolTipText(this.maxOffsetTipText);
        this.startTimeOffsetText.setToolTipText(this.offsetTipText);
        this.endTimeOffsetText.setToolTipText(this.offsetTipText);
        this.durationTimeOffsetText.setToolTipText(this.durationTextTipText);
        this.minTimeSlider.setEnabled(false);
        this.maxTimeSlider.setEnabled(false);
        this.minTimePanel.setEnabled(false);
        this.maxTimePanel.setEnabled(false);
        this.minTimeOffsetText.setEnabled(false);
        this.maxTimeOffsetText.setEnabled(false);
        this.minMaxPanel.add((Component)this.minTimeSlider, new IstiGridBagConstraints(0, 0));
        this.minMaxPanel.add((Component)this.minTimePanel, new IstiGridBagConstraints(1, 0));
        this.minMaxPanel.add((Component)this.minTimeOffsetText, new IstiGridBagConstraints(2, 0));
        this.minMaxPanel.add((Component)this.maxTimeSlider, new IstiGridBagConstraints(0, 1));
        this.minMaxPanel.add((Component)this.maxTimePanel, new IstiGridBagConstraints(1, 1));
        this.minMaxPanel.add((Component)this.maxTimeOffsetText, new IstiGridBagConstraints(2, 1));
        this.minMaxPanel.setBorder(new TimeRangeTitledBorder(this.minMaxTitle));
        this.add((Component)this.minMaxPanel, new IstiGridBagConstraints(0, 1, 3, 1));
        this.startEndPanel.add((Component)this.startTimeSlider, new IstiGridBagConstraints(0, 0));
        this.startEndPanel.add((Component)this.startTimePanel, new IstiGridBagConstraints(1, 0));
        this.startEndPanel.add((Component)this.startTimeOffsetText, new IstiGridBagConstraints(2, 0));
        this.startEndPanel.add((Component)this.endTimeSlider, new IstiGridBagConstraints(0, 1));
        this.startEndPanel.add((Component)this.endTimePanel, new IstiGridBagConstraints(1, 1));
        this.startEndPanel.add((Component)this.endTimeOffsetText, new IstiGridBagConstraints(2, 1));
        this.startEndPanel.add((Component)this.durationTimeSlider, new IstiGridBagConstraints(0, 2));
        this.startEndPanel.add((Component)this.durationTimeOffsetText, new IstiGridBagConstraints(2, 2));
        this.startEndPanel.setBorder(new TimeRangeTitledBorder(this.startEndTitle));
        this.add((Component)this.startEndPanel, new IstiGridBagConstraints(0, 2, 3, 1));
    }

    private boolean isValidDuration(Date startDate, Date endDate) {
        long durationMs;
        return this.maxDurationMs < 0L || (durationMs = endDate.getTime() - startDate.getTime()) <= this.maxDurationMs;
    }

    protected void checkValues(boolean startTimeUpdateFlag, boolean endTimeUpdateFlag) {
        Date newDate;
        Date endDate;
        Date startDate;
        if (startTimeUpdateFlag) {
            startDate = this.startTimePanel.getTime();
            if (startDate.compareTo(endDate = this.endTimePanel.getTime()) > 0) {
                this.endTimePanel.setTime(startDate);
            } else if (!this.isValidDuration(startDate, endDate)) {
                newDate = new Date(startDate.getTime() + this.maxDurationMs);
                this.endTimePanel.setTime(newDate);
            }
        }
        if (endTimeUpdateFlag) {
            startDate = this.startTimePanel.getTime();
            endDate = this.endTimePanel.getTime();
            if (endDate.compareTo(startDate) < 0) {
                this.startTimePanel.setTime(endDate);
            } else if (!this.isValidDuration(startDate, endDate)) {
                newDate = new Date(endDate.getTime() - this.maxDurationMs);
                this.startTimePanel.setTime(newDate);
            }
        }
    }

    protected static boolean setSliderValue(JSlider slider, int value) {
        if (value >= slider.getMinimum() && value <= slider.getMaximum()) {
            slider.setValue(value);
            return true;
        }
        return false;
    }

    protected void printValues(String title) {
        System.out.println(title + ": start = " + this.startTimePanel + " (" + this.startTimeOffsetText.getText() + ")" + ", end = " + this.endTimePanel + " (" + this.endTimeOffsetText.getText() + ")" + ", duration = " + this.durationTimeOffsetText.getText());
    }

    public Date getEndDate() {
        return this.endTimePanel.getTime();
    }

    public long getEndTime() {
        long endValue = 0L;
        if (this.maxDate != null && this.endTimePanel.getTime().compareTo(this.maxDate) < 0) {
            endValue = this.endTimePanel.getTime().getTime();
        }
        return endValue;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public Date getStartDate() {
        return this.startTimePanel.getTime();
    }

    public long getStartTime() {
        long startValue = 0L;
        if (this.minDate != null && this.startTimePanel.getTime().compareTo(this.minDate) > 0) {
            startValue = this.startTimePanel.getTime().getTime();
        }
        return startValue;
    }

    public TimeZone getTimeZone() {
        return this.minTimePanel.getTimeZone();
    }

    public void requestFocus() {
        super.requestFocus();
        this.startTimeSlider.requestFocus();
    }

    public void setEndDate(Date endDate) {
        this.endTimePanel.setTime(endDate);
    }

    public void setEndTime(long endTime) {
        this.endTimePanel.setTime(new Date(endTime));
    }

    public void setMinMaxPanelVisible(boolean b) {
        this.minMaxPanel.setVisible(b);
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
        this.maxTime = maxDate.getTime();
        this.maxTimePanel.setTime(maxDate);
        this.startTimePanel.setMaxTime(maxDate);
        this.endTimePanel.setMaxTime(maxDate);
        this.updateTimeOffsets();
    }

    private void setDurationTimeOffsetValue(double value) {
        Double valueObj = new Double(value);
        Comparable maxValueObj = this.durationTimeOffsetText.getMaxValueObj();
        if (maxValueObj instanceof Number && maxValueObj.compareTo(valueObj) < 0) {
            double currentValue = this.durationTimeOffsetText.getValue();
            double newValue = ((Number)((Object)maxValueObj)).doubleValue();
            if (newValue != currentValue) {
                this.durationTimeOffsetText.setValue(newValue);
                this.processDurationTimeUpdate(newValue * 3600000.0);
            }
        }
        this.durationTimeOffsetText.setValue(value);
    }

    public void setMaxTime(long time) {
        this.setMaxDate(new Date(time));
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
        this.minTime = minDate.getTime();
        this.minTimePanel.setTime(minDate);
        this.startTimePanel.setMinTime(minDate);
        this.endTimePanel.setMinTime(minDate);
        this.updateTimeOffsets();
    }

    public void setMinTime(long time) {
        this.setMinDate(new Date(time));
    }

    public void setStartDate(Date startDate) {
        this.startTimePanel.setTime(startDate);
    }

    public void setStartTime(long startTime) {
        this.startTimePanel.setTime(new Date(startTime));
    }

    protected void updateTimeOffsets() {
        boolean b;
        if (this.minDate != null && this.maxDate != null) {
            b = true;
            this.offsetTimeMax = this.maxTime - this.minTime;
            double offsetTimeMaxHour = (double)this.offsetTimeMax / 3600000.0;
            long minMaxdiffTimeMs = this.maxTime - this.minTime;
            double minMaxDiffTimeHour = (double)minMaxdiffTimeMs / 3600000.0;
            this.durationTimeMax = this.maxDurationMs < 0L || minMaxdiffTimeMs <= this.maxDurationMs ? minMaxdiffTimeMs : this.maxDurationMs;
            this.maxTimeOffsetText.setMaxValue(offsetTimeMaxHour);
            this.maxTimeOffsetText.setValue(offsetTimeMaxHour);
            this.startTimeOffsetText.setMaxValue(offsetTimeMaxHour);
            this.endTimeOffsetText.setMaxValue(offsetTimeMaxHour);
            this.processUpdateFlag = false;
            this.processUpdate(this.startTimePanel, null);
            this.processUpdate(this.endTimePanel, null);
        } else {
            b = false;
        }
        this.startTimeSlider.setEnabled(b);
        this.endTimeSlider.setEnabled(b);
        this.startTimePanel.setEnabled(b);
        this.endTimePanel.setEnabled(b);
        this.startTimeOffsetText.setEnabled(b);
        this.endTimeOffsetText.setEnabled(b);
        this.durationTimeSlider.setEnabled(b);
        this.durationTimeOffsetText.setEnabled(b);
        this.requestFocus();
    }

    public void processUpdate(Component component, Object e) {
        if (e instanceof ChangeEvent ? component instanceof JSlider && ignoreSlidersWhileValueIsAdjusting && ((JSlider)component).getValueIsAdjusting() : e instanceof FocusEvent && ((FocusEvent)e).getID() != 1005) {
            return;
        }
        if (this.processUpdateFlag) {
            return;
        }
        this.processUpdateFlag = true;
        if (debugFlag) {
            this.printValues("Before Update");
        }
        boolean startTimeUpdateFlag = false;
        boolean endTimeUpdateFlag = false;
        boolean durationTimeUpdateFlag = false;
        double offsetValue = 0.0;
        if (component.equals(this.startTimeSlider)) {
            int sliderValue = this.startTimeSlider.getValue();
            offsetValue = this.offsetTimeMax * (long)sliderValue / 100L;
            Date startDate = new Date(this.minTime + Math.round(offsetValue));
            this.startTimePanel.setTime(startDate);
            this.startTimeOffsetText.setValue(offsetValue / 3600000.0);
            startTimeUpdateFlag = true;
        } else if (component.equals(this.startTimePanel)) {
            Date startDate = this.startTimePanel.getTime();
            if (startDate != null) {
                long startTime = startDate.getTime();
                offsetValue = startTime - this.minTime;
                int sliderValue = (int)(offsetValue * 100.0 / (double)this.offsetTimeMax);
                if (IstiTimeRangePanel.setSliderValue(this.startTimeSlider, sliderValue)) {
                    this.startTimeOffsetText.setValue(offsetValue / 3600000.0);
                    startTimeUpdateFlag = true;
                } else if (debugFlag) {
                    System.out.println("Invalid slider value (" + sliderValue + ") for " + component.getName() + " (date=" + startDate + ")");
                }
            }
        } else if (component.equals(this.startTimeOffsetText)) {
            offsetValue = this.startTimeOffsetText.getValue();
            int sliderValue = (int)((offsetValue *= 3600000.0) * 100.0 / (double)this.offsetTimeMax);
            Date startDate = new Date(this.minTime + (long)offsetValue);
            if (IstiTimeRangePanel.setSliderValue(this.startTimeSlider, sliderValue)) {
                this.startTimePanel.setTime(startDate);
                startTimeUpdateFlag = true;
            } else if (debugFlag) {
                System.out.println("Invalid slider value (" + sliderValue + ") for " + component.getName() + " (date=" + startDate + ")");
            }
        } else if (component.equals(this.endTimeSlider)) {
            int sliderValue = this.endTimeSlider.getValue();
            offsetValue = this.offsetTimeMax * (long)sliderValue / 100L;
            Date endDate = new Date(this.minTime + Math.round(offsetValue));
            this.endTimePanel.setTime(endDate);
            this.endTimeOffsetText.setValue(offsetValue / 3600000.0);
            endTimeUpdateFlag = true;
        } else if (component.equals(this.endTimePanel)) {
            Date endDate = this.endTimePanel.getTime();
            if (endDate != null) {
                long endTime = endDate.getTime();
                offsetValue = endTime - this.minTime;
                int sliderValue = (int)(offsetValue * 100.0 / (double)this.offsetTimeMax);
                if (IstiTimeRangePanel.setSliderValue(this.endTimeSlider, sliderValue)) {
                    this.endTimeOffsetText.setValue(offsetValue / 3600000.0);
                    endTimeUpdateFlag = true;
                } else if (debugFlag) {
                    System.out.println("Invalid slider value (" + sliderValue + ") for " + component.getName() + " (date=" + endDate + ")");
                }
            }
        } else if (component.equals(this.endTimeOffsetText)) {
            offsetValue = this.endTimeOffsetText.getValue();
            int sliderValue = (int)((offsetValue *= 3600000.0) * 100.0 / (double)this.offsetTimeMax);
            Date endDate = new Date(this.minTime + (long)offsetValue);
            if (IstiTimeRangePanel.setSliderValue(this.endTimeSlider, sliderValue)) {
                this.endTimePanel.setTime(endDate);
                endTimeUpdateFlag = true;
            } else if (debugFlag) {
                System.out.println("Invalid slider value (" + sliderValue + ") for " + component.getName() + " (date=" + endDate + ")");
            }
        } else if (component.equals(this.durationTimeSlider)) {
            int sliderValue = this.durationTimeSlider.getValue();
            offsetValue = this.durationTimeMax * (long)sliderValue / 100L;
            this.setDurationTimeOffsetValue(offsetValue / 3600000.0);
            durationTimeUpdateFlag = true;
        } else if (component.equals(this.durationTimeOffsetText)) {
            offsetValue = this.durationTimeOffsetText.getValue();
            int sliderValue = (int)Math.round((offsetValue *= 3600000.0) * 100.0 / (double)this.durationTimeMax);
            IstiTimeRangePanel.setSliderValue(this.durationTimeSlider, sliderValue);
            durationTimeUpdateFlag = true;
        } else if (debugFlag) {
            System.out.println(component.getName());
        }
        if (startTimeUpdateFlag) {
            this.updateDurationTimes(component);
        }
        if (endTimeUpdateFlag) {
            this.updateDurationTimes(component);
        }
        this.processUpdateFlag = false;
        if (durationTimeUpdateFlag) {
            this.processDurationTimeUpdate(offsetValue);
        }
        if (startTimeUpdateFlag || endTimeUpdateFlag) {
            this.checkValues(startTimeUpdateFlag, endTimeUpdateFlag);
        }
        if (debugFlag) {
            this.printValues("After Update");
        }
    }

    private void processDurationTimeUpdate(double offsetValue) {
        Date endDate = new Date(this.startTimePanel.getTime().getTime() + Math.round(offsetValue));
        if (endDate.compareTo(this.maxTimePanel.getTime()) <= 0) {
            this.endTimePanel.setTime(endDate);
        } else {
            endDate = this.maxTimePanel.getTime();
            this.endTimePanel.setTime(endDate);
            long endTime = endDate.getTime();
            Date startDate = new Date(endTime - Math.round(offsetValue));
            if (startDate.compareTo(this.minTimePanel.getTime()) >= 0) {
                this.startTimePanel.setTime(startDate);
            }
        }
    }

    protected void updateDurationTimes(Component component) {
        double offsetValue = this.endTimePanel.getTime().getTime() - this.startTimePanel.getTime().getTime();
        int sliderValue = (int)Math.round(offsetValue * 100.0 / (double)this.durationTimeMax);
        if (!component.equals(this.durationTimeSlider)) {
            this.durationTimeSlider.setValue(sliderValue);
        }
        if (!component.equals(this.durationTimeOffsetText)) {
            this.setDurationTimeOffsetValue(offsetValue / 3600000.0);
        }
    }
}

