/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;

public class IstiFixedJFileChooser
extends JFileChooser
implements PropertyChangeListener {
    protected IstiFixedJFileChooser() {
        this.addPropertyChangeListener("SelectedFilesChangedProperty", this);
        this.addPropertyChangeListener("directoryChanged", this);
        this.addPropertyChangeListener("SelectedFileChangedProperty", this);
    }

    public static IstiFixedJFileChooser createFixedFileChooser() {
        int c;
        for (c = 0; c < 1000; ++c) {
            try {
                return new IstiFixedJFileChooser();
            }
            catch (Exception ex) {
                System.err.println("IstiFixedJFileChooser:  Retrying after error creating 'JFileChooser':  " + ex);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        System.err.println("IstiFixedJFileChooser:  Unable to create 'JFileChooser' after " + c + " retries; making last attempt");
        return new IstiFixedJFileChooser();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        if (e.getPropertyName().compareTo("SelectedFilesChangedProperty") == 0) {
            File[] files;
            if (e.getNewValue() instanceof File[] && (files = (File[])e.getNewValue()).length > 0) {
                this.getUI().ensureFileIsVisible(this, files[files.length - 1]);
            }
        } else if (e.getPropertyName().compareTo("directoryChanged") == 0) {
            File file = this.getSelectedFile();
            if (file != null && file.getName().length() > 0 && file.isDirectory()) {
                this.setSelectedFile(new File(""));
            }
        } else if (e.getPropertyName().compareTo("SelectedFileChangedProperty") == 0 && e.getNewValue() instanceof File) {
            File file = (File)e.getNewValue();
            switch (this.getFileSelectionMode()) {
                case 0: {
                    if (!file.isDirectory()) break;
                    this.setSelectedFile(new File(""));
                    break;
                }
                case 1: {
                    if (file.isDirectory()) break;
                    this.setSelectedFile(new File(""));
                }
            }
        }
    }
}

