/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CfgProperties;
import com.isti.util.IstiXmlUtils;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

public class XmlConfigLoader
extends IstiXmlUtils {
    protected static final String DEF_VER1_STR = "version";
    protected static final String DEF_VER2_STR = "v";
    protected static final String DEF_HELP1_STR = "help";
    protected static final String DEF_HELP2_STR = "h";
    protected static String version1String = "version";
    protected static String version2String = "v";
    protected static String help1String = "help";
    protected static String help2String = "h";
    private String versionString = null;

    public boolean loadConfiguration(String fileName, String rootElementName, String settingsElementName, boolean mustFlag, CfgProperties cfgPropObj, String[] programArgs, boolean defaultsFlag, String cfgParamSpecStr) {
        Element elementObj;
        List settingsElemsList;
        Element rootElemObj;
        String arg0Str;
        int specLen;
        this.clearFetchedErrorMessage();
        if (settingsElementName == null || cfgPropObj == null) {
            this.setErrorMessageString("Null parameter");
            return false;
        }
        boolean retFlag = true;
        if (cfgParamSpecStr != null && (specLen = cfgParamSpecStr.trim().length()) > 0 && programArgs != null && programArgs.length > 0 && (arg0Str = programArgs[0]) != null) {
            int arg0Len = arg0Str.length();
            int p = 0;
            while (p < arg0Len && arg0Str.charAt(p) == '-' && ++p < 2) {
            }
            if (arg0Len >= p + specLen) {
                int sepPos;
                int n = sepPos = arg0Len > p + specLen + 1 && arg0Str.charAt(p + specLen) == '=' ? p + specLen : arg0Len;
                if (arg0Str.substring(p, sepPos).equals(cfgParamSpecStr)) {
                    int nameSlotVal;
                    if (sepPos >= arg0Len) {
                        if (programArgs.length > 1 && programArgs[1] != null) {
                            fileName = programArgs[1];
                            nameSlotVal = 1;
                        } else {
                            nameSlotVal = 0;
                        }
                    } else {
                        fileName = arg0Str.substring(sepPos + 1);
                        nameSlotVal = 0;
                    }
                    int len = fileName.length();
                    if (len > 1 && (fileName.charAt(0) == '\"' && fileName.charAt(len - 1) == '\"' || fileName.charAt(0) == '\'' && fileName.charAt(len - 1) == '\'')) {
                        fileName = fileName.substring(1, len - 1);
                    }
                    if (programArgs.length > nameSlotVal + 1) {
                        int newPos = 0;
                        String[] newArgsArr = new String[programArgs.length - nameSlotVal - 1];
                        for (p = nameSlotVal + 1; p < programArgs.length; ++p) {
                            newArgsArr[newPos++] = programArgs[p];
                        }
                        programArgs = newArgsArr;
                    } else {
                        programArgs = new String[]{};
                    }
                }
            }
        }
        if (!this.loadFile(fileName, rootElementName)) {
            if (mustFlag || this.getLoadFileOpenedFlag()) {
                retFlag = false;
            } else {
                this.clearErrorMessageString();
            }
            if (this.getRootElement() == null) {
                this.setRootElement(new Element(rootElementName));
            }
        }
        if ((rootElemObj = this.getRootElement()) == null) {
            if (mustFlag) {
                this.enterErrorMessageString("Unable to load root element from file \"" + fileName + "\"");
                retFlag = false;
            }
            rootElemObj = new Element(rootElementName);
            this.setRootElement(rootElemObj);
        }
        if ((settingsElemsList = rootElemObj.getChildren(settingsElementName)).size() > 0) {
            if (settingsElemsList.size() > 1) {
                this.enterErrorMessageString("More than one \"" + settingsElementName + "\" element found in configuration file \"" + fileName + "\"");
                retFlag = false;
            }
        } else {
            if (mustFlag) {
                this.enterErrorMessageString("No \"" + settingsElementName + "\" elements found in configuration file \"" + fileName + "\"");
                retFlag = false;
            }
            settingsElemsList.add(new Element(settingsElementName));
        }
        String elemNameStr = null;
        Object obj = settingsElemsList.get(0);
        if (!(obj instanceof Element) || !settingsElementName.equals(elemNameStr = (elementObj = (Element)obj).getName())) {
            this.enterErrorMessageString("Error fetching \"" + settingsElementName + "\" element from configuration file \"" + fileName + "\" (found name = \"" + elemNameStr + "\")");
            retFlag = false;
            elementObj = new Element(settingsElementName);
        }
        if (!cfgPropObj.load(elementObj.getText(), defaultsFlag)) {
            this.enterErrorMessageString("Error processing \"" + settingsElementName + "\" element from configuration file \"" + fileName + "\":  " + cfgPropObj.getErrorMessage());
            retFlag = false;
        }
        if (programArgs != null && programArgs.length > 0) {
            boolean cmdLnProcFlag = cfgPropObj.processCmdLnParams(programArgs, true, version1String, version2String);
            Vector vec = cfgPropObj.getExtraCmdLnParamsVec();
            if (vec != null && !vec.isEmpty() && (obj = vec.firstElement()) instanceof String && ((String)obj).length() > 0) {
                String str = CfgProperties.removeSwitchChars((String)obj);
                if (str.equalsIgnoreCase(help1String) || str.equalsIgnoreCase(help2String) || str.startsWith("?")) {
                    System.out.println("Command-line parameters:");
                    System.out.println(cfgPropObj.getHelpScreenData());
                    System.exit(0);
                } else if (str.equalsIgnoreCase(version2String) || str.equalsIgnoreCase(version1String)) {
                    if (this.versionString != null) {
                        System.out.println(this.versionString);
                    }
                    System.exit(0);
                } else {
                    this.setErrorMessageString("Invalid command-line parameter \"" + (String)obj + "\"");
                    retFlag = false;
                }
            }
            if (!cmdLnProcFlag) {
                this.setErrorMessageString(cfgPropObj.getErrorMessage());
                retFlag = false;
            }
        }
        return retFlag;
    }

    public boolean loadConfiguration(String fileName, String rootElementName, String settingsElementName, boolean mustFlag, CfgProperties cfgPropObj, String[] programArgs, String cfgParamSpecStr) {
        return this.loadConfiguration(fileName, rootElementName, settingsElementName, mustFlag, cfgPropObj, programArgs, false, cfgParamSpecStr);
    }

    public boolean loadConfiguration(String fileName, String rootElementName, String settingsElementName, boolean mustFlag, CfgProperties cfgPropObj, String[] programArgs) {
        return this.loadConfiguration(fileName, rootElementName, settingsElementName, mustFlag, cfgPropObj, programArgs, false, null);
    }

    public boolean loadConfiguration(String fileName, String rootElementName, String settingsElementName, boolean mustFlag, CfgProperties cfgPropObj, boolean defaultsFlag) {
        return this.loadConfiguration(fileName, rootElementName, settingsElementName, mustFlag, cfgPropObj, null, defaultsFlag, null);
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String s) {
        this.versionString = s;
    }

    public static void setVersionParamNames(String ver1Str, String ver2Str) {
        version1String = ver1Str;
        version2String = ver2Str;
    }

    public static void setHelpParamNames(String help1Str, String help2Str) {
        help1String = help1Str;
        help2String = help2Str;
    }
}

