/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CfgPropItem;
import com.isti.util.CfgProperties;
import com.isti.util.ErrorMessageMgr;
import com.isti.util.FileUtils;
import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import com.isti.util.logging.AbstractIstiLogger;
import java.io.PrintStream;
import java.util.Iterator;

public class LogFileViaCfgProps
extends ErrorMessageMgr {
    protected LogFile logObj = null;
    protected PrintStream consoleRedirectStream = null;
    public final CfgProperties logFileProps = new CfgProperties();
    public final CfgPropItem consoleRedirectFileNameProp = this.logFileProps.add("consoleRedirectFileName", "", null, "Name of the console output redirect file");
    public final CfgPropItem logFileNameProp = this.logFileProps.add("logFileName", "", null, "Name of the log file");
    public final CfgPropItem logFileLevelProp = this.logFileProps.add("logFileLevel", "Info", null, "Message level for log file output");
    public final CfgPropItem consoleLevelProp = this.logFileProps.add("consoleLevel", "Warning", null, "Message level for console output");
    public final CfgPropItem logFilesMaxAgeInDaysProp = this.logFileProps.add("logFilesMaxAgeInDays", new Integer(30), null, "Maximum age for log files (days, 0=infinite)");
    public final CfgPropItem consoleFilesSwitchIntvlDays = this.logFileProps.add("consoleFilesSwitchIntvlDays", new Integer(30), null, "Switch interval for console files (days)");
    public final CfgPropItem consoleFilesMaxAgeInDays = this.logFileProps.add("consoleFilesMaxAgeInDays", new Integer(366), null, "Maximum age for console files (days)");

    public LogFileViaCfgProps() {
    }

    public LogFileViaCfgProps(CfgProperties cfgPropsObj, Object groupSelObj) {
        this.addLogFilePropItems(cfgPropsObj, groupSelObj);
    }

    public LogFileViaCfgProps(CfgProperties cfgPropsObj) {
        this.addLogFilePropItems(cfgPropsObj, null);
    }

    public final void addLogFilePropItems(CfgProperties cfgPropsObj, Object groupSelObj) {
        if (cfgPropsObj != null) {
            Iterator iterObj = this.logFileProps.values().iterator();
            while (iterObj.hasNext()) {
                Object obj = iterObj.next();
                if (!(obj instanceof CfgPropItem)) continue;
                cfgPropsObj.add(((CfgPropItem)obj).setGroupSelObj(groupSelObj));
            }
        } else {
            this.setGroupSelObj(groupSelObj);
        }
    }

    public final void addLogFilePropItems(CfgProperties cfgPropsObj) {
        this.addLogFilePropItems(cfgPropsObj, null);
    }

    public final void setGroupSelObj(Object groupSelObj) {
        Iterator iterObj = this.logFileProps.values().iterator();
        while (iterObj.hasNext()) {
            Object obj = iterObj.next();
            if (!(obj instanceof CfgPropItem)) continue;
            ((CfgPropItem)obj).setGroupSelObj(groupSelObj);
        }
    }

    public boolean createLogFile(boolean abortOnErrorFlag) {
        String consoleFileName;
        int consoleLevelVal;
        int logFileLevelVal;
        Object obj;
        boolean retFlag = true;
        String logFileLevelStr = this.logFileLevelProp.stringValue();
        Integer integerObj = AbstractIstiLogger.levelStringToValue(logFileLevelStr);
        if (integerObj == null) {
            String errStr = "Invalid value for \"" + this.logFileLevelProp.getName() + "\" setting:  \"" + logFileLevelStr + "\"";
            System.err.println(errStr);
            System.err.println("  Available values:  " + LogFile.getLevelNamesDisplayStr());
            this.enterErrorMessageString(errStr);
            if (abortOnErrorFlag) {
                return false;
            }
            retFlag = false;
            obj = this.logFileLevelProp.getDefaultValue();
            logFileLevelVal = obj instanceof String && (integerObj = AbstractIstiLogger.levelStringToValue((String)obj)) != null ? integerObj : 1;
        } else {
            logFileLevelVal = integerObj;
        }
        String consoleLevelStr = this.consoleLevelProp.stringValue();
        integerObj = AbstractIstiLogger.levelStringToValue(consoleLevelStr);
        if (integerObj == null) {
            String errStr = "Invalid value for \"" + this.consoleLevelProp.getName() + "\" setting:  \"" + consoleLevelStr + "\"";
            System.err.println(errStr);
            System.err.println("  Available values:  " + LogFile.getLevelNamesDisplayStr());
            this.enterErrorMessageString(errStr);
            if (abortOnErrorFlag) {
                return false;
            }
            retFlag = false;
            obj = this.consoleLevelProp.getDefaultValue();
            consoleLevelVal = obj instanceof String && (integerObj = AbstractIstiLogger.levelStringToValue((String)obj)) != null ? integerObj : 2;
        } else {
            consoleLevelVal = integerObj;
        }
        String string = consoleFileName = this.consoleRedirectFileNameProp != null ? this.consoleRedirectFileNameProp.stringValue() : null;
        if (consoleFileName != null && consoleFileName.length() > 0) {
            String errStr;
            FileUtils.createParentDirs(consoleFileName);
            try {
                LogFile conLogObj = new LogFile(consoleFileName, -999, 999, false, true);
                conLogObj.setLogFileSwitchIntervalDays(this.consoleFilesSwitchIntvlDays.intValue());
                conLogObj.setMaxLogFileAge(this.consoleFilesMaxAgeInDays.intValue());
                this.consoleRedirectStream = new PrintStream(conLogObj.getLogOutputStream());
            }
            catch (Exception ex) {
                errStr = "Error opening console redirect output file (\"" + consoleFileName + "\") for output:  " + ex;
                System.err.println(errStr);
                this.enterErrorMessageString(errStr);
                this.consoleRedirectStream = null;
                if (abortOnErrorFlag) {
                    return false;
                }
                retFlag = false;
            }
            if (this.consoleRedirectStream != null) {
                this.consoleRedirectStream.println();
                this.consoleRedirectStream.println("Console output redirect file opened " + UtilFns.timeMillisToString());
                if (!this.consoleRedirectStream.checkError()) {
                    try {
                        System.setOut(this.consoleRedirectStream);
                        System.setErr(this.consoleRedirectStream);
                    }
                    catch (Exception ex) {
                        errStr = "Error redirecting console output to file (\"" + consoleFileName + "\"):  " + ex;
                        System.err.println(errStr);
                        this.enterErrorMessageString(errStr);
                        this.consoleRedirectStream.close();
                        this.consoleRedirectStream = null;
                        if (abortOnErrorFlag) {
                            return false;
                        }
                        retFlag = false;
                    }
                } else {
                    String errStr2 = "Error writing to redirected console output file (\"" + consoleFileName + "\")";
                    System.err.println(errStr2);
                    this.enterErrorMessageString(errStr2);
                    this.consoleRedirectStream.close();
                    this.consoleRedirectStream = null;
                    if (abortOnErrorFlag) {
                        return false;
                    }
                    retFlag = false;
                }
            }
        }
        this.logObj = LogFile.initGlobalLogObj(this.logFileNameProp.stringValue(), logFileLevelVal, consoleLevelVal, false, true);
        int logFilesMaxAgeInDays = this.logFilesMaxAgeInDaysProp.intValue();
        if (logFilesMaxAgeInDays > 0) {
            this.logObj.setMaxLogFileAge(logFilesMaxAgeInDays);
        }
        this.logObj.debug("  logFileLevel=" + AbstractIstiLogger.getLevelString(logFileLevelVal) + " (" + logFileLevelVal + "), consoleLevel=" + AbstractIstiLogger.getLevelString(consoleLevelVal) + " (" + consoleLevelVal + "), maxAge = " + logFilesMaxAgeInDays + " days");
        return retFlag;
    }

    public LogFile getLogFileObj() {
        return this.logObj;
    }

    public void closeLogFile() {
        if (this.logObj != null) {
            this.logObj.close();
        }
    }

    public PrintStream getConsoleRedirectStreamObj() {
        return this.consoleRedirectStream;
    }

    public void closeConsoleRedirectStream() {
        if (this.consoleRedirectStream != null) {
            this.consoleRedirectStream.close();
        }
    }
}

