/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.BooleanCp;
import com.isti.util.IstiNamedValueInterface;
import com.isti.util.UtilFns;
import java.awt.Color;

public class IstiNamedValue
implements IstiNamedValueInterface {
    private final String name;
    private Object defaultValue;
    private Object value;
    private String valueString = null;

    public IstiNamedValue(String str) {
        int sepChIndex = str.indexOf(61);
        if (sepChIndex < 0) {
            this.name = str;
            this.valueString = null;
        } else {
            this.name = str.substring(0, sepChIndex);
            this.valueString = str.substring(sepChIndex + 1);
        }
        this.value = this.defaultValue = this.valueString;
    }

    public IstiNamedValue(String valueName, Object defaultValueObj) {
        this(valueName, defaultValueObj, null);
    }

    public IstiNamedValue(String valueName, Object defaultValueObj, Object valueObj) {
        this.name = valueName;
        this.value = this.defaultValue = defaultValueObj;
        if (valueObj != null) {
            this.setValue(valueObj);
        }
    }

    public Object clone() {
        return new IstiNamedValue(this.name, this.defaultValue, this.value);
    }

    public synchronized Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public synchronized Object getValue() {
        return this.value;
    }

    public boolean isDefaultValue() {
        if (this.value == this.defaultValue) {
            return true;
        }
        if (this.value == null || this.defaultValue == null) {
            return false;
        }
        return this.value.equals(this.defaultValue);
    }

    public synchronized boolean setValue(Object valueObj) {
        if ((valueObj = this.checkValue(valueObj)) == null) {
            return false;
        }
        if (valueObj.equals(this.value)) {
            return true;
        }
        this.value = valueObj;
        this.valueString = null;
        return true;
    }

    public boolean setValueString(String str) {
        Object valueObj = IstiNamedValue.setValueString(str, this.defaultValue);
        if (valueObj != null) {
            this.setValue(valueObj);
        }
        return valueObj != null;
    }

    public static Object setValueString(String str, Object defValObj) {
        Object obj;
        boolean boolTypeFlag = false;
        if (str == null || defValObj == null) {
            return null;
        }
        try {
            if (defValObj instanceof Integer) {
                obj = new Integer(str);
            } else if (defValObj instanceof Long) {
                obj = new Long(str);
            } else if (defValObj instanceof Float) {
                obj = new Float(str);
            } else if (defValObj instanceof Double) {
                obj = new Double(str);
            } else if (defValObj instanceof Byte) {
                obj = new Byte(str);
            } else if (defValObj instanceof Short) {
                obj = new Short(str);
            } else if (defValObj instanceof String) {
                obj = str;
            } else if (defValObj instanceof Boolean) {
                obj = new Boolean(str);
                boolTypeFlag = true;
            } else if (defValObj instanceof BooleanCp) {
                obj = new BooleanCp(str);
                boolTypeFlag = true;
            } else {
                obj = defValObj instanceof Color ? UtilFns.parseColor(str) : (defValObj instanceof Archivable ? UtilFns.parseArchivable((Archivable)defValObj, str) : UtilFns.parseObject(defValObj, str));
            }
            if (boolTypeFlag && !str.equalsIgnoreCase("true") && !str.equalsIgnoreCase("false")) {
                return null;
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return obj;
    }

    public synchronized String stringValue() {
        if (this.valueString == null) {
            this.valueString = IstiNamedValue.determineStringValue(this.value);
        }
        return this.valueString;
    }

    public synchronized String toString() {
        String nameString = "";
        if (this.name != null) {
            nameString = this.name + '=';
        }
        return nameString + this.stringValue();
    }

    protected synchronized Object checkValue(Object valueObj) {
        if (this.defaultValue instanceof Archivable && valueObj instanceof String) {
            valueObj = UtilFns.parseObject(this.defaultValue, (String)valueObj);
        }
        if (valueObj == null || valueObj.getClass() != this.defaultValue.getClass()) {
            return null;
        }
        return valueObj;
    }

    protected static String determineStringValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Color) {
            return UtilFns.colorToPropertyString((Color)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return UtilFns.floatNumberToPropertyString(value);
        }
        if (!(value instanceof Object[])) {
            return value.toString();
        }
        Object[] valueArr = (Object[])value;
        StringBuffer buff = new StringBuffer();
        if (valueArr.length > 0) {
            int i = 0;
            while (true) {
                if (valueArr[i] != null) {
                    buff.append(valueArr[i]);
                }
                if (++i >= valueArr.length) break;
                buff.append(" ");
            }
        }
        return buff.toString();
    }
}

