/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.BaseValueTableModel;
import com.isti.util.DelimiterSeparatedValues;
import com.isti.util.ValueTableModel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;

public class DelimiterSeparatedValuesTable
extends BaseValueTableModel
implements ValueTableModel {
    private static final String TEST_INPUT = "# comment\n,\"aaa \n\n\"\"a\", bbb ,cc c,\"ddd\",eee\"e,empty\n# comment\n,\"fff \n\n\"\"f\", ggg ,hh h,\"iii\",jjj\"j,\n";

    public int readAll(DelimiterSeparatedValues input, BufferedReader br, boolean headerFlag) throws IOException {
        int numColumns = 0;
        int count = 0;
        this.createLists();
        this.clearErrorMessageString();
        StringBuffer valueBuffer = new StringBuffer();
        List valueList = this.createList();
        while (true) {
            valueList.clear();
            input.readNext(br, valueList, valueBuffer);
            if (valueList.size() == 0) break;
            if (count == 0) {
                numColumns = valueList.size();
                if (headerFlag) {
                    this.setColumnNames(valueList);
                } else {
                    this.setColumnNames(numColumns);
                    this.addRow(valueList);
                }
            } else if (numColumns != valueList.size()) {
                this.appendErrorMessageString("Row " + count + " has the wrong number of columns (" + valueList.size() + " but should be " + numColumns + ")\n");
            } else {
                this.addRow(valueList);
            }
            ++count;
        }
        if (this.getErrorMessageFlag()) {
            return 0;
        }
        return count;
    }

    public void writeAll(DelimiterSeparatedValues output, Writer w, boolean headerFlag) throws IOException {
        if (headerFlag) {
            output.writeNext(w, this.getColumnNames());
        }
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            output.writeNext(w, this.getRow(rowIndex));
        }
    }

    public static void main(String[] args) {
        Reader reader;
        DelimiterSeparatedValuesTable dsvt = new DelimiterSeparatedValuesTable();
        String inputFileName = null;
        String outputFileName = null;
        if (args.length > 0) {
            inputFileName = args[0];
            if (args.length > 1) {
                outputFileName = args[1];
            }
        }
        if (inputFileName != null) {
            try {
                reader = new FileReader(inputFileName);
            }
            catch (Exception ex) {
                System.err.println("Could not open input file: " + ex);
                return;
            }
        } else {
            System.out.println(TEST_INPUT);
            reader = new StringReader(TEST_INPUT);
        }
        BufferedReader br = new BufferedReader(reader);
        DelimiterSeparatedValues input = new DelimiterSeparatedValues("#");
        DelimiterSeparatedValues output = new DelimiterSeparatedValues(DelimiterSeparatedValues.DEFAULT_COMMENT_TEXT, ',', "\"", '\\');
        FileWriter w = null;
        if (outputFileName != null) {
            try {
                w = new FileWriter(outputFileName);
            }
            catch (Exception ex) {
                System.err.println("Could not open output file: " + ex);
                return;
            }
        }
        try {
            int count = dsvt.readAll(input, br, true);
            if (count == 0) {
                String errorMessage = dsvt.getErrorMessageString();
                if (errorMessage.length() > 0) {
                    dsvt.clearErrorMessageString();
                    System.err.println("Error reading input:\n" + errorMessage);
                }
            } else {
                System.out.println("Found " + count + " lines");
                if (w != null) {
                    dsvt.writeAll(output, w, true);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
        if (w != null) {
            try {
                ((Writer)w).close();
            }
            catch (Exception ex) {
                System.err.println("Error closing output file: " + ex);
            }
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (Exception ex) {
                System.err.println("Error closing input file: " + ex);
            }
        }
    }
}

