/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Vector;

public class DelimiterSeparatedValues {
    public static final String DEFAULT_COMMENT_TEXT = null;
    public static final String STANDARD_COMMENT_TEXT = "#";
    public static final char DEFAULT_DELIMITER_CHAR = ',';
    public static final String DEFAULT_ESCAPED_CHARS = "\"";
    public static final char DEFAULT_ESCAPE_CHAR = '\"';
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int USE_QUOTES_NEVER = 0;
    public static final int USE_QUOTES_AS_NEEDED = 1;
    public static final int USE_QUOTES_ALWAYS = 2;
    private final String commentText;
    private final char delimiterChar;
    private final String reservedChars;
    private final String escapedChars;
    private final char escapeChar;
    private int useQuotesValue = 1;
    private int[] useQuotesValueArray = null;
    private String lineSeparator = DEFAULT_LINE_SEPARATOR;
    private static final String TEST_INPUT = "# comment\n,\"aaa \n\n\"\"a\", bbb ,cc c,\"ddd\",eee\"e,\n# comment\n,\"fff \n\n\"\"f\", ggg ,hh h,\"iii\",jjj\"j,\n";

    public DelimiterSeparatedValues() {
        this(DEFAULT_COMMENT_TEXT, ',', DEFAULT_ESCAPED_CHARS, '\"');
    }

    public DelimiterSeparatedValues(String commentText) {
        this(commentText, ',', DEFAULT_ESCAPED_CHARS, '\"');
    }

    public DelimiterSeparatedValues(String commentText, char delimiterChar, String escapeChars, char escapeChar) {
        this(commentText, delimiterChar, escapeChars, escapeChar, DelimiterSeparatedValues.getReservedChars(delimiterChar));
    }

    public DelimiterSeparatedValues(String commentText, char delimiterChar, String escapedChars, char escapeChar, String reservedChars) {
        this.commentText = commentText;
        this.delimiterChar = delimiterChar;
        this.escapedChars = escapedChars;
        this.escapeChar = escapeChar;
        this.reservedChars = reservedChars;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getQuotedText(String valueStr) {
        if (valueStr == null) {
            return null;
        }
        StringBuffer valueBuffer = new StringBuffer(valueStr.length() + 2);
        valueBuffer.append('\"');
        for (int i = 0; i < valueStr.length(); ++i) {
            char currentChar = valueStr.charAt(i);
            if (this.escapedChars.indexOf(currentChar) >= 0) {
                valueBuffer.append(this.escapeChar);
            }
            valueBuffer.append(currentChar);
        }
        valueBuffer.append('\"');
        return valueBuffer.toString();
    }

    public static String getReservedChars(char delimiterChar) {
        return "\n\r\"" + delimiterChar;
    }

    public int getUseQuotesValue() {
        return this.useQuotesValue;
    }

    public int getUseQuotesValue(int column) {
        if (this.useQuotesValueArray != null && column < this.useQuotesValueArray.length) {
            return this.useQuotesValueArray[column];
        }
        return this.getUseQuotesValue();
    }

    public String getValueStr(Object valueObj) {
        if (valueObj == null) {
            return null;
        }
        return valueObj.toString();
    }

    public void readNext(BufferedReader br, List valueList, StringBuffer valueBuffer) throws IOException {
        String line;
        char currentChar = '\u0000';
        boolean inQuotesFlag = false;
        valueBuffer.setLength(0);
        while ((line = br.readLine()) != null) {
            if (!inQuotesFlag) {
                if (this.commentText != null && line.startsWith(this.commentText)) {
                    continue;
                }
            } else if (line.length() == 0) {
                valueBuffer.append(this.getLineSeparator());
                continue;
            }
            int charIndex = 0;
            while (charIndex < line.length()) {
                block14: {
                    if (!inQuotesFlag && charIndex < line.length() && (currentChar = line.charAt(charIndex)) == '\"') {
                        ++charIndex;
                        inQuotesFlag = true;
                    }
                    if (!inQuotesFlag) break block14;
                    boolean escapeFoundFlag = false;
                    boolean quoteFoundFlag = false;
                    while (charIndex < line.length()) {
                        block19: {
                            block18: {
                                block20: {
                                    block21: {
                                        block15: {
                                            block16: {
                                                block17: {
                                                    currentChar = line.charAt(charIndex);
                                                    if (this.escapeChar != '\"') break block15;
                                                    if (currentChar != '\"') break block16;
                                                    if (!quoteFoundFlag) break block17;
                                                    quoteFoundFlag = false;
                                                    break block18;
                                                }
                                                quoteFoundFlag = true;
                                                break block19;
                                            }
                                            if (quoteFoundFlag) {
                                                break;
                                            }
                                            break block18;
                                        }
                                        if (escapeFoundFlag) break block20;
                                        if (currentChar != this.escapeChar) break block21;
                                        escapeFoundFlag = true;
                                        break block19;
                                    }
                                    if (currentChar == '\"') {
                                        quoteFoundFlag = true;
                                        ++charIndex;
                                        break;
                                    }
                                    break block18;
                                }
                                escapeFoundFlag = false;
                            }
                            valueBuffer.append(currentChar);
                        }
                        ++charIndex;
                    }
                    if (quoteFoundFlag) {
                        inQuotesFlag = false;
                    } else {
                        valueBuffer.append(this.getLineSeparator());
                    }
                }
                if (inQuotesFlag) continue;
                boolean lastCharDelimiterFlag = false;
                while (charIndex < line.length()) {
                    currentChar = line.charAt(charIndex);
                    if (currentChar == this.delimiterChar) {
                        lastCharDelimiterFlag = true;
                        ++charIndex;
                        break;
                    }
                    lastCharDelimiterFlag = false;
                    valueBuffer.append(currentChar);
                    ++charIndex;
                }
                DelimiterSeparatedValues.addValue(valueList, valueBuffer);
                if (charIndex < line.length() || !lastCharDelimiterFlag) continue;
                DelimiterSeparatedValues.addValue(valueList, valueBuffer);
            }
            if (inQuotesFlag) continue;
            break;
        }
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setUseQuotesValue(int v) {
        this.useQuotesValue = v;
    }

    public void setUseQuotesValue(int[] v) {
        this.useQuotesValueArray = v;
    }

    public boolean shouldBeQuoted(String valueStr, int column) {
        if (valueStr == null) {
            return false;
        }
        if (column == 0 && this.commentText != null && valueStr.startsWith(this.commentText)) {
            return true;
        }
        for (int i = 0; i < valueStr.length(); ++i) {
            char currentChar = valueStr.charAt(i);
            if (this.reservedChars.indexOf(currentChar) < 0) continue;
            return true;
        }
        return false;
    }

    public void writeNext(Writer w, List valueList) throws IOException {
        if (valueList != null && valueList.size() != 0) {
            for (int column = 0; column < valueList.size(); ++column) {
                String valueStr;
                if (column > 0) {
                    w.write(this.delimiterChar);
                }
                if ((valueStr = this.getValueStr(valueList.get(column))) == null) continue;
                int columnUseQuotesValue = this.getUseQuotesValue(column);
                if (columnUseQuotesValue == 2 || columnUseQuotesValue == 1 && this.shouldBeQuoted(valueStr, column)) {
                    valueStr = this.getQuotedText(valueStr);
                }
                w.write(valueStr);
            }
            w.write(this.getLineSeparator());
        }
    }

    private static void addValue(List valueList, StringBuffer valueBuffer) {
        valueList.add(valueBuffer.toString());
        valueBuffer.setLength(0);
    }

    public static void main(String[] args) {
        Reader reader;
        boolean printValuesFlag = true;
        String inputFileName = null;
        String outputFileName = null;
        if (args.length > 0) {
            inputFileName = args[0];
            printValuesFlag = false;
            if (args.length > 1) {
                outputFileName = args[1];
            }
        }
        if (inputFileName != null) {
            try {
                reader = new FileReader(inputFileName);
            }
            catch (Exception ex) {
                System.err.println("Could not open input file: " + ex);
                return;
            }
        } else {
            System.out.println(TEST_INPUT);
            reader = new StringReader(TEST_INPUT);
        }
        BufferedReader br = new BufferedReader(reader);
        DelimiterSeparatedValues input = new DelimiterSeparatedValues(STANDARD_COMMENT_TEXT, ',', DEFAULT_ESCAPED_CHARS, '\"');
        DelimiterSeparatedValues output = new DelimiterSeparatedValues(DEFAULT_COMMENT_TEXT, ',', DEFAULT_ESCAPED_CHARS, '\\');
        FileWriter w = null;
        if (outputFileName != null) {
            try {
                w = new FileWriter(outputFileName);
            }
            catch (Exception ex) {
                System.err.println("Could not open output file: " + ex);
                return;
            }
        }
        try {
            StringBuffer valueBuffer = new StringBuffer();
            Vector valueList = new Vector();
            int count = 0;
            while (true) {
                valueList.clear();
                input.readNext(br, valueList, valueBuffer);
                if (valueList.size() == 0) break;
                ++count;
                for (int i = 0; i < valueList.size(); ++i) {
                    if (!printValuesFlag) continue;
                    System.out.println(count + "[" + i + "]: \"" + valueList.get(i) + DEFAULT_ESCAPED_CHARS);
                }
                if (w == null) continue;
                output.writeNext(w, valueList);
            }
            System.out.println("Found " + count + " lines");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (w != null) {
            try {
                ((Writer)w).close();
            }
            catch (Exception ex) {
                System.err.println("Error closing output file: " + ex);
            }
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (Exception ex) {
                System.err.println("Error closing input file: " + ex);
            }
        }
    }
}

