/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.ErrorMessageMgr;
import com.isti.util.ValueTableModel;
import com.isti.util.VectorSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BaseValueTableModel
implements ValueTableModel {
    private List rows;
    private List columnNames;
    private List readOnlyColumnNames;
    private Map columnMap;
    private final ErrorMessageMgr errorMessageMgr;
    private boolean editableFlag = false;
    static /* synthetic */ Class class$java$lang$Object;

    public BaseValueTableModel() {
        this.clearLists();
        this.errorMessageMgr = new ErrorMessageMgr();
    }

    public synchronized void clearErrorMessageString() {
        this.errorMessageMgr.clearErrorMessageString();
    }

    public final void clearLists() {
        this.rows = Collections.EMPTY_LIST;
        this.columnNames = Collections.EMPTY_LIST;
        this.readOnlyColumnNames = Collections.EMPTY_LIST;
        this.columnMap = Collections.EMPTY_MAP;
    }

    public void clearRows() {
        if (!this.columnsExist()) {
            this.createLists();
        } else {
            this.rows.clear();
            this.columnMap.clear();
        }
    }

    public boolean columnsExist() {
        return this.columnNames.size() != 0;
    }

    public void createLists() {
        this.rows = this.createRowsList();
        this.columnNames = this.createColumnNamesList();
        this.readOnlyColumnNames = Collections.EMPTY_LIST;
        this.columnMap = this.createColumnMap();
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$Object == null ? (class$java$lang$Object = BaseValueTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getColumnIndex(String columnName) {
        for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
            if (!this.getColumnName(columnIndex).equals(columnName)) continue;
            return columnIndex;
        }
        return -1;
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex).toString();
    }

    public boolean getErrorMessageFlag() {
        return this.errorMessageMgr.getErrorMessageFlag();
    }

    public String getErrorMessageString() {
        return this.errorMessageMgr.getErrorMessageString();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = this.getRawValueAt(rowIndex, columnIndex);
        return value;
    }

    public Object getRawValueAt(int rowIndex, int columnIndex) {
        return this.getModifiableRow(rowIndex).get(columnIndex);
    }

    public void importValues(ValueTableModel vtm) {
        if (!this.columnsExist()) {
            this.createLists();
            this.setColumnNames(vtm);
        }
        int numRows = vtm.getRowCount();
        for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
            this.importValues(vtm, rowIndex);
        }
    }

    protected void importValues(ValueTableModel vtm, int rowIndex) {
        int fromColumnCount = vtm.getColumnCount();
        List columnList = this.createFixedSizeList(this.getColumnCount());
        for (int fromColumnIndex = 0; fromColumnIndex < fromColumnCount; ++fromColumnIndex) {
            String columnName = vtm.getColumnName(fromColumnIndex);
            int toColumnIndex = this.getColumnIndex(columnName);
            if (toColumnIndex < 0) continue;
            columnList.set(toColumnIndex, vtm.getValueAt(rowIndex, fromColumnIndex));
        }
        this.addFixedSizeRow(columnList);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isEditable()) {
            return false;
        }
        return !this.readOnlyColumnNames.contains(this.getColumnName(columnIndex));
    }

    protected void addReadOnlyColumn(String columnName) {
        if (this.readOnlyColumnNames.size() == 0) {
            this.readOnlyColumnNames = new VectorSet();
        }
        this.readOnlyColumnNames.add(columnName);
    }

    public final boolean isEditable() {
        return this.editableFlag;
    }

    public final void setEditable(boolean flag) {
        this.editableFlag = flag;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getModifiableRow(rowIndex).set(columnIndex, aValue);
    }

    protected void addRow(List columnList) {
        this.addFixedSizeRow(this.createFixedSizeList(columnList));
    }

    protected void addFixedSizeRow(List columnList) {
        Object columnMapKey = this.getColumnMapKey(columnList);
        List columnMapValues = this.getColumnMapValues(columnMapKey);
        if (columnMapValues != null) {
            for (int i = 0; i < columnList.size(); ++i) {
                columnMapValues.set(i, columnList.get(i));
            }
            return;
        }
        this.addColumnMapValues(columnMapKey, columnList);
        this.rows.add(columnList);
    }

    protected Object getColumnMapKey(List columnList) {
        return columnList;
    }

    protected void addColumnMapValues(Object columnMapKey, List columnList) {
        if (columnMapKey != null) {
            this.columnMap.put(columnMapKey, columnList);
        }
    }

    protected List getColumnMapValues(Object columnMapKey) {
        if (columnMapKey != null) {
            return (List)this.columnMap.get(columnMapKey);
        }
        return null;
    }

    protected void appendErrorMessageString(String str) {
        if (this.getErrorMessageFlag()) {
            str = this.getErrorMessageString() + "\n" + str;
        }
        this.setErrorMessageString(str);
    }

    protected List createFixedSizeList(int size) {
        return Arrays.asList(new Object[size]);
    }

    protected List createFixedSizeList(Collection c) {
        return Arrays.asList(c.toArray());
    }

    protected Map createColumnMap() {
        return this.createMap();
    }

    protected List createColumnNamesList() {
        return this.createList();
    }

    protected List createList() {
        return new ArrayList();
    }

    protected Map createMap() {
        return new HashMap();
    }

    protected List createRowsList() {
        return this.createList();
    }

    protected List getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    protected String getDefaultColumnName(int columnIndex) {
        StringBuffer buffer = new StringBuffer();
        while (columnIndex >= 0) {
            buffer.insert(0, (char)(65 + columnIndex % 26));
            columnIndex = columnIndex / 26 - 1;
        }
        return buffer.toString();
    }

    protected List getRow(int rowIndex) {
        return Collections.unmodifiableList(this.getModifiableRow(rowIndex));
    }

    protected boolean isNull(Object valueObj) {
        return valueObj == null || valueObj.toString().length() == 0;
    }

    protected void setColumnNames(int numColumns) {
        for (int i = 0; i < numColumns; ++i) {
            this.columnNames.add(this.getDefaultColumnName(i));
        }
    }

    protected boolean setColumnNames(List l) {
        if (l.size() != new HashSet(l).size()) {
            this.appendErrorMessageString("Header contains duplicate columns: " + l);
            return false;
        }
        this.columnNames.addAll(l);
        return true;
    }

    protected void setColumnNames(ValueTableModel vtm) {
        int numColumns = vtm.getColumnCount();
        for (int columnIndex = 0; columnIndex < numColumns; ++columnIndex) {
            this.columnNames.add(vtm.getColumnName(columnIndex));
        }
    }

    protected void setErrorMessageString(String str) {
        this.errorMessageMgr.setErrorMessageString(str);
    }

    private List getModifiableRow(int rowIndex) {
        return (List)this.rows.get(rowIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

