/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.DataChangedListener;
import com.isti.util.ErrorMessageMgr;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public class AddrPortListMgr
extends ErrorMessageMgr {
    protected static char sepCh = (char)58;
    protected final Vector entriesVec = new Vector();
    protected DataChangedListener listCommitListenerObj = null;
    protected boolean keepDefaultServersFlag = false;
    protected final Random randomObj = new Random(System.currentTimeMillis());

    public AddrPortListMgr() {
    }

    public AddrPortListMgr(String dataListStr, char itemSepChar) {
        this.addEntriesListStr(dataListStr, itemSepChar);
    }

    public AddrPortListMgr(String dataListStr) {
        this.addEntriesListStr(dataListStr);
    }

    public EntryBlock parseEntry(String dataStr) {
        int portNum;
        int sepPos;
        this.clearErrorMessageString();
        if (dataStr == null || (sepPos = (dataStr = dataStr.trim()).indexOf(sepCh)) < 0) {
            this.setErrorMessageString("Separator '" + sepCh + "' not found");
            return null;
        }
        if (sepCh <= '\u0000') {
            this.setErrorMessageString("Host-address data not found");
            return null;
        }
        try {
            portNum = Integer.parseInt(dataStr.substring(sepPos + 1));
        }
        catch (NumberFormatException ex) {
            this.setErrorMessageString("Unable to parse port number value (\"" + dataStr.substring(sepPos + 1) + "\")");
            return null;
        }
        return new EntryBlock(dataStr.substring(0, sepPos), portNum);
    }

    public boolean contains(EntryBlock blkObj) {
        return this.entriesVec.contains(blkObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(EntryBlock blkObj) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            if (this.entriesVec.contains(blkObj)) {
                return false;
            }
            this.entriesVec.add(blkObj);
            return true;
        }
    }

    public boolean addEntry(String addrStr, int portNum) {
        return this.addEntry(new EntryBlock(addrStr, portNum));
    }

    public boolean addEntry(String dataStr) {
        EntryBlock blkObj = this.parseEntry(dataStr);
        if (blkObj == null) {
            return false;
        }
        this.addEntry(blkObj);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addEntriesListStr(String dataListStr, char itemSepChar) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            int itemSepPos;
            int dataListStrLen;
            if (dataListStr == null || (dataListStrLen = (dataListStr = dataListStr.trim()).length()) <= 0) {
                return true;
            }
            int sPos = 0;
            do {
                String itemStr;
                if ((itemSepPos = dataListStr.indexOf(itemSepChar, sPos)) < 0) {
                    itemSepPos = dataListStrLen;
                }
                if (this.addEntry(itemStr = dataListStr.substring(sPos, itemSepPos))) continue;
                this.setErrorMessageString("Error in item \"" + itemStr + "\" (at " + (sPos + 1) + "):  " + this.getErrorMessageString());
                return false;
            } while ((sPos = itemSepPos + 1) < dataListStrLen);
            return true;
        }
    }

    public final boolean addEntriesListStr(String dataListStr) {
        return this.addEntriesListStr(dataListStr, ',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEntriesListStr(String dataListStr, char itemSepChar) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            this.entriesVec.clear();
            this.addEntriesListStr(dataListStr, itemSepChar);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEntriesListStr(String dataListStr) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            this.entriesVec.clear();
            this.addEntriesListStr(dataListStr);
            return true;
        }
    }

    public int size() {
        return this.entriesVec.size();
    }

    public boolean removeEntry(EntryBlock blkObj) {
        return this.entriesVec.remove(blkObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryBlock removeEntry(String addrStr, int portNum) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            EntryBlock blkObj = new EntryBlock(addrStr, portNum);
            int idx = this.entriesVec.indexOf(blkObj);
            if (idx >= 0) {
                Object obj = this.entriesVec.remove(idx);
                EntryBlock entryBlock = obj instanceof EntryBlock ? (EntryBlock)obj : blkObj;
                return entryBlock;
            }
            return null;
        }
    }

    public void clearAllEntries() {
        this.entriesVec.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryBlock getEntry(int idx) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            if (idx < 0 || idx > this.entriesVec.size()) {
                return null;
            }
            Object obj = this.entriesVec.get(idx);
            EntryBlock entryBlock = obj instanceof EntryBlock ? (EntryBlock)obj : null;
            return entryBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryBlock popFirstEntry() {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            Object obj;
            EntryBlock blkObj = this.entriesVec.size() > 0 ? ((obj = this.entriesVec.remove(0)) instanceof EntryBlock ? (EntryBlock)obj : null) : null;
            return blkObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryBlock popFirstAndAddEntry(EntryBlock blkObj) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            EntryBlock poppedObj = this.popFirstEntry();
            this.addEntry(blkObj);
            return poppedObj;
        }
    }

    public EntryBlock popFirstAndAddEntry(String addrStr, int portNum) {
        return this.popFirstAndAddEntry(new EntryBlock(addrStr, portNum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryBlock popRandomEntry() {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            Object obj;
            int numEntries = this.entriesVec.size();
            EntryBlock blkObj = numEntries > 0 ? ((obj = this.entriesVec.remove(this.randomObj.nextInt(numEntries))) instanceof EntryBlock ? (EntryBlock)obj : null) : null;
            return blkObj;
        }
    }

    public boolean equalsFirstEntry(String hostAddr, int portNum) {
        EntryBlock blkObj = this.getEntry(0);
        return blkObj != null ? blkObj.equals(hostAddr, portNum) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntriesListStr(char itemSepChar, boolean randomFlag) {
        StringBuffer buff = new StringBuffer();
        if (randomFlag) {
            Vector vec;
            Vector vector = this.entriesVec;
            synchronized (vector) {
                vec = new Vector(this.entriesVec);
            }
            int vecSize = vec.size();
            if (vecSize > 0) {
                while (true) {
                    Object obj;
                    if ((obj = vec.remove(this.randomObj.nextInt(vecSize))) instanceof EntryBlock) {
                        buff.append(((EntryBlock)obj).toString());
                    }
                    if (--vecSize > 0) {
                        buff.append(itemSepChar);
                        continue;
                    }
                    break;
                }
            }
        } else {
            Vector vector = this.entriesVec;
            synchronized (vector) {
                Iterator iterObj = ((AbstractList)this.entriesVec).iterator();
                if (iterObj.hasNext()) {
                    while (true) {
                        Object obj;
                        if ((obj = iterObj.next()) instanceof EntryBlock) {
                            buff.append(((EntryBlock)obj).toString());
                        }
                        if (!iterObj.hasNext()) break;
                        buff.append(itemSepChar);
                    }
                }
            }
        }
        return buff.toString();
    }

    public String getEntriesListStr(char itemSepChar) {
        return this.getEntriesListStr(itemSepChar, false);
    }

    public String getEntriesListStr(boolean randomFlag) {
        return this.getEntriesListStr(',', randomFlag);
    }

    public String getEntriesListStr() {
        return this.getEntriesListStr(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popAllEntries(char itemSepChar) {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            String retStr = this.getEntriesListStr(itemSepChar);
            this.entriesVec.clear();
            return retStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popAllEntries() {
        Vector vector = this.entriesVec;
        synchronized (vector) {
            String retStr = this.getEntriesListStr();
            this.entriesVec.clear();
            return retStr;
        }
    }

    public void setListCommitListenerObj(DataChangedListener listenerObj) {
        this.listCommitListenerObj = listenerObj;
    }

    public void fireListCommit(Object sourceObj) {
        if (this.listCommitListenerObj != null) {
            this.listCommitListenerObj.dataChanged(sourceObj);
        }
    }

    public static void setSeparatorChar(char ch) {
        sepCh = ch;
    }

    public static char getSeparatorChar() {
        return sepCh;
    }

    public void setKeepDefaultServersFlag(boolean flgVal) {
        this.keepDefaultServersFlag = flgVal;
    }

    public boolean getKeepDefaultServersFlag() {
        return this.keepDefaultServersFlag;
    }

    public static class EntryBlock {
        public final String hostAddrStr;
        public final int portNumber;

        public EntryBlock(String hostAddrStr, int portNumber) {
            this.hostAddrStr = hostAddrStr;
            this.portNumber = portNumber;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryBlock)) {
                return false;
            }
            EntryBlock blkObj = (EntryBlock)obj;
            if (this.hostAddrStr != null ? !this.hostAddrStr.equals(blkObj.hostAddrStr) : blkObj.hostAddrStr != null) {
                return false;
            }
            return this.portNumber == blkObj.portNumber;
        }

        public boolean equals(String hostAddr, int portNum) {
            if (this.hostAddrStr != null ? !this.hostAddrStr.equals(hostAddr) : hostAddr != null) {
                return false;
            }
            return this.portNumber == portNum;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.hostAddrStr + sepCh + this.portNumber;
        }
    }
}

