/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.util.AddServerWindow;
import org.jacorb.imr.util.ConnectWindow;
import org.jacorb.imr.util.ImRModel;
import org.jacorb.imr.util.ImRTableCellEditor;
import org.jacorb.imr.util.ImRTreeCellRenderer;
import org.jacorb.imr.util.RefreshWindow;

public class ImRManagerGUI
extends JFrame {
    private JMenuItem m_exit_mi;
    private JMenuItem m_about_mi;
    private JMenuItem m_refresh_all_mi;
    private JMenuItem m_connect_mi;
    private JMenuItem m_shutdown_mi;
    private JMenuItem m_forcedown_mi;
    private JMenuItem m_save_mi;
    private JMenuItem m_add_mi;
    private JMenuItem m_remove_mi;
    private JMenuItem m_hold_mi;
    private JMenuItem m_release_mi;
    private JMenuItem m_setdown_mi;
    private JMenuItem m_refresh_mi;
    private JMenuItem m_auto_refresh_mi;
    private EventHandler m_handler = new EventHandler();
    private ImRModel m_model = new ImRModel();
    private DefaultMutableTreeNode m_top_node;
    private JTree m_tree;
    private JPanel m_table_panel;
    private JScrollPane m_server_view;
    private JScrollPane m_poa_view;
    private JScrollPane m_tree_view;
    private JTable m_server_table;
    private JTable m_poa_table;
    private JPopupMenu m_context_menu;
    private JMenuItem m_add_cmi;
    private JMenuItem m_remove_cmi;
    private JMenuItem m_hold_cmi;
    private JMenuItem m_release_cmi;
    private JMenuItem m_setdown_cmi;
    private JMenuItem m_refresh_cmi;

    public ImRManagerGUI() {
        super("ImR Manager");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Manager");
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("ImR");
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Server");
        jMenuBar.add(jMenu3);
        this.m_about_mi = new JMenuItem("About...");
        this.m_about_mi.addActionListener(this.m_handler);
        jMenu.add(this.m_about_mi);
        this.m_auto_refresh_mi = new JMenuItem("Automatic Refresh...");
        this.m_auto_refresh_mi.addActionListener(this.m_handler);
        jMenu.add(this.m_auto_refresh_mi);
        this.m_exit_mi = new JMenuItem("Exit");
        this.m_exit_mi.addActionListener(this.m_handler);
        jMenu.add(this.m_exit_mi);
        this.m_shutdown_mi = new JMenuItem("Shutdown");
        this.m_shutdown_mi.addActionListener(this.m_handler);
        jMenu2.add(this.m_shutdown_mi);
        this.m_forcedown_mi = new JMenuItem("Force Down");
        this.m_forcedown_mi.addActionListener(this.m_handler);
        jMenu2.add(this.m_forcedown_mi);
        this.m_save_mi = new JMenuItem("Save Server Table");
        this.m_save_mi.addActionListener(this.m_handler);
        jMenu2.add(this.m_save_mi);
        jMenu2.addSeparator();
        this.m_connect_mi = new JMenuItem("Connect...");
        this.m_connect_mi.addActionListener(this.m_handler);
        jMenu2.add(this.m_connect_mi);
        this.m_refresh_all_mi = new JMenuItem("Refresh all");
        this.m_refresh_all_mi.addActionListener(this.m_handler);
        jMenu2.add(this.m_refresh_all_mi);
        this.m_add_mi = new JMenuItem("Add...");
        this.m_add_mi.addActionListener(this.m_handler);
        jMenu3.add(this.m_add_mi);
        this.m_remove_mi = new JMenuItem("Remove");
        this.m_remove_mi.addActionListener(this.m_handler);
        jMenu3.add(this.m_remove_mi);
        this.m_hold_mi = new JMenuItem("Hold");
        this.m_hold_mi.addActionListener(this.m_handler);
        jMenu3.add(this.m_hold_mi);
        this.m_release_mi = new JMenuItem("Release");
        this.m_release_mi.addActionListener(this.m_handler);
        jMenu3.add(this.m_release_mi);
        this.m_setdown_mi = new JMenuItem("Set Down");
        this.m_setdown_mi.addActionListener(this.m_handler);
        jMenu3.add(this.m_setdown_mi);
        jMenu3.addSeparator();
        this.m_refresh_mi = new JMenuItem("Refresh");
        this.m_refresh_mi.addActionListener(this.m_handler);
        jMenu3.add(this.m_refresh_mi);
        this.m_context_menu = new JPopupMenu("Server manipulation");
        this.m_context_menu.setVisible(true);
        this.m_add_cmi = new JMenuItem("Add...");
        this.m_add_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_add_cmi);
        this.m_remove_cmi = new JMenuItem("Remove");
        this.m_remove_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_remove_cmi);
        this.m_context_menu.addSeparator();
        this.m_hold_cmi = new JMenuItem("Hold");
        this.m_hold_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_hold_cmi);
        this.m_release_cmi = new JMenuItem("Release");
        this.m_release_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_release_cmi);
        this.m_setdown_cmi = new JMenuItem("Set Down");
        this.m_setdown_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_setdown_cmi);
        this.m_context_menu.addSeparator();
        this.m_refresh_cmi = new JMenuItem("Refresh");
        this.m_refresh_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_refresh_cmi);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.m_tree = this.m_model.getTree();
        this.m_tree.setEditable(false);
        this.m_tree.setCellRenderer(new ImRTreeCellRenderer());
        this.m_tree.addTreeSelectionListener(this.m_handler);
        this.m_tree.addMouseListener(this.m_handler);
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_tree_view = new JScrollPane(this.m_tree);
        this.m_tree_view.addMouseListener(this.m_handler);
        this.m_table_panel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.m_table_panel.setLayout(gridBagLayout2);
        TableModel tableModel = this.m_model.getServerTableModel();
        this.m_server_table = new JTable(tableModel);
        this.m_server_table.addMouseListener(this.m_handler);
        ListSelectionModel listSelectionModel = this.m_server_table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this.m_handler);
        TableColumn tableColumn = this.m_server_table.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new ImRTableCellEditor(this.m_model.getHostSelector()));
        this.m_server_view = new JScrollPane(this.m_server_table);
        this.m_server_view.setVisible(true);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(this.m_server_view, gridBagConstraints);
        this.m_table_panel.add(this.m_server_view);
        TableModel tableModel2 = this.m_model.getPOATableModel();
        this.m_poa_table = new JTable(tableModel2);
        this.m_poa_view = new JScrollPane(this.m_poa_table);
        this.m_poa_view.setVisible(false);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(this.m_poa_view, gridBagConstraints);
        this.m_table_panel.add(this.m_poa_view);
        JSplitPane jSplitPane = new JSplitPane(1, this.m_tree_view, this.m_table_panel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(150);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jSplitPane, gridBagConstraints);
        jPanel.add(jSplitPane);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setVisible(true);
    }

    private void showPOATable() {
        if (!this.m_poa_view.isVisible()) {
            this.m_server_view.setVisible(false);
            this.m_poa_view.setVisible(true);
            this.pack();
            this.m_table_panel.repaint();
        }
    }

    private void showServerTable() {
        if (!this.m_server_view.isVisible()) {
            this.m_poa_view.setVisible(false);
            this.m_server_view.setVisible(true);
            this.pack();
            this.m_table_panel.repaint();
        }
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public static void main(String[] stringArray) {
        new ImRManagerGUI();
    }

    private class EventHandler
    implements MouseListener,
    ListSelectionListener,
    TreeSelectionListener,
    ActionListener,
    Serializable {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                if ((JMenuItem)object == ImRManagerGUI.this.m_exit_mi) {
                    System.exit(0);
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_about_mi) {
                    JOptionPane.showMessageDialog(new JFrame(), "FUB - Institute for Computer Sciences\n\nThe man with the plan: Gerald Brose\nThe imp to get along with the plans: Nicolas Noffke\n");
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_auto_refresh_mi) {
                    new RefreshWindow(ImRManagerGUI.this.m_model);
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_refresh_all_mi) {
                    ImRManagerGUI.this.m_model.fetchServers();
                    ImRManagerGUI.this.showServerTable();
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_connect_mi) {
                    new ConnectWindow(ImRManagerGUI.this.m_model);
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_shutdown_mi) {
                    ImRManagerGUI.this.m_model.imrShutdown(true);
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_forcedown_mi) {
                    ImRManagerGUI.this.m_model.imrShutdown(false);
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_save_mi) {
                    ImRManagerGUI.this.m_model.saveTable();
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_add_mi || (JMenuItem)object == ImRManagerGUI.this.m_add_cmi) {
                    new AddServerWindow(ImRManagerGUI.this.m_model);
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_remove_mi || (JMenuItem)object == ImRManagerGUI.this.m_remove_cmi) {
                    int n = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (n > -1) {
                        ImRManagerGUI.this.m_model.removeServer(n);
                    } else {
                        TreePath treePath = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (treePath != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                            Object object2 = defaultMutableTreeNode.getUserObject();
                            if (object2 instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.removeServer(((ServerInfo)object2).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to remove!");
                        }
                    }
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_hold_mi || (JMenuItem)object == ImRManagerGUI.this.m_hold_cmi) {
                    int n = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (n > -1) {
                        ImRManagerGUI.this.m_model.holdServer(n);
                    } else {
                        TreePath treePath = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (treePath != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                            Object object3 = defaultMutableTreeNode.getUserObject();
                            if (object3 instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.holdServer(((ServerInfo)object3).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to hold!");
                        }
                    }
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_refresh_mi || (JMenuItem)object == ImRManagerGUI.this.m_refresh_cmi) {
                    int n = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (n > -1) {
                        ImRManagerGUI.this.m_model.refreshServer(n);
                    } else {
                        TreePath treePath = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (treePath != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                            Object object4 = defaultMutableTreeNode.getUserObject();
                            if (object4 instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.refreshServer(((ServerInfo)object4).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to refresh!");
                        }
                    }
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_release_mi || (JMenuItem)object == ImRManagerGUI.this.m_release_cmi) {
                    int n = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (n > -1) {
                        ImRManagerGUI.this.m_model.releaseServer(n);
                    } else {
                        TreePath treePath = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (treePath != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                            Object object5 = defaultMutableTreeNode.getUserObject();
                            if (object5 instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.releaseServer(((ServerInfo)object5).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to release!");
                        }
                    }
                } else if ((JMenuItem)object == ImRManagerGUI.this.m_setdown_mi || (JMenuItem)object == ImRManagerGUI.this.m_setdown_cmi) {
                    int n = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (n > -1) {
                        ImRManagerGUI.this.m_model.setServerDown(n);
                    } else {
                        TreePath treePath = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (treePath != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                            Object object6 = defaultMutableTreeNode.getUserObject();
                            if (object6 instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.setServerDown(((ServerInfo)object6).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to set down!");
                        }
                    }
                }
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ServerInfo) {
                ImRManagerGUI.this.m_poa_table.clearSelection();
                ImRManagerGUI.this.m_server_table.clearSelection();
                ImRManagerGUI.this.showServerTable();
            } else if (object instanceof ImRInfo) {
                ImRManagerGUI.this.m_server_table.clearSelection();
                ImRManagerGUI.this.showServerTable();
            } else if (object instanceof POAInfo) {
                ImRManagerGUI.this.m_server_table.clearSelection();
                ServerInfo serverInfo = (ServerInfo)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                ImRManagerGUI.this.m_model.poaTableForServer(serverInfo);
                if (ImRManagerGUI.this.m_poa_table.getRowCount() > 1) {
                    int n = ImRManagerGUI.this.m_model.getRow(serverInfo, (POAInfo)object);
                    ImRManagerGUI.this.m_poa_table.clearSelection();
                    ImRManagerGUI.this.m_poa_table.setRowSelectionInterval(n, n);
                }
                ImRManagerGUI.this.showPOATable();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                ImRManagerGUI.this.m_tree.clearSelection();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.maybeShowContextMenu(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowContextMenu(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowContextMenu(mouseEvent);
        }

        private void maybeShowContextMenu(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                TreePath treePath;
                Component component = mouseEvent.getComponent();
                if (component == ImRManagerGUI.this.m_server_table) {
                    if (ImRManagerGUI.this.m_server_table.getSelectedRow() > -1) {
                        ImRManagerGUI.this.m_context_menu.show(component, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (component == ImRManagerGUI.this.m_tree && (treePath = ImRManagerGUI.this.m_tree.getSelectionPath()) != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof ServerInfo) {
                    ImRManagerGUI.this.m_context_menu.show(component, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

