/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.NetworkJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;

public class StationJson
extends AbstractJsonApiData {
    StationImpl sta;
    List<ChannelImpl> chanList;

    public StationJson(StationImpl sta, String baseUrl) {
        this(sta, null, baseUrl);
    }

    public StationJson(StationImpl sta, List<ChannelImpl> chanList, String baseUrl) {
        super(baseUrl);
        this.sta = sta;
        this.chanList = chanList;
    }

    @Override
    public String getType() {
        return "station";
    }

    @Override
    public String getId() {
        return new NetworkJson((NetworkAttr)this.sta.getNetworkAttrImpl(), this.baseUrl).getId() + "." + this.sta.get_code();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("station-code").value((Object)this.sta.get_code()).key("name").value((Object)this.sta.getName()).key("start-time").value((Object)this.sta.getBeginTime().date_time).key("end-time").value(NetworkJson.encodeEndTime(this.sta.getEndTime())).key("description").value((Object)this.sta.getDescription()).key("latitude").value((double)this.sta.getLocation().latitude).key("longitude").value((double)this.sta.getLocation().longitude).key("elevation").value(((QuantityImpl)this.sta.getLocation().elevation).getValue(UnitImpl.METER));
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("network").object();
        out.key("data").object();
        out.key("id").value((Object)new NetworkJson((NetworkAttr)this.sta.getNetworkAttrImpl(), this.baseUrl).getId());
        out.key("type").value((Object)"network");
        out.endObject();
        out.endObject();
        out.key("esps").object().key("links").object().key("related").value((Object)this.formEventRelationshipURL(this.sta));
        out.endObject();
        out.endObject();
        out.key("channels").object();
        out.key("links").object();
        out.key("related").value((Object)this.formChannelRelationshipURL(this.sta));
        out.endObject();
        out.endObject();
    }

    @Override
    public boolean hasLinks() {
        return true;
    }

    @Override
    public void encodeLinks(JSONWriter out) throws JSONException {
        out.key("self").value((Object)this.formStationURL(this.sta));
    }

    public static List<JsonApiData> toJsonList(List<StationImpl> staList, String baseUrl) {
        ArrayList<JsonApiData> out = new ArrayList<JsonApiData>(staList.size());
        for (StationImpl stationImpl : staList) {
            out.add(new StationJson(stationImpl, baseUrl));
        }
        return out;
    }

    public String formStationURL(StationImpl sta) {
        NetworkJson netJson = new NetworkJson(sta.getNetworkAttr(), this.baseUrl);
        String out = this.baseUrl + "/networks/" + netJson.getId() + "/stations/" + this.getId();
        return out;
    }

    public String formEventRelationshipURL(StationImpl sta) {
        String out = this.baseUrl + "/stations/" + this.getId() + "/quakes";
        return out;
    }

    public String formChannelRelationshipURL(StationImpl sta) {
        String out = this.baseUrl + "/stations/" + this.getId() + "/channels";
        return out;
    }
}

