/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONWriter;

public class NetworkJson
extends AbstractJsonApiData {
    NetworkAttr net;

    public NetworkJson(NetworkAttr net, String baseUrl) {
        super(baseUrl);
        this.net = net;
    }

    @Override
    public String getType() {
        return "network";
    }

    @Override
    public String getId() {
        String s = this.net.get_code();
        if (NetworkIdUtil.isTemporary((NetworkId)this.net.getId())) {
            s = s + "_" + this.net.getBeginTime().date_time.substring(0, 4);
        }
        return s;
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("network-code").value((Object)this.net.getId().network_code).key("start-time").value((Object)this.net.getId().begin_time.date_time).key("end-time").value(NetworkJson.encodeEndTime(this.net.getEndTime())).key("description").value((Object)this.net.getDescription());
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("stations").object().key("links").object().key("self").value((Object)this.formStationRelationshipURL(this.net)).key("related").value((Object)this.formStationListURL(this.net));
        out.endObject();
        out.endObject();
    }

    @Override
    public boolean hasLinks() {
        return true;
    }

    @Override
    public void encodeLinks(JSONWriter out) throws JSONException {
        out.key("self").value((Object)this.formNetworkURL(this.net));
    }

    public String formStationRelationshipURL(NetworkAttr net) {
        String out = this.baseUrl + "/networks/" + this.getId() + "/relationships/stations";
        return out;
    }

    public String formNetworkURL(NetworkAttr net) {
        String out = this.baseUrl + "/networks/" + this.getId();
        return out;
    }

    public String formStationListURL(NetworkAttr net) {
        String out = this.baseUrl + "/networks/" + this.getId() + "/stations";
        return out;
    }

    public static Object encodeEndTime(Time endTime) {
        MicroSecondDate endDate = new MicroSecondDate(endTime);
        if (endDate.before((Date)ClockUtil.now())) {
            return ISOTime.getISOString((MicroSecondDate)endDate);
        }
        return null;
    }
}

