/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;

public class JsonApi {
    public static void encodeJson(JSONWriter out, JsonApiData data) throws JSONException {
        out.object();
        out.key("data").object();
        JsonApi.encodeInner(out, data);
        out.endObject();
        List<JsonApiData> include = data.included();
        if (include.size() > 0) {
            out.key("included").array();
            for (JsonApiData jsonApiData : include) {
                out.object();
                JsonApi.encodeInner(out, jsonApiData);
                out.endObject();
            }
            out.endArray();
        }
        out.endObject();
    }

    static void encodeInner(JSONWriter out, JsonApiData data) {
        out.key("id").value((Object)data.getId());
        out.key("type").value((Object)data.getType());
        out.key("attributes").object();
        data.encodeAttributes(out);
        out.endObject();
        if (data.hasLinks()) {
            out.key("links").object();
            data.encodeLinks(out);
            out.endObject();
        }
        if (data.hasRelationships()) {
            out.key("relationships").object();
            data.encodeRelationships(out);
            out.endObject();
        }
    }

    public static void encodeJson(JSONWriter out, List<JsonApiData> dataList) throws JSONException {
        out.object();
        out.key("data").array();
        for (JsonApiData jsonApiData : dataList) {
            out.object();
            out.key("id").value((Object)jsonApiData.getId());
            out.key("type").value((Object)jsonApiData.getType());
            out.endObject();
        }
        out.endArray();
        ArrayList<JsonApiData> toInclude = new ArrayList<JsonApiData>();
        toInclude.addAll(dataList);
        for (JsonApiData jsonApiData : dataList) {
            toInclude.addAll(jsonApiData.included());
        }
        out.key("included").array();
        for (JsonApiData jsonApiData : toInclude) {
            out.object();
            JsonApi.encodeInner(out, jsonApiData);
            out.endObject();
        }
        out.endArray();
        out.endObject();
    }

    public static void encodeError(JSONWriter out, String message) {
        System.err.println("JsonApi.Error: " + message);
        out.object().key("errors").array().object().key("detail").value((Object)message).endObject().endArray().endObject();
    }
}

