/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.sod.AbstractEventChannelPair;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.ChannelJson;
import org.json.JSONException;
import org.json.JSONWriter;

public class EventVectorJson
extends AbstractJsonApiData {
    AbstractEventChannelPair ecp;

    public EventVectorJson(AbstractEventChannelPair ecp, String baseUrl) {
        super(baseUrl);
        if (ecp == null) {
            throw new IllegalArgumentException("ECP can't be null");
        }
        this.ecp = ecp;
    }

    @Override
    public String getType() {
        return "quake-vector";
    }

    @Override
    public String getId() {
        return "" + this.ecp.getDbid();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("sod-status").value((Object)this.ecp.getStatus());
        super.encodeAttributes(out);
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("quake").object();
        out.key("data").object();
        out.key("id").value((Object)("" + this.ecp.getEventDbId()));
        out.key("type").value((Object)"quake");
        out.endObject();
        out.endObject();
        out.key("channels").object();
        out.key("data").array();
        if (this.ecp instanceof EventChannelPair) {
            out.object();
            ChannelJson chanJson = new ChannelJson(((EventChannelPair)this.ecp).getChannel(), this.getBaseUrl());
            out.key("id").value((Object)chanJson.getId());
            out.key("type").value((Object)chanJson.getType());
            out.key("links").object();
            out.key("self").value((Object)(this.baseUrl + "/channel/" + chanJson.getId()));
            out.endObject();
            out.endObject();
        } else {
            EventVectorPair evp = (EventVectorPair)this.ecp;
            ChannelImpl[] chans = evp.getChannelGroup().getChannels();
            for (int i = 0; i < chans.length; ++i) {
                out.object();
                ChannelJson chanJson = new ChannelJson(chans[i], this.getBaseUrl());
                out.key("id").value((Object)chanJson.getId());
                out.key("type").value((Object)chanJson.getType());
                out.key("links").object();
                out.key("self").value((Object)(this.baseUrl + "/channel/" + chanJson.getId()));
                out.endObject();
                out.endObject();
            }
        }
        out.endArray();
        out.endObject();
        out.key("waveform").object();
        out.key("data").object();
        out.key("id").value((Object)this.getId());
        out.key("type").value((Object)"waveform");
        out.key("links").object();
        out.key("self").value((Object)(this.baseUrl + "/waveforms/" + this.getId()));
        out.endObject();
        out.endObject();
        out.endObject();
    }
}

