/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.web.NetworkServlet;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.ChannelJson;
import edu.sc.seis.sod.web.jsonapi.EventStationJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.StationJson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONWriter;

public class StationsServlet
extends HttpServlet {
    Pattern stationDbidPattern = Pattern.compile(".*/stations/([0-9]+)");
    Pattern stationPattern = Pattern.compile(".*" + NetworkServlet.stationIdPatternStr);
    Pattern stationEventsPattern = Pattern.compile(".*" + NetworkServlet.stationIdPatternStr + "/quakes");
    Pattern stationChannelsPattern = Pattern.compile(".*" + NetworkServlet.stationIdPatternStr + "/channels");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("GET: " + URL2);
        if (req.getHeader("accept") != null && req.getHeader("accept").contains("application/vnd.api+json")) {
            resp.setContentType("application/vnd.api+json");
            System.out.println("      contentType: application/vnd.api+json");
        } else {
            resp.setContentType("application/json");
            System.out.println("      contentType: application/json");
        }
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Writer)writer);
        NetworkDB netdb = NetworkDB.getSingleton();
        Matcher matcher = this.stationPattern.matcher(URL2);
        if (matcher.matches()) {
            String netCode = matcher.group(1);
            String year = matcher.group(3);
            String staCode = matcher.group(4);
            List staList = netdb.getStationByCodes(netCode, staCode);
            if (staList.size() > 0) {
                StationImpl sta = (StationImpl)staList.get(0);
                JsonApi.encodeJson(out, new StationJson(sta, WebAdmin.getBaseUrl()));
                resp.setStatus(200);
                writer.close();
            } else {
                resp.setStatus(404);
                writer.println("No station with code " + netCode + "." + staCode + " found");
                writer.close();
            }
        } else {
            matcher = this.stationDbidPattern.matcher(URL2);
            if (matcher.matches()) {
                String dbid = matcher.group(1);
                StationImpl sta = null;
                try {
                    sta = netdb.getStation(Integer.parseInt(dbid));
                    List chans = netdb.getChannelsForStation(sta);
                    if (sta != null) {
                        JsonApi.encodeJson(out, new StationJson(sta, chans, WebAdmin.getBaseUrl()));
                        resp.setStatus(200);
                    } else {
                        JsonApi.encodeError(out, "Station is null for dbid " + dbid);
                    }
                }
                catch (NumberFormatException e) {
                    JsonApi.encodeError(out, "NumberFormatException " + e.getMessage());
                }
                catch (NotFound e) {
                    JsonApi.encodeError(out, "NotFound " + e.getMessage());
                }
                writer.close();
            } else {
                matcher = this.stationEventsPattern.matcher(URL2);
                if (matcher.matches()) {
                    String netCode = matcher.group(1);
                    String year = matcher.group(3);
                    String staCode = matcher.group(4);
                    StationImpl sta = (StationImpl)netdb.getStationByCodes(netCode, staCode).get(0);
                    List<EventStationPair> eventList = SodDB.getSingleton().getSuccessfulESPForStation(sta);
                    ArrayList<JsonApiData> jsonData = new ArrayList<JsonApiData>(eventList.size());
                    for (EventStationPair esp : eventList) {
                        jsonData.add(new EventStationJson(esp, WebAdmin.getBaseUrl()));
                    }
                    JsonApi.encodeJson(out, jsonData);
                    writer.close();
                    resp.setStatus(200);
                } else {
                    matcher = this.stationChannelsPattern.matcher(URL2);
                    if (matcher.matches()) {
                        String netCode = matcher.group(1);
                        String year = matcher.group(3);
                        String staCode = matcher.group(4);
                        StationImpl sta = (StationImpl)netdb.getStationByCodes(netCode, staCode).get(0);
                        List chans = netdb.getChannelsForStation(sta);
                        ArrayList<JsonApiData> jsonData = new ArrayList<JsonApiData>(chans.size());
                        for (ChannelImpl channelImpl : chans) {
                            jsonData.add(new ChannelJson(channelImpl, WebAdmin.getBaseUrl()));
                        }
                        JsonApi.encodeJson(out, jsonData);
                        writer.close();
                        resp.setStatus(200);
                    } else {
                        JsonApi.encodeError(out, "bad url for servlet: regex=" + this.stationPattern.toString());
                        writer.close();
                        resp.sendError(500);
                    }
                }
            }
        }
        NetworkDB.rollback();
    }
}

