/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.NetworkJson;
import edu.sc.seis.sod.web.jsonapi.StationJson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONWriter;

public class NetworkServlet
extends HttpServlet {
    String baseUrl;
    Pattern allNetworkPattern = Pattern.compile(".*/networks");
    public static String networkIdStr = "([A-Z0-9]+)(_([0-9]+))?";
    public static String networkIdPatternStr = "/networks/" + networkIdStr;
    public static String stationIdPatternStr = "/stations/" + networkIdStr + "\\.([A-Z0-9]+)";
    public String networkPatternStr = ".*" + networkIdPatternStr;
    Pattern networkPattern = Pattern.compile(this.networkPatternStr);
    Pattern stationListPattern = Pattern.compile(this.networkPatternStr + "/stations");
    Pattern stationRelationshipPattern = Pattern.compile(this.networkPatternStr + "/relationships/stations");
    Pattern stationPattern = Pattern.compile(this.networkPatternStr + stationIdPatternStr);
    Pattern stationPattern2 = Pattern.compile(".*/networks/([A-Z0-9]+).([A-Z0-9]+)");
    Pattern channelPattern = Pattern.compile(".*/networks/([A-Z0-9]+).([A-Z0-9]+).([A-Z0-9][A-Z0-9]).([A-Z0-9][A-Z0-9][A-Z0-9])");

    public NetworkServlet() {
        this(WebAdmin.getBaseUrl());
    }

    public NetworkServlet(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String URL2 = req.getRequestURL().toString();
            System.out.println("GET: " + URL2);
            if (req.getHeader("accept") != null && req.getHeader("accept").contains("application/vnd.api+json")) {
                resp.setContentType("application/vnd.api+json");
                System.out.println("      contentType: application/vnd.api+json");
            } else {
                resp.setContentType("application/json");
                System.out.println("      contentType: application/json");
            }
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Writer)writer);
            NetworkDB netdb = NetworkDB.getSingleton();
            Matcher matcher = this.allNetworkPattern.matcher(URL2);
            if (matcher.matches()) {
                List netList = netdb.getAllNetworks();
                ArrayList<JsonApiData> jsonList = new ArrayList<JsonApiData>();
                for (NetworkAttrImpl net : netList) {
                    jsonList.add(new NetworkJson((NetworkAttr)net, this.baseUrl));
                }
                JsonApi.encodeJson(out, jsonList);
            } else {
                matcher = this.networkPattern.matcher(URL2);
                if (matcher.matches()) {
                    String netCode = matcher.group(1);
                    String year = matcher.group(3);
                    NetworkAttrImpl n = NetworkServlet.loadNet(netCode, year);
                    JsonApi.encodeJson(out, new NetworkJson((NetworkAttr)n, this.baseUrl));
                } else {
                    matcher = this.stationListPattern.matcher(URL2);
                    if (matcher.matches()) {
                        String netCode = matcher.group(1);
                        List staList = netdb.getStationForNet((NetworkAttrImpl)netdb.getNetworkByCode(netCode).get(0));
                        JsonApi.encodeJson(out, StationJson.toJsonList(staList, this.baseUrl));
                    } else {
                        matcher = this.stationRelationshipPattern.matcher(URL2);
                        if (matcher.matches()) {
                            String netCode = matcher.group(1);
                            List staList = netdb.getStationForNet((NetworkAttrImpl)netdb.getNetworkByCode(netCode).get(0));
                            JsonApi.encodeJson(out, StationJson.toJsonList(staList, this.baseUrl));
                        } else {
                            matcher = this.stationPattern.matcher(URL2);
                            if (matcher.matches()) {
                                String netCode = matcher.group(1);
                                String year = matcher.group(3);
                                String staCode = matcher.group(7);
                                StationImpl sta = (StationImpl)netdb.getStationByCodes(netCode, staCode).get(0);
                                JsonApi.encodeJson(out, new StationJson(sta, this.baseUrl));
                            }
                        }
                    }
                }
            }
            writer.close();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            NetworkDB.rollback();
        }
    }

    public static NetworkAttrImpl loadNet(String netCode, String year) {
        List netList = NetworkDB.getSingleton().getNetworkByCode(netCode);
        NetworkAttrImpl n = null;
        if (NetworkIdUtil.isTemporary((String)netCode) || year == null) {
            n = (NetworkAttrImpl)netList.get(0);
        } else {
            for (NetworkAttrImpl netImpl : netList) {
                if (!NetworkIdUtil.getYear((NetworkId)netImpl.get_id()).equals(year)) continue;
                n = netImpl;
                break;
            }
        }
        return n;
    }
}

