/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.EventJson;
import edu.sc.seis.sod.web.jsonapi.EventStationJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONWriter;

public class EventServlet
extends HttpServlet {
    Pattern allEvents = Pattern.compile(".*/quakes");
    Pattern singleEvent = Pattern.compile(".*/quakes/([0-9]+)");
    Pattern eventStations = Pattern.compile(".*/quakes/([0-9]+)/stations");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("GET: " + URL2);
        Matcher matcher = this.singleEvent.matcher(URL2);
        if (req.getHeader("accept") != null && req.getHeader("accept").contains("application/vnd.api+json")) {
            resp.setContentType("application/vnd.api+json");
            System.out.println("      contentType: application/vnd.api+json");
        } else {
            resp.setContentType("application/json");
            System.out.println("      contentType: application/json");
        }
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Writer)writer);
        if (matcher.matches()) {
            String dbid = matcher.group(1);
            try {
                StatefulEvent e = StatefulEventDB.getSingleton().getEvent(Integer.parseInt(dbid));
                JsonApi.encodeJson(out, new EventJson(e, WebAdmin.getBaseUrl()));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
            catch (NotFound e) {
                throw new RuntimeException(e);
            }
        } else {
            matcher = this.eventStations.matcher(URL2);
            if (matcher.matches()) {
                int dbid = Integer.parseInt(matcher.group(1));
                try {
                    StatefulEvent event = StatefulEventDB.getSingleton().getEvent(dbid);
                    List<EventStationPair> espList = SodDB.getSingleton().getSuccessfulESPForEvent(event);
                    ArrayList<JsonApiData> jsonData = new ArrayList<JsonApiData>(espList.size());
                    for (EventStationPair esp : espList) {
                        jsonData.add(new EventStationJson(esp, WebAdmin.getBaseUrl()));
                    }
                    JsonApi.encodeJson(out, jsonData);
                }
                catch (NotFound e) {
                    throw new RuntimeException(e);
                }
            } else {
                matcher = this.allEvents.matcher(URL2);
                if (matcher.matches()) {
                    try {
                        List<StatefulEvent> events = StatefulEventDB.getSingleton().getAll();
                        ArrayList<JsonApiData> eventJsonList = new ArrayList<JsonApiData>();
                        for (StatefulEvent statefulEvent : events) {
                            eventJsonList.add(new EventJson(statefulEvent, WebAdmin.getBaseUrl()));
                        }
                        JsonApi.encodeJson(out, eventJsonList);
                    }
                    catch (JSONException e) {
                        throw new ServletException((Throwable)e);
                    }
                } else {
                    JsonApi.encodeError(out, "bad url for servlet: regex=" + this.allEvents + " or " + this.singleEvent + " or " + this.eventStations);
                    writer.close();
                    resp.sendError(500);
                }
            }
        }
        writer.close();
    }
}

