/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.seismogram;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import edu.sc.seis.sod.velocity.network.VelocitySampling;
import edu.sc.seis.sod.velocity.seismogram.VelocityProperty;
import java.util.ArrayList;
import java.util.List;

public class VelocitySeismogram
extends LocalSeismogramImpl {
    private VelocityChannel chan;

    public VelocitySeismogram(LocalSeismogramImpl localSeis, Channel chan) {
        super((SeismogramAttr)localSeis, localSeis.getData());
        this.chan = VelocityChannel.wrap(chan);
        if (!ChannelIdUtil.areEqualExceptForBeginTime((ChannelId)localSeis.getChannelID(), (ChannelId)chan.getId())) {
            throw new IllegalArgumentException("Channel ids do not match: " + ChannelIdUtil.toString((ChannelId)localSeis.getChannelID()) + "  " + ChannelIdUtil.toString((ChannelId)chan.getId()));
        }
    }

    public MicroSecondDate getBegin() {
        return this.getBeginTime();
    }

    public String getBegin(String dateFormat) {
        return SimpleVelocitizer.format(this.getBegin(), dateFormat);
    }

    public MicroSecondDate getEnd() {
        return this.getEndTime();
    }

    public String getEnd(String dateFormat) {
        return SimpleVelocitizer.format(this.getEnd(), dateFormat);
    }

    public VelocityChannel getChannel() {
        return this.chan;
    }

    public SamplingImpl getSampling() {
        return new VelocitySampling((Sampling)super.getSampling());
    }

    public VelocityProperty[] getProps() {
        VelocityProperty[] vProps = new VelocityProperty[this.properties.length];
        for (int i = 0; i < vProps.length; ++i) {
            vProps[i] = new VelocityProperty(this.properties[i]);
        }
        return vProps;
    }

    public String getAllProps() {
        String out = "Props: ";
        for (int i = 0; i < this.properties.length; ++i) {
            out = out + "( " + this.properties[i].name + ", " + this.properties[i].value + " )";
        }
        return out;
    }

    public String toString() {
        return "Seismogram on " + (Object)((Object)this.getChannel()) + " from " + this.getBegin() + " to " + this.getEnd();
    }

    public static List<VelocitySeismogram> wrap(LocalSeismogramImpl[] seis, Channel chan) {
        ArrayList<VelocitySeismogram> results = new ArrayList<VelocitySeismogram>(seis.length);
        chan = VelocityChannel.wrap(chan);
        for (int i = 0; i < seis.length; ++i) {
            results.add(VelocitySeismogram.wrap(seis[i], chan));
        }
        return results;
    }

    public static List<List<VelocitySeismogram>> wrap(LocalSeismogramImpl[][] seis, ChannelGroup channelGroup) {
        ArrayList<List<VelocitySeismogram>> results = new ArrayList<List<VelocitySeismogram>>(seis.length);
        block0: for (int i = 0; i < channelGroup.getChannels().length; ++i) {
            for (int j = 0; j < seis.length; ++j) {
                if (!ChannelIdUtil.areEqual((ChannelId)channelGroup.getChannels()[i].getId(), (ChannelId)seis[j][0].channel_id)) continue;
                results.add(VelocitySeismogram.wrap(seis[j], (Channel)channelGroup.getChannels()[i]));
                continue block0;
            }
        }
        return results;
    }

    public static VelocitySeismogram wrap(LocalSeismogramImpl seis, Channel chan) {
        if (seis instanceof VelocitySeismogram) {
            return (VelocitySeismogram)seis;
        }
        return new VelocitySeismogram(seis, chan);
    }
}

