/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.model;

import edu.sc.seis.sod.validator.ModelWalker;
import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.Empty;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.MultigenitorForm;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.NotAllowed;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;

public class ModelUtil {
    public static String toString(Form f) {
        return ModelUtil.toString(f, true);
    }

    public static String toString(Form[] f) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < f.length; ++i) {
            buf.append(ModelUtil.toString(f[i], false) + ' ');
        }
        return buf.toString();
    }

    public static String toString(Form f, boolean continueFollowing) {
        if (f instanceof Attribute) {
            Attribute a = (Attribute)f;
            return "Attribute: " + a.getName();
        }
        if (f instanceof MultigenitorForm) {
            StringBuffer buf = new StringBuffer();
            if (f instanceof Choice) {
                buf.append("Choice");
            } else if (f instanceof Interleave) {
                buf.append("Interleave");
            } else if (f instanceof Group) {
                buf.append("Group");
            } else {
                buf.append("Unknown MultigenitorForm");
            }
            MultigenitorForm c = (MultigenitorForm)f;
            Form[] kids = c.getChildren();
            if (continueFollowing) {
                buf.append(": [");
                buf.append(ModelUtil.toString(kids));
                buf.append("]");
            }
            return buf.toString();
        }
        if (f instanceof NamedElement) {
            NamedElement n = (NamedElement)f;
            return "NamedElement: " + n.getName();
        }
        if (f instanceof Value) {
            return "Value";
        }
        if (f instanceof Data) {
            return "Data";
        }
        if (f instanceof NotAllowed) {
            return "NotAllowed";
        }
        if (f instanceof Text) {
            return "Text";
        }
        if (f instanceof Empty) {
            return "Empty";
        }
        return f.toString();
    }

    public static String getLineageString(Form f) {
        StringBuffer buf = new StringBuffer();
        Form[] lineage = ModelWalker.getLineage(f);
        for (int i = 0; i < lineage.length; ++i) {
            if (i > 0) {
                buf.append("is child of ");
            }
            buf.append(ModelUtil.toString(lineage[i]) + '\n');
        }
        return buf.toString();
    }
}

