/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.model;

import edu.sc.seis.sod.validator.model.Definition;
import edu.sc.seis.sod.validator.model.Form;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Grammar {
    private String filename;
    private Map<String, Definition> defs = new HashMap<String, Definition>();

    public Grammar(String filename) {
        this.filename = filename.replace('\\', '/');
    }

    public List<Definition> getDefs() {
        ArrayList<Definition> defList = new ArrayList<Definition>();
        defList.addAll(this.defs.values());
        return defList;
    }

    public void include(Grammar grammar) {
        Iterator<Definition> it = grammar.defs.values().iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public String getLoc() {
        return this.filename;
    }

    public Form getRoot() {
        return this.getDef("").getForm();
    }

    public void add(Definition d) {
        this.defs.put(d.getName(), d);
    }

    public void add(String name, Definition d) {
        this.defs.put(name, d);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Grammar) {
            return ((Grammar)o).filename.equals(this.filename);
        }
        return false;
    }

    public int hashCode() {
        return this.filename.hashCode();
    }

    public Definition getDef(String name) {
        return this.defs.get(name);
    }

    public String toString() {
        return "Grammar " + this.filename;
    }
}

