/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.requestGenerator;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelLogicalSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelLogicalSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.origin.EventLogicalSubsetter;
import edu.sc.seis.sod.subsetter.requestGenerator.RequestGenerator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChoiceRequest
implements RequestGenerator {
    protected List choices = new LinkedList();
    protected RequestGenerator otherwise = null;
    private static Logger logger = LoggerFactory.getLogger(ChoiceRequest.class);
    public static final List<String> packages = new LinkedList<String>();

    public ChoiceRequest(Element config) throws ConfigurationException {
        NodeList choiceNodes = DOMHelper.extractNodes((Element)config, (String)"choice");
        for (int i = 0; i < choiceNodes.getLength(); ++i) {
            this.choices.add(new Choice((Element)choiceNodes.item(i)));
        }
        if (DOMHelper.hasElement((Element)config, (String)"otherwise")) {
            Element otherwiseEl = DOMHelper.extractElement((Element)config, (String)"otherwise/*");
            this.otherwise = (RequestGenerator)SodUtil.load(otherwiseEl, "requestGenerator");
        }
    }

    @Override
    public RequestFilter[] generateRequest(CacheEvent event, ChannelImpl channel, CookieJar cookieJar) throws Exception {
        for (int i = 0; i < this.choices.size(); ++i) {
            Choice c = (Choice)this.choices.get(i);
            if (!c.accept(event, channel, cookieJar).isSuccess()) continue;
            return c.generateRequest(event, channel, cookieJar);
        }
        if (this.otherwise != null) {
            return this.otherwise.generateRequest(event, channel, cookieJar);
        }
        logger.debug("No choice matched, generating no request");
        return new RequestFilter[0];
    }

    static {
        packages.add("requestGenerator");
        packages.add("eventChannel");
        packages.add("eventStation");
        packages.addAll(ChannelLogicalSubsetter.packages);
        packages.addAll(EventLogicalSubsetter.packages);
    }

    class Choice
    implements RequestGenerator,
    EventChannelSubsetter {
        RequestGenerator requestGenerator;
        EventChannelSubsetter eventChannelSubsetter;

        Choice(Element config) throws ConfigurationException {
            NodeList childNodes = config.getChildNodes();
            for (int counter = 0; counter < childNodes.getLength(); ++counter) {
                Node node = childNodes.item(counter);
                if (!(node instanceof Element)) continue;
                SodElement sodElement = (SodElement)SodUtil.load((Element)node, packages.toArray(new String[0]));
                if (sodElement instanceof RequestGenerator) {
                    this.requestGenerator = (RequestGenerator)sodElement;
                    continue;
                }
                if (!(sodElement instanceof Subsetter)) continue;
                this.eventChannelSubsetter = EventChannelLogicalSubsetter.createSubsetter((Subsetter)sodElement);
            }
        }

        @Override
        public RequestFilter[] generateRequest(CacheEvent event, ChannelImpl channel, CookieJar cookieJar) throws Exception {
            return this.requestGenerator.generateRequest(event, channel, cookieJar);
        }

        @Override
        public StringTree accept(CacheEvent event, ChannelImpl channel, CookieJar cookieJar) throws Exception {
            return this.eventChannelSubsetter.accept(event, channel, cookieJar);
        }
    }
}

