/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.DistanceRangeSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.origin.MagnitudeRange;
import org.w3c.dom.Element;

public class LinearDistanceMagnitudeRange
extends DistanceRangeSubsetter
implements EventStationSubsetter {
    private MagnitudeRange magnitudeRange;

    public LinearDistanceMagnitudeRange(Element config) throws ConfigurationException {
        super(config);
        Element subElement = SodUtil.getElement(config, "magnitudeRange");
        this.magnitudeRange = (MagnitudeRange)SodUtil.load(subElement, "origin");
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, StationImpl station, CookieJar cookieJar) {
        Location stationLoc = station.getLocation();
        return new StringTreeLeaf(this, this.accept((EventAccessOperations)eventAccess, stationLoc.latitude, stationLoc.longitude));
    }

    public boolean accept(EventAccessOperations eventAccess, double stationLat, double stationLon) {
        OriginImpl origin = EventUtil.extractOrigin((EventAccessOperations)eventAccess);
        Location originLoc = origin.getLocation();
        double actualDistance = SphericalCoords.distance((double)originLoc.latitude, (double)originLoc.longitude, (double)stationLat, (double)stationLon);
        if (actualDistance >= this.getMin().value && actualDistance <= this.getMax().value) {
            double resultantMagnitude = this.magnitudeRange.getMinValue() + (actualDistance - this.getMin().value) * (this.magnitudeRange.getMaxValue() - this.magnitudeRange.getMinValue()) / (this.getMin().value - this.getMax().value);
            for (int i = 0; i < origin.getMagnitudes().length; ++i) {
                if (!((double)origin.getMagnitudes()[i].value >= resultantMagnitude)) continue;
                if (this.magnitudeRange.getSearchTypes().length == 0) {
                    return true;
                }
                for (int j = 0; j < this.magnitudeRange.getSearchTypes().length; ++j) {
                    if (!origin.getMagnitudes()[i].type.equals(this.magnitudeRange.getSearchTypes())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

