/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.availableData;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.RequestFilterUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.time.CoverageTool;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.availableData.PercentCoverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullCoverage
implements AvailableDataSubsetter,
SodElement {
    private PercentCoverage pc = new PercentCoverage(100.0);
    private static Logger logger = LoggerFactory.getLogger((String)FullCoverage.class.getName());

    @Override
    public StringTree accept(CacheEvent event, ChannelImpl channel, RequestFilter[] request, RequestFilter[] available, CookieJar cookieJar) {
        double coveragePercentage = this.pc.percentCovered(request, available);
        if (available.length == 0) {
            return new StringTreeLeaf(this, false, "No available data");
        }
        RequestFilter[] notCovered = CoverageTool.notCovered((RequestFilter[])request, (RequestFilter[])available);
        float minSps = ChannelIdUtil.minSPSForBandCode((String)channel.get_code());
        if (minSps > 0.0f) {
            notCovered = RequestFilterUtil.removeSmallRequests((RequestFilter[])notCovered, (TimeInterval)new TimeInterval((double)(1.0f / minSps), UnitImpl.SECOND));
        }
        if (notCovered.length == 0) {
            String reason = "Data returned completly covers the request";
            return new StringTreeLeaf(this, true, reason);
        }
        String reason = "Data does not cover " + notCovered.length + " sections of the request. ";
        for (int i = 0; i < notCovered.length; ++i) {
            reason = reason + notCovered[i].start_time.date_time + " to " + notCovered[i].end_time.date_time + ",  ";
        }
        return new StringTreeLeaf(this, coveragePercentage >= 100.0, reason + " " + coveragePercentage + " percent of data covered");
    }
}

