/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.networkArm;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.ChannelGroupTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.SiteGroupTemplate;
import edu.sc.seis.sod.status.StationFormatter;
import edu.sc.seis.sod.status.networkArm.NetworkInfoTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ChannelsInStationTemplate
extends NetworkInfoTemplate {
    private Station station;
    private List channelListeners = new ArrayList();
    private List siteListeners = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(ChannelsInStationTemplate.class);

    public ChannelsInStationTemplate(Element el, String baseDir, String outputLocation, Station sta) throws ConfigurationException, IOException {
        super(baseDir, outputLocation);
        this.station = sta;
        this.parse(el);
        this.write();
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("channels")) {
            ChannelGroupTemplate cgt = new ChannelGroupTemplate(el);
            this.channelListeners.add(cgt);
            return cgt;
        }
        if (tag.equals("sites")) {
            SiteGroupTemplate sgt = new SiteGroupTemplate(el);
            this.siteListeners.add(sgt);
            return sgt;
        }
        if (tag.equals("station")) {
            return new MyStationTemplate(el);
        }
        return super.getTemplate(tag, el);
    }

    public void change(Channel channel, Status status) {
        this.logger.debug("change(channel, status): " + channel.getSite().getStation().getNetworkAttr().get_code() + "." + channel.getSite().getStation().get_code() + "." + channel.getSite().get_code() + "." + channel.get_code() + ", " + status.toString());
        Iterator it = this.channelListeners.iterator();
        while (it.hasNext()) {
            ((ChannelGroupTemplate)it.next()).change(channel, status);
        }
        this.write();
    }

    public void change(Site site, Status status) {
        this.logger.debug("change(site , status): " + site.getStation().getNetworkAttr().get_code() + "." + site.getStation().get_code() + "." + site.get_code() + ", " + status.toString());
        Iterator it = this.siteListeners.iterator();
        while (it.hasNext()) {
            ((SiteGroupTemplate)it.next()).change(site, status);
        }
        this.write();
    }

    private class MyStationTemplate
    implements GenericTemplate {
        StationFormatter formatter;

        public MyStationTemplate(Element el) throws ConfigurationException {
            this.formatter = new StationFormatter(el);
        }

        @Override
        public String getResult() {
            return this.formatter.getResult(ChannelsInStationTemplate.this.station);
        }
    }
}

