/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.status.StationGroupTemplate;
import edu.sc.seis.sod.status.StationTemplate;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TimeTemplate;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class StationFormatter
extends Template
implements StationTemplate {
    StationGroupTemplate sgt;

    public StationFormatter() {
        this.templates = new ArrayList();
        this.templates.add(this.getTemplate("networkCode", null));
        this.templates.add(this.textTemplate("."));
        this.templates.add(this.getTemplate("stationCode", null));
        this.templates.add(this.textTemplate("."));
        this.templates.add(this.getTemplate("beginTime", null));
    }

    public static StationFormatter makeNetAndCode() {
        StationFormatter formatter = new StationFormatter();
        formatter.templates.clear();
        formatter.templates.add(formatter.getTemplate("networkCode", null));
        formatter.templates.add(formatter.textTemplate("."));
        formatter.templates.add(formatter.getTemplate("stationCode", null));
        return formatter;
    }

    public StationFormatter(Element el) throws ConfigurationException {
        this(el, null);
    }

    public StationFormatter(Element el, StationGroupTemplate sgt) throws ConfigurationException {
        this.sgt = sgt;
        this.parse(el);
    }

    @Override
    public String getResult(Station station) {
        StringBuffer buf = new StringBuffer();
        for (StationTemplate cur : this.templates) {
            buf.append(cur.getResult(station));
        }
        return buf.toString();
    }

    @Override
    protected Object textTemplate(final String text) {
        return new StationTemplate(){

            @Override
            public String getResult(Station station) {
                return text;
            }
        };
    }

    @Override
    protected Object getTemplate(String tag, final Element el) {
        if (tag.equals("name")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return sta.getName();
                }
            };
        }
        if (tag.equals("networkCode")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return sta.getNetworkAttr().get_code();
                }
            };
        }
        if (tag.equals("stationCode")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return sta.get_code();
                }
            };
        }
        if (tag.equals("lon")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return FissuresFormatter.getLongitudeString(sta.getLocation());
                }
            };
        }
        if (tag.equals("lat")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return FissuresFormatter.getLatitudeString(sta.getLocation());
                }
            };
        }
        if (tag.equals("depth")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return Double.toString(sta.getLocation().depth.value);
                }
            };
        }
        if (tag.equals("elevation")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return Double.toString(sta.getLocation().elevation.value);
                }
            };
        }
        if (tag.equals("comment")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return sta.getComment();
                }
            };
        }
        if (tag.equals("description")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return sta.getDescription();
                }
            };
        }
        if (tag.equals("operator")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return sta.getOperator();
                }
            };
        }
        if (tag.equals("beginTime")) {
            return new StationTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(Station sta) {
                    return this.btt.getResult(sta.get_id().begin_time);
                }
            };
        }
        if (tag.equals("endTime")) {
            return new StationTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(Station sta) {
                    return this.btt.getResult(sta.getEndTime());
                }
            };
        }
        if (tag.equals("beginTimeUnformatted")) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return sta.get_id().begin_time.date_time;
                }
            };
        }
        if (tag.equals("status") && this.sgt != null) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    return StationFormatter.this.sgt.stationMap.get(sta).toString();
                }
            };
        }
        if (tag.equals("standing") && this.sgt != null) {
            return new StationTemplate(){

                @Override
                public String getResult(Station sta) {
                    Status status = (Status)StationFormatter.this.sgt.stationMap.get(sta);
                    return status.getStanding().toString();
                }
            };
        }
        return this.getCommonTemplate(tag, el);
    }
}

