/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.IfNetwork.Site;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.SiteGroupTemplate;
import edu.sc.seis.sod.status.SiteTemplate;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TimeTemplate;
import org.w3c.dom.Element;

public class SiteFormatter
extends Template
implements SiteTemplate {
    SiteGroupTemplate sgt;

    public SiteFormatter(Element el) throws ConfigurationException {
        this(el, null);
    }

    public SiteFormatter(Element el, SiteGroupTemplate sgt) throws ConfigurationException {
        this.sgt = sgt;
        this.parse(el);
    }

    @Override
    public String getResult(Site site) {
        StringBuffer buf = new StringBuffer();
        for (SiteTemplate cur : this.templates) {
            buf.append(cur.getResult(site));
        }
        return buf.toString();
    }

    @Override
    protected Object textTemplate(final String text) {
        return new SiteTemplate(){

            @Override
            public String getResult(Site site) {
                return text;
            }
        };
    }

    @Override
    protected Object getTemplate(String tag, final Element el) {
        if (tag.equals("siteCode")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return site.get_id().site_code;
                }
            };
        }
        if (tag.equals("stationCode")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return site.get_id().station_code;
                }
            };
        }
        if (tag.equals("networkCode")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return site.get_id().network_id.network_code;
                }
            };
        }
        if (tag.equals("beginTime")) {
            return new SiteTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(Site site) {
                    return this.btt.getResult(site.get_id().begin_time);
                }
            };
        }
        if (tag.equals("endTime")) {
            return new SiteTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(Site site) {
                    return this.btt.getResult(site.getEndTime());
                }
            };
        }
        if (tag.equals("status") && this.sgt != null) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return SiteFormatter.this.sgt.siteMap.get(site).toString();
                }
            };
        }
        if (tag.equals("standing") && this.sgt != null) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    Status status = (Status)SiteFormatter.this.sgt.siteMap.get(site);
                    return status.getStanding().toString();
                }
            };
        }
        if (tag.equals("comment")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return site.getComment();
                }
            };
        }
        if (tag.equals("depth")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return Double.toString(site.getLocation().depth.value);
                }
            };
        }
        if (tag.equals("elevation")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return Double.toString(site.getLocation().elevation.value);
                }
            };
        }
        if (tag.equals("lat")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return Float.toString(site.getLocation().latitude);
                }
            };
        }
        if (tag.equals("lon")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return Float.toString(site.getLocation().longitude);
                }
            };
        }
        if (tag.equals("beginTimeUnformatted")) {
            return new SiteTemplate(){

                @Override
                public String getResult(Site site) {
                    return site.get_id().begin_time.date_time;
                }
            };
        }
        return this.getCommonTemplate(tag, el);
    }

    public static String formatSiteCode(String siteCode) {
        if (siteCode == null || siteCode.equals("")) {
            return "  ";
        }
        return siteCode;
    }
}

