/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.status.MicroSecondTimeRangeTemplate;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TimeTemplate;
import java.util.Iterator;
import org.w3c.dom.Element;

public class MicroSecondTimeRangeFormatter
extends Template
implements MicroSecondTimeRangeTemplate {
    boolean filizeResults = false;

    public MicroSecondTimeRangeFormatter(Element el) throws ConfigurationException {
        this(el, false);
    }

    public MicroSecondTimeRangeFormatter(Element el, boolean fileize) throws ConfigurationException {
        this.filizeResults = fileize;
        this.parse(el, this.filizeResults);
    }

    @Override
    protected Object textTemplate(final String text) {
        return new MicroSecondTimeRangeTemplate(){

            @Override
            public String getResult(MicroSecondTimeRange timeRange) {
                return text;
            }
        };
    }

    @Override
    protected Object getTemplate(String tag, final Element el) {
        if (tag.equals("beginTime")) {
            return new MicroSecondTimeRangeTemplate(){
                TimeTemplate tt;
                {
                    this.tt = new TimeTemplate(el, true);
                }

                @Override
                public String getResult(MicroSecondTimeRange timeRange) {
                    return this.tt.getResult(timeRange.getBeginTime().getFissuresTime());
                }
            };
        }
        if (tag.equals("endTime")) {
            return new MicroSecondTimeRangeTemplate(){
                TimeTemplate tt;
                {
                    this.tt = new TimeTemplate(el, true);
                }

                @Override
                public String getResult(MicroSecondTimeRange timeRange) {
                    return this.tt.getResult(timeRange.getEndTime().getFissuresTime());
                }
            };
        }
        return super.getCommonTemplate(tag, el);
    }

    @Override
    public String getResult(MicroSecondTimeRange timeRange) {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.templates.iterator();
        while (it.hasNext()) {
            buf.append(((MicroSecondTimeRangeTemplate)it.next()).getResult(timeRange));
        }
        if (this.filizeResults) {
            return FissuresFormatter.filize(buf.toString());
        }
        return buf.toString();
    }
}

