/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.MenuTemplate;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.eventArm.LastEventTemplate;
import edu.sc.seis.sod.status.waveformArm.NumSuccessfulECPTemplate;
import edu.sc.seis.sod.status.waveformArm.SacDataWrittenTemplate;
import edu.sc.seis.sod.status.waveformArm.WPHTemplate;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FileWritingTemplate
extends Template
implements GenericTemplate,
Runnable {
    private String baseDir;
    private String outputLocation;
    private static Logger logger = LoggerFactory.getLogger(FileWritingTemplate.class);

    protected FileWritingTemplate(String baseDir, String loc) throws IOException {
        this.baseDir = baseDir;
        this.outputLocation = loc;
        FileWritingTemplate.testOutputLoc(baseDir + '/' + loc);
    }

    public static String testOutputLoc(String loc) throws IOException {
        File outFile = new File(loc);
        outFile.getCanonicalFile().getParentFile().mkdirs();
        return loc;
    }

    public void write() {
        OutputScheduler.getDefault().schedule(this);
    }

    @Override
    public String getResult() {
        StringBuffer buf = new StringBuffer();
        for (Object cur : this.templates) {
            buf.append(((GenericTemplate)cur).getResult());
        }
        return buf.toString();
    }

    @Override
    protected Object textTemplate(final String text) {
        return new GenericTemplate(){

            @Override
            public String getResult() {
                return text;
            }
        };
    }

    public String getOutputLocation() {
        return this.baseDir + '/' + this.outputLocation;
    }

    public String getFilename() {
        return new File(this.getOutputLocation()).getName();
    }

    protected File getOutputDirectory() {
        return new File(this.getOutputLocation()).getParentFile();
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("menu")) {
            try {
                Element templateEl = TemplateFileLoader.getTemplate(el);
                return new MenuTemplate(templateEl, this.getOutputLocation(), this.baseDir);
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Problem getting template for Menu", (Throwable)e);
            }
        } else {
            if (tag.equals("sacDataWritten")) {
                return new SacDataWrittenTemplate();
            }
            if (tag.equals("lastEvent")) {
                return new LastEventTemplate(el);
            }
            if (tag.equals("numSuccessfulECP")) {
                try {
                    return new NumSuccessfulECPTemplate();
                }
                catch (SQLException e) {
                    GlobalExceptionHandler.handle((Throwable)e);
                }
            } else if (tag.equals("waveformsPerHour")) {
                try {
                    return new WPHTemplate();
                }
                catch (SQLException e) {
                    GlobalExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return super.getTemplate(tag, el);
    }

    @Override
    public void run() {
        FileWritingTemplate.write(this.getOutputLocation(), this.getResult());
    }

    public String toString() {
        return "FileWriter for " + this.getOutputLocation();
    }

    public static void write(String outputLocation, String output) {
        File loc = new File(outputLocation);
        try {
            loc.getParentFile().mkdirs();
            File temp = File.createTempFile(loc.getName(), null, loc.getParentFile());
            BufferedWriter writer = new BufferedWriter(new FileWriter(temp));
            writer.write(output);
            writer.close();
            loc.delete();
            temp.renameTo(loc);
        }
        catch (IOException e) {
            GlobalExceptionHandler.handle((Throwable)e);
        }
    }

    public static String getBaseDirectoryName() {
        return Start.getRunProps().getStatusBaseDir();
    }
}

