/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.BoxArea;
import edu.iris.Fissures.FlinnEngdahlRegion;
import edu.iris.Fissures.FlinnEngdahlType;
import edu.iris.Fissures.GlobalArea;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.PointDistanceArea;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.FlinnEngdahlRegionImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNEventCatalogQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventDescription;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventIterator;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import edu.sc.seis.sod.BuildVersion;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.source.event.AbstractEventSource;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.subsetter.origin.Catalog;
import edu.sc.seis.sod.subsetter.origin.Contributor;
import edu.sc.seis.sod.subsetter.origin.MagnitudeRange;
import edu.sc.seis.sod.subsetter.origin.OriginDepthRange;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FdsnEvent
extends AbstractEventSource
implements EventSource {
    FDSNEventQueryParams queryParams = new FDSNEventQueryParams();
    MicroSecondTimeRangeSupplier eventTimeRangeSupplier;
    private MicroSecondDate lastQueryEnd;
    private MicroSecondDate nextLastQueryEnd;
    String url;
    int port = -1;
    URI parsedURL;
    int increaseThreashold = 10;
    int decreaseThreashold = 100;
    private static final Logger logger = LoggerFactory.getLogger(FdsnEvent.class);
    public static final String URL_ELEMENT = "url";
    public static final String HOST_ELEMENT = "host";
    public static final String PORT_ELEMENT = "port";
    String userAgent = "SOD/" + BuildVersion.getVersion();

    public FdsnEvent(final FDSNEventQueryParams queryParams) {
        super("DefaultFDSNEvent", 2);
        this.eventTimeRangeSupplier = new MicroSecondTimeRangeSupplier(){

            @Override
            public MicroSecondTimeRange getMSTR() {
                SimpleDateFormat sdf = AbstractQueryParams.createDateFormat();
                try {
                    return new MicroSecondTimeRange(new MicroSecondDate(sdf.parse(queryParams.getParam("starttime"))), new MicroSecondDate(sdf.parse(queryParams.getParam("endtime"))));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Should not happen", e);
                }
            }
        };
        this.queryParams = queryParams;
    }

    public FdsnEvent(Element config) throws ConfigurationException {
        super(config, "DefaultFDSNEvent");
        String fdsnwsPath;
        String host;
        this.queryParams.setIncludeAllMagnitudes(true).setOrderBy("time-asc");
        int port = SodUtil.loadInt(config, PORT_ELEMENT, -1);
        if (port > 0) {
            this.queryParams.setPort(port);
        }
        if ((host = SodUtil.loadText(config, HOST_ELEMENT, null)) != null && host.length() != 0) {
            this.queryParams.setHost(host);
        }
        if ((fdsnwsPath = SodUtil.loadText(config, "fdsnwsPath", null)) != null && fdsnwsPath.length() != 0) {
            this.queryParams.setFdsnwsPath(fdsnwsPath);
        }
        boolean foundCatalog = false;
        boolean foundContributor = false;
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            String tagName;
            Node node = childNodes.item(counter);
            if (!(node instanceof Element) || (tagName = ((Element)node).getTagName()).equals("retries") || tagName.equals("fdsnPath") || tagName.equals("refreshInterval") || tagName.equals("eventQueryIncrement") || tagName.equals("eventLag") || tagName.equals(HOST_ELEMENT) || tagName.equals(PORT_ELEMENT) || tagName.equals("name")) continue;
            Object object = SodUtil.load((Element)node, new String[]{"eventArm", "origin"});
            if (tagName.equals("originTimeRange")) {
                this.eventTimeRangeSupplier = (MicroSecondTimeRangeSupplier)SodUtil.load((Element)node, new String[]{"eventArm", "origin"});
                continue;
            }
            if (tagName.equals("originDepthRange")) {
                OriginDepthRange dr = (OriginDepthRange)object;
                if (dr.getMinDepth().getValue(UnitImpl.KILOMETER) > -99999.0) {
                    this.queryParams.setMinDepth((float)dr.getMinDepth().getValue(UnitImpl.KILOMETER));
                }
                if (!(dr.getMaxDepth().getValue(UnitImpl.KILOMETER) < 99999.0)) continue;
                this.queryParams.setMaxDepth((float)dr.getMaxDepth().getValue(UnitImpl.KILOMETER));
                continue;
            }
            if (tagName.equals("magnitudeRange")) {
                MagnitudeRange magRange = (MagnitudeRange)object;
                String[] magTypes = magRange.getSearchTypes();
                String magStr = "";
                for (int i = 0; i < magTypes.length; ++i) {
                    magStr = magStr + magTypes[i];
                    if (i >= magTypes.length - 1) continue;
                    magStr = magStr + ",";
                }
                if (magStr.length() != 0) {
                    this.queryParams.setMagnitudeType(magStr);
                    EventArm eArm = Start.getEventArm();
                    if (eArm != null) {
                        eArm.getSubsetters().add(0, magRange);
                    }
                } else if (this.queryParams.getHost().equals("service.iris.edu")) {
                    this.queryParams.setMagnitudeType("preferred");
                }
                if (magRange.getMinValue() > -99.0) {
                    this.queryParams.setMinMagnitude((float)magRange.getMinValue());
                }
                if (!(magRange.getMaxValue() < 99.0)) continue;
                this.queryParams.setMaxMagnitude((float)magRange.getMaxValue());
                continue;
            }
            if (object instanceof Area) {
                Area area = (Area)object;
                if (area instanceof GlobalArea) continue;
                if (area instanceof BoxArea) {
                    BoxArea box = (BoxArea)area;
                    this.queryParams.area(box.min_latitude, box.max_latitude, box.min_longitude, box.max_longitude);
                    continue;
                }
                if (area instanceof PointDistanceArea) {
                    PointDistanceArea donut = (PointDistanceArea)area;
                    this.queryParams.donut(donut.latitude, donut.longitude, (float)((QuantityImpl)donut.min_distance).getValue(UnitImpl.DEGREE), (float)((QuantityImpl)donut.max_distance).getValue(UnitImpl.DEGREE));
                    continue;
                }
                throw new ConfigurationException("Area of class " + area.getClass().getName() + " not understood");
            }
            if (tagName.equals("catalog")) {
                foundCatalog = true;
                this.queryParams.setCatalog(((Catalog)object).getCatalog());
                continue;
            }
            if (!tagName.equals("contributor")) continue;
            this.queryParams.setContributor(((Contributor)object).getContributor());
            foundContributor = true;
            for (int c = 0; c < childNodes.getLength(); ++c) {
                Node cnode = childNodes.item(counter);
                if (!(cnode instanceof Element) || !((Element)cnode).getTagName().equals("catalog")) continue;
                foundCatalog = true;
            }
            if (foundCatalog || !this.queryParams.getHost().equals("service.iris.edu")) continue;
            this.fixCatalogForContributor(((Contributor)object).getContributor());
        }
        try {
            if (foundContributor) {
                FDSNEventCatalogQuerier querier = new FDSNEventCatalogQuerier(this.queryParams);
                querier.setUserAgent(this.getUserAgent());
                logger.info("contributor URL: " + querier.formURI());
                this.checkAgainstKnownServer("contributor", querier.getContributors());
                return;
            }
            if (foundCatalog) {
                FDSNEventCatalogQuerier querier = new FDSNEventCatalogQuerier(this.queryParams);
                querier.setUserAgent(this.getUserAgent());
                logger.info("catalog URL: " + querier.formURI());
                this.checkAgainstKnownServer("catalog", querier.getCatalogs());
                return;
            }
        }
        catch (FDSNWSException e) {
            throw new ConfigurationException("Trouble verifying catalog/contributor with server", e);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Trouble verifying catalog/contributor with server", e);
        }
    }

    private void checkAgainstKnownServer(String askStyle, List<String> contribList) {
        String askCatalog = this.queryParams.getParam(askStyle);
        if (!contribList.contains(askCatalog)) {
            String knownCatalogs = "";
            for (String c : contribList) {
                knownCatalogs = knownCatalogs + c + ", ";
            }
            knownCatalogs = knownCatalogs.substring(0, knownCatalogs.length() - 2);
            Start.informUserOfBadQueryAndExit("You asked for events from the " + askCatalog + " " + askStyle + " but the server does not think it has that " + askStyle + ". Known " + askStyle + "s are: " + knownCatalogs + ".", null);
        }
    }

    private void fixCatalogForContributor(String contributor) {
        if (contributor.contains("NEIC")) {
            this.queryParams.setCatalog("NEIC PDE");
        } else if (contributor.contains("GCMT")) {
            this.queryParams.setCatalog("GCMT");
        } else if (contributor.contains("ISC")) {
            this.queryParams.setCatalog("ISC");
        } else if (contributor.contains("ANF")) {
            this.queryParams.setCatalog("ANF");
        } else if (contributor.equals("University of Washington")) {
            this.queryParams.setCatalog("UofW");
        }
    }

    @Override
    public boolean hasNext() {
        MicroSecondDate queryEnd = this.getEventTimeRange().getEndTime();
        MicroSecondDate quitDate = queryEnd.add(this.lag);
        boolean out = quitDate.equals((Object)ClockUtil.now()) || quitDate.after((Date)ClockUtil.now()) || !this.getQueryStart().equals((Object)queryEnd);
        logger.debug(this.getName() + " Checking if more queries to the event server are in order.  The quit date is " + quitDate + " the last query was for " + this.getQueryStart() + " and we're querying to " + queryEnd + " result=" + out);
        return out;
    }

    @Override
    public CacheEvent[] next() {
        MicroSecondTimeRange queryTime = this.getQueryTime();
        logger.debug(this.getName() + ".next() called for " + queryTime);
        int count = 0;
        Throwable latest = null;
        while (count == 0 || this.getRetryStrategy().shouldRetry(latest, (Object)this, count++)) {
            Throwable rootCause;
            try {
                List<CacheEvent> result = this.internalNext(queryTime);
                if (count > 0) {
                    this.getRetryStrategy().serverRecovered((Object)this);
                }
                return result.toArray(new CacheEvent[0]);
            }
            catch (SeisFileException e) {
                latest = e;
                rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)e);
                if (rootCause instanceof IOException) {
                    if (!(rootCause instanceof SocketTimeoutException) && !(rootCause instanceof InterruptedIOException)) continue;
                    this.decreaseQueryTimeWidth();
                    this.increaseThreashold /= 2;
                    return new CacheEvent[0];
                }
                if (e instanceof FDSNWSException && ((FDSNWSException)((Object)e)).getHttpResponseCode() != 200) {
                    latest = e;
                    continue;
                }
                throw new RuntimeException(e);
            }
            catch (XMLStreamException e) {
                latest = e;
                rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)e);
                if (rootCause instanceof IOException) {
                    if (!(rootCause instanceof SocketTimeoutException)) continue;
                    this.decreaseQueryTimeWidth();
                    this.increaseThreashold /= 2;
                    return new CacheEvent[0];
                }
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw new RuntimeException(latest);
    }

    public List<CacheEvent> internalNext(MicroSecondTimeRange queryTime) throws SeisFileException, XMLStreamException {
        try {
            MicroSecondDate now = ClockUtil.now();
            ArrayList<CacheEvent> out = new ArrayList<CacheEvent>();
            Quakeml qml = this.getQuakeML(this.setUpQuery(queryTime));
            EventIterator it = qml.getEventParameters().getEvents();
            if (!it.hasNext()) {
                logger.debug("No events returned from query.");
            }
            while (it.hasNext()) {
                Event e = it.next();
                out.add(FdsnEvent.toCacheEvent(e));
            }
            qml.close();
            if (!this.caughtUpWithRealtime()) {
                if (out.size() < this.increaseThreashold) {
                    this.increaseQueryTimeWidth();
                }
                if (out.size() > this.decreaseThreashold) {
                    this.decreaseQueryTimeWidth();
                }
            }
            this.updateQueryEdge(queryTime);
            return out;
        }
        catch (SeisFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SeisFileException((Throwable)e);
        }
    }

    @Override
    public MicroSecondTimeRange getEventTimeRange() {
        return this.eventTimeRangeSupplier.getMSTR();
    }

    @Override
    public String getDescription() {
        try {
            return this.queryParams.formURI().toString() + " with time range appended later.";
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to for URL for description.", e);
        }
    }

    static CacheEvent toCacheEvent(Event e) {
        String desc = "";
        if (e.getDescriptionList().size() > 0) {
            desc = ((EventDescription)e.getDescriptionList().get(0)).getText();
        }
        FlinnEngdahlRegionImpl fe = new FlinnEngdahlRegionImpl(FlinnEngdahlType.GEOGRAPHIC_REGION, 0);
        for (EventDescription eDescription : e.getDescriptionList()) {
            if (eDescription.getIrisFECode() == -1) continue;
            fe = new FlinnEngdahlRegionImpl(FlinnEngdahlType.GEOGRAPHIC_REGION, eDescription.getIrisFECode());
        }
        ArrayList<OriginImpl> out = new ArrayList<OriginImpl>();
        HashMap magsByOriginId = new HashMap();
        List mList = e.getMagnitudeList();
        Object prefMag = null;
        for (Object m : mList) {
            if (!magsByOriginId.containsKey(m.getOriginId())) {
                magsByOriginId.put(m.getOriginId(), new ArrayList());
            }
            ((List)magsByOriginId.get(m.getOriginId())).add(m);
            if (!m.getPublicId().equals(e.getPreferredMagnitudeID())) continue;
            prefMag = m;
        }
        OriginImpl pref = null;
        for (edu.sc.seis.seisFile.fdsnws.quakeml.Origin o : e.getOriginList()) {
            ArrayList oMags = (ArrayList)magsByOriginId.get(o.getPublicId());
            if (oMags == null) {
                oMags = new ArrayList();
            }
            ArrayList<Magnitude> fisMags = new ArrayList<Magnitude>();
            for (edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude m : oMags) {
                if (m.getMag() == null) continue;
                fisMags.add(FdsnEvent.toFissuresMagnitude(m));
            }
            if (o.getLatitude() != null && o.getLongitude() != null && o.getTime() != null) {
                QuantityImpl depth = new QuantityImpl((double)o.getDepth().getValue().floatValue(), (Unit)UnitImpl.METER);
                OriginImpl oImpl = new OriginImpl(o.getPublicId(), o.getIrisCatalog(), o.getIrisContributor(), new MicroSecondDate(o.getTime().getValue()).getFissuresTime(), new Location(o.getLatitude().getValue().floatValue(), o.getLongitude().getValue().floatValue(), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)depth, LocationType.GEOGRAPHIC), fisMags.toArray(new Magnitude[0]), new ParameterRef[0]);
                out.add(oImpl);
                if (!o.getPublicId().equals(e.getPreferredOriginID())) continue;
                pref = oImpl;
                continue;
            }
            logger.info("Can't create origin due to NULL: id:" + o.getPublicId() + " lat:" + o.getLatitude() + " long:" + o.getLongitude() + " time:" + o.getTime() + ", skipping.");
        }
        if (prefMag != null && !e.getPreferredMagnitudeID().equals(e.getPreferredOriginID())) {
            Magnitude pm = FdsnEvent.toFissuresMagnitude(prefMag);
            ArrayList<Magnitude> newMags = new ArrayList<Magnitude>();
            newMags.add(pm);
            newMags.addAll(pref.getMagnitudeList());
            Iterator it = newMags.iterator();
            it.next();
            while (it.hasNext()) {
                Magnitude fm = (Magnitude)it.next();
                if (!fm.type.equals(pm.type) || fm.value != pm.value || !fm.contributor.equals(pm.contributor)) continue;
                it.remove();
            }
            pref = new OriginImpl(pref.get_id(), pref.getCatalog(), pref.getContributor(), pref.getOriginTime(), pref.getLocation(), newMags.toArray(new Magnitude[0]), pref.getParmIds());
        }
        CacheEvent ce = new CacheEvent((EventAttr)new EventAttrImpl(desc, (FlinnEngdahlRegion)fe), (Origin[])out.toArray(new OriginImpl[0]), pref);
        return ce;
    }

    static Magnitude toFissuresMagnitude(edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude m) {
        String contributor = "";
        if (m.getCreationInfo() != null && m.getCreationInfo().getAuthor() != null) {
            contributor = m.getCreationInfo().getAuthor();
        }
        String type = "";
        if (m.getType() != null) {
            type = m.getType();
        }
        return new Magnitude(type, m.getMag().getValue().floatValue(), contributor);
    }

    Quakeml getQuakeML(FDSNEventQueryParams timeWindowQueryParams) throws MalformedURLException, IOException, URISyntaxException, XMLStreamException, SeisFileException {
        FDSNEventQuerier querier = new FDSNEventQuerier(timeWindowQueryParams);
        querier.setUserAgent(this.getUserAgent());
        return querier.getQuakeML();
    }

    FDSNEventQueryParams setUpQuery(MicroSecondTimeRange queryTime) throws URISyntaxException {
        FDSNEventQueryParams timeWindowQueryParams = this.queryParams.clone();
        timeWindowQueryParams.setStartTime((Date)queryTime.getBeginTime());
        timeWindowQueryParams.setEndTime((Date)queryTime.getEndTime());
        if (this.isEverCaughtUpToRealtime() && this.lastQueryEnd != null) {
            timeWindowQueryParams.setUpdatedAfter((Date)this.lastQueryEnd.subtract(new TimeInterval(10.0, UnitImpl.HOUR)));
        }
        logger.debug("Query: " + timeWindowQueryParams.formURI());
        return timeWindowQueryParams;
    }

    @Override
    protected MicroSecondDate resetQueryTimeForLag() {
        MicroSecondDate out = super.resetQueryTimeForLag();
        this.lastQueryEnd = this.nextLastQueryEnd;
        this.nextLastQueryEnd = ClockUtil.now();
        return out;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

