/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import com.csvreader.CsvReader;
import edu.iris.Fissures.FlinnEngdahlRegion;
import edu.iris.Fissures.FlinnEngdahlType;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.FlinnEngdahlRegionImpl;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnsupportedFormat;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.source.event.SimpleEventSource;
import edu.sc.seis.sod.subsetter.AreaSubsetter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;

public class CSVEventSource
extends SimpleEventSource {
    private static final String DEFAULT_CSV_SOURCE_NAME = "CSVEventSource";
    private CacheEvent[] events;
    public static final String TIME = "time";
    public static final String LONGITUDE = "longitude";
    public static final String LATITUDE = "latitude";
    public static final String DEPTH = "depth";
    public static final String MAGNITUDE = "magnitude";
    public static final String CATALOG = "catalog";
    public static final String CONTRIBUTOR = "contributor";
    public static final String NAME = "name";
    public static final String FE_SEIS_REGION = "flinnEngdahlSeismicRegion";
    public static final String FE_GEO_REGION = "flinnEngdahlGeographicRegion";
    public static final String FE_REGION = "flinnEngdahlRegion";
    public static final String FE_REGION_TYPE = "flinnEngdahlRegionType";
    public static final String DEPTH_UNITS = "depthUnits";
    public static final String MAGNITUDE_TYPE = "magnitudeType";
    public static final String MAGNITUDE_CONTRIBUTOR = "magnitudeContributor";
    private static final String[] FIELDS = new String[]{"time", "longitude", "latitude", "depth", "depthUnits", "magnitude", "magnitudeType", "magnitudeContributor", "catalog", "contributor", "name", "flinnEngdahlSeismicRegion", "flinnEngdahlGeographicRegion", "flinnEngdahlRegion", "flinnEngdahlRegionType"};
    public static final String UNKNOWN = "unknown";
    private String csvFilename;

    public CSVEventSource(Element config) throws ConfigurationException {
        super(config, DEFAULT_CSV_SOURCE_NAME);
        if (DOMHelper.hasElement((Element)config, (String)"filename")) {
            this.initFromFile(DOMHelper.extractText((Element)config, (String)"filename"));
            if (this.getName().equals(DEFAULT_CSV_SOURCE_NAME)) {
                this.name = this.name + " " + this.csvFilename;
            }
        } else if (DOMHelper.hasElement((Element)config, (String)"events")) {
            try {
                this.events = CSVEventSource.getEventsFromReader(new StringReader(DOMHelper.extractText((Element)config, (String)"events").trim()));
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read events from:" + DOMHelper.extractText((Element)config, (String)"events"), e);
            }
        } else {
            throw new ConfigurationException("Can't find filename or events in configuration.");
        }
    }

    public CSVEventSource(String filename) throws ConfigurationException {
        super(filename);
        this.initFromFile(filename);
    }

    protected void initFromFile(String filename) throws ConfigurationException {
        this.csvFilename = filename;
        try {
            this.events = CSVEventSource.getEventsFromCSVFile(this.csvFilename);
        }
        catch (FileNotFoundException e) {
            throw new UserConfigurationException(e.getMessage() + " as a event CSV file.");
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to read " + this.csvFilename, e);
        }
    }

    @Override
    public String getDescription() {
        return "CSVEventSource: " + this.csvFilename;
    }

    @Override
    public CacheEvent[] getEvents() {
        return this.events;
    }

    public static CacheEvent[] getEventsFromCSVFile(String filename) throws FileNotFoundException, IOException, ConfigurationException {
        return CSVEventSource.getEventsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(filename));
    }

    public static CacheEvent[] getEventsFromReader(Reader reader) throws IOException, FileNotFoundException, ConfigurationException {
        ArrayList<CacheEvent> events = new ArrayList<CacheEvent>();
        CsvReader csvReader = new CsvReader(reader);
        csvReader.readHeaders();
        List<String> headers = Arrays.asList(csvReader.getHeaders());
        for (int i = 0; i < headers.size(); ++i) {
            String cur = headers.get(i);
            if (CSVEventSource.isValidField(cur)) continue;
            throw new UserConfigurationException(cur + " is not a known CSV field.  " + CSVEventSource.concatenateValidFields() + " are valid options.");
        }
        while (csvReader.readRecord()) {
            String[] magContribs;
            String[] magTypes;
            String defaultString;
            Time time = new Time(csvReader.get(TIME), 0);
            try {
                new ISOTime(time.date_time);
            }
            catch (UnsupportedFormat uf) {
                throw new UserConfigurationException("The time '" + time.date_time + "' in record " + csvReader.getCurrentRecord() + " is invalid.");
            }
            float latitude = 0.0f;
            if (headers.contains(LATITUDE)) {
                latitude = Float.parseFloat(csvReader.get(LATITUDE));
            }
            float longitude = 0.0f;
            if (headers.contains(LONGITUDE)) {
                longitude = Float.parseFloat(csvReader.get(LONGITUDE));
            }
            double depth = 0.0;
            if (headers.contains(DEPTH)) {
                depth = Double.parseDouble(csvReader.get(DEPTH));
            }
            UnitImpl depthUnit = UnitImpl.KILOMETER;
            if (headers.contains(DEPTH_UNITS)) {
                String unitName = csvReader.get(DEPTH_UNITS);
                try {
                    depthUnit = UnitImpl.getUnitFromString((String)unitName);
                }
                catch (NoSuchFieldException e) {
                    throw new UserConfigurationException(unitName + " in record " + csvReader.getCurrentRecord() + " is not a valid unit name.  Try KILOMETER or METER");
                }
            }
            Location location = new Location(latitude, longitude, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl(depth, (Unit)depthUnit), LocationType.GEOGRAPHIC);
            String catalog = defaultString = "csvEvent";
            if (headers.contains(CATALOG)) {
                catalog = csvReader.get(CATALOG);
            }
            String contributor = defaultString;
            if (headers.contains(CONTRIBUTOR)) {
                contributor = csvReader.get(CONTRIBUTOR);
            }
            Magnitude[] magnitudes = new Magnitude[]{};
            String[] magValues = headers.contains(MAGNITUDE) ? csvReader.get(MAGNITUDE).split(":") : new String[]{"0"};
            if (magValues.length > 1 || headers.contains(MAGNITUDE_TYPE)) {
                magTypes = csvReader.get(MAGNITUDE_TYPE).split(":");
                if (magTypes.length != magValues.length) {
                    throw new UserConfigurationException("count of magnitude types does not match count of magnitude values in record " + csvReader.getCurrentRecord() + ", " + magTypes.length + "!=" + magValues.length);
                }
            } else {
                magTypes = new String[]{"M"};
            }
            if (magValues.length > 1 || headers.contains(MAGNITUDE_CONTRIBUTOR)) {
                magContribs = csvReader.get(MAGNITUDE_CONTRIBUTOR).split(":");
                if (magContribs.length != magValues.length) {
                    String[] tmp = magContribs;
                    magContribs = new String[magValues.length];
                    System.arraycopy(tmp, 0, magContribs, 0, tmp.length);
                    for (int i = tmp.length; i < magContribs.length; ++i) {
                        magContribs[i] = UNKNOWN;
                    }
                }
            } else {
                magContribs = new String[]{UNKNOWN};
            }
            magnitudes = new Magnitude[magValues.length];
            for (int i = 0; i < magValues.length; ++i) {
                magnitudes[i] = new Magnitude(magTypes[i], Float.parseFloat(magValues[i]), magContribs[i]);
            }
            OriginImpl origin = new OriginImpl("", catalog, contributor, time, location, magnitudes, new ParameterRef[0]);
            String name = defaultString;
            if (headers.contains(NAME)) {
                name = csvReader.get(NAME);
            }
            FlinnEngdahlType feType = FlinnEngdahlType.SEISMIC_REGION;
            if (headers.contains(FE_REGION_TYPE)) {
                int type = Integer.parseInt(csvReader.get(FE_REGION_TYPE));
                if (type == 0) {
                    feType = FlinnEngdahlType.SEISMIC_REGION;
                } else if (type == 1) {
                    feType = FlinnEngdahlType.GEOGRAPHIC_REGION;
                }
            }
            FlinnEngdahlRegionImpl feRegion = new FlinnEngdahlRegionImpl(feType, 0);
            if (headers.contains(FE_REGION)) {
                feRegion = new FlinnEngdahlRegionImpl(feType, Integer.parseInt(csvReader.get(FE_REGION)));
            }
            events.add(new CacheEvent((EventAttr)new EventAttrImpl(name, (FlinnEngdahlRegion)feRegion), origin));
        }
        return events.toArray(new CacheEvent[0]);
    }

    public static String concatenateValidFields() {
        String allFields = "";
        for (int i = 0; i < FIELDS.length - 1; ++i) {
            allFields = allFields + FIELDS[i] + ", ";
        }
        return allFields + FIELDS[FIELDS.length - 1];
    }

    private static boolean isValidField(String field) {
        for (int i = 0; i < FIELDS.length; ++i) {
            if (!field.equals(FIELDS[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "CSVEventSource using " + this.csvFilename;
    }
}

