/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.statistics.Statistics;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.io.plots.DrawableWriter;
import de.erichseifert.gral.io.plots.DrawableWriterFactory;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.util.Insets2D;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Rotate;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.SeismogramPDFBuilder;
import edu.sc.seis.fissuresUtil.display.configuration.BorderConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.process.waveform.AbstractFileWriter;
import edu.sc.seis.sod.process.waveform.PhaseCut;
import edu.sc.seis.sod.process.waveform.PhaseWindow;
import edu.sc.seis.sod.process.waveform.SeismogramTitler;
import edu.sc.seis.sod.process.waveform.vector.ANDWaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.SeisPlotDataSource;
import edu.sc.seis.sod.process.waveform.vector.VectorTrim;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.StringTreeBranch;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.requestGenerator.PhaseRequest;
import edu.sc.seis.sod.velocity.seismogram.VelocityPhaseRequest;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ParticleMotionPlot
extends AbstractFileWriter
implements WaveformVectorProcess {
    boolean doVerticalPlots = true;
    BorderConfiguration titleBorder = new BorderConfiguration();
    SeismogramTitler titler;
    PhaseWindow phaseWindow;
    public static String DEFAULT_FILE_TEMPLATE = "Event_${event.getTime('yyyy_MM_dd_HH_mm_ss')}/${prefix}${station}_${chan.get_code()}_${otherChannel.get_code()}_${index}.pdf";
    SeismogramPDFBuilder pdfBuilder = new SeismogramPDFBuilder();
    private VectorTrim trimmer = new VectorTrim();
    private PhaseCut cutter = new PhaseCut(new PhaseRequest("P", new TimeInterval(0.0, UnitImpl.SECOND), "P", new TimeInterval(10.0, UnitImpl.SECOND), "iasp91"));
    private static Logger logger = LoggerFactory.getLogger(ParticleMotionPlot.class);

    public ParticleMotionPlot(Element config) throws Exception {
        this(ParticleMotionPlot.extractWorkingDir(config), ParticleMotionPlot.extractFileTemplate(config, DEFAULT_FILE_TEMPLATE), ParticleMotionPlot.extractPrefix(config));
        if (DOMHelper.hasElement((Element)config, (String)"titleBorder")) {
            this.titleBorder.configure(DOMHelper.getElement((Element)config, (String)"titleBorder"));
            this.titler = new SeismogramTitler(this.titleBorder);
        }
        if (DOMHelper.hasElement((Element)config, (String)"phaseWindow")) {
            this.phaseWindow = new PhaseWindow(SodUtil.getElement(config, "phaseWindow"));
            this.cutter = new PhaseCut(this.phaseWindow.getPhaseRequest());
        }
    }

    public ParticleMotionPlot(String workingDir, String fileTemplate, String prefix) throws Exception {
        super(workingDir, fileTemplate, prefix);
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        int i;
        WaveformVectorResult cutResult = new ANDWaveformProcessWrapper(this.cutter).accept(event, channelGroup, original, available, seismograms, cookieJar);
        if (!cutResult.isSuccess()) {
            return new WaveformVectorResult(false, cutResult.getSeismograms(), new StringTreeBranch((Object)this, false, cutResult.getReason()));
        }
        WaveformVectorResult trimResult = this.trimmer.accept(event, channelGroup, original, available, cutResult.getSeismograms(), cookieJar);
        if (!trimResult.isSuccess()) {
            return new WaveformVectorResult(false, trimResult.getSeismograms(), new StringTreeBranch((Object)this, false, trimResult.getReason()));
        }
        LocalSeismogramImpl[][] cutAndTrim = trimResult.getSeismograms();
        ChannelImpl[] horizontal = channelGroup.getHorizontalXY();
        if (horizontal.length == 0) {
            Orientation o1 = channelGroup.getChannel1().getOrientation();
            Orientation o2 = channelGroup.getChannel2().getOrientation();
            Orientation o3 = channelGroup.getChannel3().getOrientation();
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Channels not rotatable, unable to find horizontals with 90 deg separation: " + o1.azimuth + "/" + o1.dip + " " + o2.azimuth + "/" + o2.dip + " " + o3.azimuth + "/" + o3.dip + " "));
        }
        int xIndex = -1;
        int yIndex = -1;
        for (int i2 = 0; i2 < cutAndTrim.length; ++i2) {
            if (cutAndTrim[i2].length == 0) continue;
            if (ChannelIdUtil.areEqual((ChannelId)seismograms[i2][0].channel_id, (ChannelId)horizontal[0].get_id())) {
                xIndex = i2;
            }
            if (!ChannelIdUtil.areEqual((ChannelId)seismograms[i2][0].channel_id, (ChannelId)horizontal[1].get_id())) continue;
            yIndex = i2;
        }
        int zIndex = -1;
        for (i = 0; i < 3; ++i) {
            if (i == xIndex || i == yIndex) continue;
            zIndex = i;
            break;
        }
        if (xIndex == -1 || yIndex == -1) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Can't find seismograms to match horizontal channels: xIndex=" + xIndex + " yIndex=" + yIndex));
        }
        if (cutAndTrim[xIndex].length != cutAndTrim[yIndex].length) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Seismogram lengths for horizontal channels don't match: " + seismograms[xIndex].length + " != " + seismograms[yIndex].length));
        }
        if (this.doVerticalPlots && cutAndTrim[xIndex].length != cutAndTrim[zIndex].length) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Seismogram lengths for horizontal and vertical channels don't match: " + seismograms[xIndex].length + " != " + seismograms[zIndex].length));
        }
        for (i = 0; i < cutAndTrim[xIndex].length; ++i) {
            if (cutAndTrim[xIndex][i].getNumPoints() != cutAndTrim[yIndex][i].getNumPoints()) {
                return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, i + " Seismogram num points for horizontal channels don't match: " + cutAndTrim[xIndex][i].getNumPoints() + " != " + cutAndTrim[yIndex][i].getNumPoints()));
            }
            if (!this.doVerticalPlots || cutAndTrim[xIndex][i].getNumPoints() == cutAndTrim[zIndex][i].getNumPoints()) continue;
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, i + " Seismogram num points for horizontal channels don't match: " + cutAndTrim[xIndex][i].getNumPoints() + " != " + cutAndTrim[zIndex][i].getNumPoints()));
        }
        HashMap<String, Object> extras = new HashMap<String, Object>();
        Plot plot = this.makePlot(cutAndTrim[xIndex], horizontal[0], cutAndTrim[yIndex], horizontal[1], event);
        this.savePlot(plot, event, horizontal[0], horizontal[1], extras);
        if (this.doVerticalPlots) {
            plot = this.makePlot(cutAndTrim[xIndex], horizontal[0], cutAndTrim[zIndex], channelGroup.getVertical(), event);
            this.savePlot(plot, event, horizontal[0], channelGroup.getVertical(), extras);
            plot = this.makePlot(cutAndTrim[yIndex], horizontal[1], cutAndTrim[zIndex], channelGroup.getVertical(), event);
            this.savePlot(plot, event, horizontal[1], channelGroup.getVertical(), extras);
        }
        return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, true));
    }

    public Plot makePlot(LocalSeismogramImpl[] XSeis, ChannelImpl xChan, LocalSeismogramImpl[] ySeis, ChannelImpl yChan, CacheEvent event) throws Exception {
        Axis axis;
        String yAngle;
        String xAngle;
        SeisPlotDataSource data;
        if (this.titler != null) {
            MicroSecondTimeRange timeWindow = null;
            timeWindow = new MicroSecondTimeRange(this.phaseWindow.getPhaseRequest().generateRequest((EventAccessOperations)event, (Channel)xChan));
            HashMap<String, Object> extras = new HashMap<String, Object>();
            extras.put("phaseWindow", new VelocityPhaseRequest(this.phaseWindow.getPhaseRequest()));
            this.titler.title((EventAccessOperations)event, (Channel)xChan, timeWindow, extras);
        }
        if (yChan.getOrientation().dip > -5.0f) {
            data = new SeisPlotDataSource(XSeis[0], xChan.getOrientation().azimuth, ySeis[0], yChan.getOrientation().azimuth);
            xAngle = xChan.getOrientation().azimuth + " az";
            yAngle = yChan.getOrientation().azimuth + " az";
        } else {
            data = new SeisPlotDataSource(XSeis[0], 90.0f + xChan.getOrientation().dip, ySeis[0], 90.0f + yChan.getOrientation().dip);
            xAngle = xChan.getOrientation().dip + " dip";
            yAngle = yChan.getOrientation().dip + " dip";
        }
        XYPlot plot = new XYPlot(new DataSource[]{data});
        plot.setInsets((Insets2D)new Insets2D.Double(20.0, 50.0, 50.0, 20.0));
        DefaultLineRenderer2D lr1 = new DefaultLineRenderer2D();
        lr1.setSetting(LineRenderer.COLOR, (Object)Color.RED);
        plot.setLineRenderer((DataSource)data, (LineRenderer)lr1);
        double insetsTop = 20.0;
        double insetsLeft = 60.0;
        double insetsBottom = 60.0;
        double insetsRight = 40.0;
        plot.setInsets((Insets2D)new Insets2D.Double(insetsTop, insetsLeft, insetsBottom, insetsRight));
        if (this.titleBorder.getTitles().length != 0) {
            plot.setSetting(Plot.TITLE, (Object)this.titleBorder.getTitles()[0].getTitle());
        }
        plot.getAxisRenderer("x").setSetting(AxisRenderer.LABEL, (Object)(ChannelIdUtil.toStringNoDates((Channel)xChan) + " " + xAngle));
        plot.getAxisRenderer("y").setSetting(AxisRenderer.LABEL, (Object)(ChannelIdUtil.toStringNoDates((Channel)yChan) + " " + yAngle));
        Statistics dataStats = data.getStatistics();
        dataStats.get("min");
        Collection axisList = plot.getAxesNames();
        float range = 0.0f;
        for (String axisName : axisList) {
            axis = plot.getAxis(axisName);
            if (!(axis.getRange() > (double)range)) continue;
            range = (float)axis.getRange();
        }
        for (String axisName : axisList) {
            axis = plot.getAxis(axisName);
            float middle = (axis.getMin().floatValue() + axis.getMax().floatValue()) / 2.0f;
            axis.setRange((Number)Float.valueOf(middle - range / 2.0f), (Number)Float.valueOf(middle + range / 2.0f));
        }
        plot.getAxisRenderer("x").setSetting(AxisRenderer.INTERSECTION, (Object)-1.7976931348623157E308);
        plot.getAxisRenderer("y").setSetting(AxisRenderer.INTERSECTION, (Object)-1.7976931348623157E308);
        if (xChan.getOrientation().dip == 0.0f && yChan.getOrientation().dip == 0.0f) {
            Location staLoc = xChan.getSite().getLocation();
            Location eventLoc = EventUtil.extractOrigin((EventAccessOperations)event).getLocation();
            float baz = (float)(180.0 + Rotate.getRadialAzimuth((Location)staLoc, (Location)eventLoc)) % 360.0f;
            this.addAzimuthLine(plot, baz, range, Color.GREEN);
            this.addAzimuthLine(plot, xChan.getOrientation().azimuth, range / 2.0f, Color.BLUE);
            this.addAzimuthLine(plot, yChan.getOrientation().azimuth, range / 2.0f, Color.BLUE);
        }
        return plot;
    }

    void addAzimuthLine(XYPlot plot, double azimuth, float length, Color lineColor) {
        DataTable bazLine = new DataTable(new Class[]{Float.class, Float.class});
        float xMid = (plot.getAxis("x").getMin().floatValue() + plot.getAxis("x").getMax().floatValue()) / 2.0f;
        float yMid = (plot.getAxis("y").getMin().floatValue() + plot.getAxis("y").getMax().floatValue()) / 2.0f;
        float x = (float)((double)(length / 2.0f) * Math.cos(Math.toRadians(90.0 - azimuth)));
        float y = (float)((double)(length / 2.0f) * Math.sin(Math.toRadians(90.0 - azimuth)));
        bazLine.add(new Comparable[]{Float.valueOf(xMid - x), Float.valueOf(yMid - y)});
        bazLine.add(new Comparable[]{Float.valueOf(xMid + x), Float.valueOf(yMid + y)});
        plot.add((DataSource)bazLine);
        DefaultLineRenderer2D bazlr = new DefaultLineRenderer2D();
        bazlr.setSetting(LineRenderer.COLOR, (Object)lineColor);
        plot.setLineRenderer((DataSource)bazLine, (LineRenderer)bazlr);
    }

    public void savePlot(Plot plot, CacheEvent event, ChannelImpl channel, ChannelImpl otherChannel, Map<String, Object> extras) throws IOException {
        this.removeExisting(event, channel, otherChannel, extras);
        String picFileName = this.generate(event, channel, otherChannel, 0, extras);
        File f = new File(picFileName);
        File parent = f.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory " + parent);
        }
        DrawableWriter writer = DrawableWriterFactory.getInstance().get("application/pdf");
        writer.write((Drawable)plot, (OutputStream)new FileOutputStream(f), 800.0, 800.0);
    }
}

