/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.AbstractScriptSubsetter;
import edu.sc.seis.sod.subsetter.UnknownScriptResult;
import edu.sc.seis.sod.velocity.event.VelocityEvent;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import edu.sc.seis.sod.velocity.seismogram.VelocityRequest;
import edu.sc.seis.sod.velocity.seismogram.VelocitySeismogram;
import java.util.List;
import org.w3c.dom.Element;

public class SeismogramScript
extends AbstractScriptSubsetter
implements WaveformProcess {
    public SeismogramScript(Element config) {
        super(config);
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        return this.runScript(new VelocityEvent(event), new VelocityChannel(channel), VelocityRequest.wrap(original, (Channel)channel), VelocityRequest.wrap(available, (Channel)channel), VelocitySeismogram.wrap(seismograms, (Channel)channel), cookieJar);
    }

    public WaveformResult runScript(VelocityEvent event, VelocityChannel channel, List<VelocityRequest> request, List<VelocityRequest> available, List<VelocitySeismogram> seismograms, CookieJar cookieJar) throws Exception {
        this.engine.put("event", (Object)event);
        this.engine.put("channel", (Object)channel);
        this.engine.put("request", request);
        this.engine.put("available", available);
        this.engine.put("seismograms", seismograms);
        this.engine.put("cookieJar", cookieJar);
        Object result = this.preeval();
        if (result == null) {
            result = this.engine.get("result");
        }
        if (result == null) {
            return new WaveformResult((LocalSeismogramImpl[])this.engine.get("seismograms"), new Pass(this));
        }
        if (result instanceof WaveformResult) {
            return (WaveformResult)result;
        }
        if (result instanceof StringTree) {
            return new WaveformResult((LocalSeismogramImpl[])this.engine.get("seismograms"), (StringTree)result);
        }
        if (result instanceof Boolean) {
            return new WaveformResult((LocalSeismogramImpl[])this.engine.get("seismograms"), new StringTreeLeaf(this, (boolean)((Boolean)result)));
        }
        throw new UnknownScriptResult("Script returns unknown results type, should be boolean or StringTree or WaveformResult: " + result.toString());
    }
}

