/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.PhasePhilter;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.TitleBorder;
import edu.sc.seis.fissuresUtil.display.configuration.BorderConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.display.configuration.SeismogramDisplayConfiguration;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import edu.sc.seis.fissuresUtil.display.registrar.BasicTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSetSeismogram;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.process.waveform.PhaseWindow;
import edu.sc.seis.sod.process.waveform.SeismogramImageOutputLocator;
import edu.sc.seis.sod.process.waveform.SeismogramTitler;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.requestGenerator.PhaseRequest;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeismogramImageProcess
implements WaveformProcess {
    private SeismogramDisplayConfiguration sdc = new SeismogramDisplayConfiguration();
    protected SeismogramImageOutputLocator locator;
    protected BorderConfiguration titleBorder;
    private TauPUtil tauP = TauPUtil.getTauPUtil();
    private boolean showOnlyFirst;
    private SeismogramTitler titler;
    protected PhaseWindow phaseWindow;
    private PhasePhilter.PhaseRenamer renamer = new PhasePhilter.PhaseRenamer();
    private String modelName = "iasp91";
    protected String[] phaseFlagNames = DEFAULT_PHASES;
    protected Dimension dims = DEFAULT_DIMENSION;
    public static final String PDF = "pdf";
    public static final String PNG = "png";
    private static final String[] DEFAULT_PHASES = new String[0];
    private static Dimension DEFAULT_DIMENSION = new Dimension(500, 200);
    private Logger logger = LoggerFactory.getLogger(SeismogramImageProcess.class);

    public SeismogramImageProcess(SeismogramImageOutputLocator locator) {
        this.locator = locator;
    }

    public SeismogramImageProcess(Element el) throws Exception {
        if (DOMHelper.hasElement((Element)el, (String)"phaseWindow")) {
            this.phaseWindow = new PhaseWindow(SodUtil.getElement(el, "phaseWindow"));
        }
        if (DOMHelper.hasElement((Element)el, (String)"modelName")) {
            this.modelName = SodUtil.getNestedText(SodUtil.getElement(el, "modelName"));
            this.tauP = TauPUtil.getTauPUtil((String)this.modelName);
        }
        if (DOMHelper.hasElement((Element)el, (String)"dimension")) {
            this.dims = SodUtil.loadDimensions(SodUtil.getElement(el, "dimension"));
        }
        if (DOMHelper.hasElement((Element)el, (String)"showOnlyFirstArrivals")) {
            this.showOnlyFirst = true;
        }
        if (DOMHelper.hasElement((Element)el, (String)"phaseNameMappings")) {
            this.renamer = new PhasePhilter.PhaseRenamer((Node)SodUtil.getElement(el, "phaseNameMappings"));
        }
        if (DOMHelper.hasElement((Element)el, (String)"phaseFlags")) {
            Element subEl = SodUtil.getElement(el, "phaseFlags");
            NodeList flagEls = subEl.getElementsByTagName("phase");
            this.phaseFlagNames = new String[flagEls.getLength()];
            for (int j = 0; j < flagEls.getLength(); ++j) {
                this.phaseFlagNames[j] = SodUtil.nodeValueOfXPath((Element)flagEls.item(j), "text()");
            }
        }
        if (DOMHelper.hasElement((Element)el, (String)"displayConfig")) {
            this.sdc = SeismogramDisplayConfiguration.create((Element)SodUtil.getElement(el, "displayConfig"));
        }
        if (DOMHelper.hasElement((Element)el, (String)"titleBorder")) {
            this.titleBorder = new BorderConfiguration();
            this.titleBorder.configure(DOMHelper.getElement((Element)el, (String)"titleBorder"));
            this.titler = new SeismogramTitler(this.titleBorder);
        }
        this.locator = new SeismogramImageOutputLocator(el);
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        return this.process(event, (Channel)channel, original, seismograms, this.locator.getFileType(), cookieJar);
    }

    public WaveformResult process(CacheEvent event, Channel channel, RequestFilter[] original, LocalSeismogramImpl[] seismograms, String fileType, CookieJar cookieJar) throws Exception {
        return this.process(event, channel, original, seismograms, fileType, this.phaseFlagNames, cookieJar);
    }

    public WaveformResult process(CacheEvent event, Channel channel, RequestFilter[] original, LocalSeismogramImpl[] seismograms, String fileType, String[] phases, CookieJar cookieJar) throws Exception {
        return this.process(event, channel, original, seismograms, fileType, phases, true, cookieJar);
    }

    public static MemoryDataSetSeismogram createSeis(LocalSeismogramImpl[] seismograms, RequestFilter[] original) throws Exception {
        MemoryDataSetSeismogram memDSS = new MemoryDataSetSeismogram(original[0], "");
        memDSS.setBeginTime(DisplayUtils.firstBeginDate((RequestFilter[])original).getFissuresTime());
        memDSS.setEndTime(DisplayUtils.lastEndDate((RequestFilter[])original).getFissuresTime());
        for (int i = 0; i < seismograms.length; ++i) {
            memDSS.add(seismograms[i]);
        }
        return memDSS;
    }

    protected List<Arrival> getArrivals(Channel chan, Origin o, String[] phases) throws TauModelException {
        Station sta = chan.getSite().getStation();
        TimeInterval filterOffset = new TimeInterval(10.0, UnitImpl.SECOND);
        List arrivals = PhasePhilter.filter((List)this.tauP.calcTravelTimes(sta, o, phases), (TimeInterval)filterOffset);
        if (this.showOnlyFirst) {
            arrivals = PhasePhilter.mindPsAndSs((List)arrivals);
        }
        return arrivals;
    }

    protected void addFlags(List<Arrival> arrivals, Origin o, SeismogramDisplay bsd, DataSetSeismogram seis) {
        MicroSecondDate originTime = new MicroSecondDate(o.getOriginTime());
        for (int i = 0; i < arrivals.size(); ++i) {
            MicroSecondDate flagTime = originTime.add(new TimeInterval(arrivals.get(i).getTime(), UnitImpl.SECOND));
            bsd.add((Drawable)new Flag(flagTime, this.renamer.rename(arrivals.get(i)), bsd.getDrawableSeismogram(seis)));
        }
    }

    public WaveformResult process(CacheEvent event, Channel channel, RequestFilter[] original, LocalSeismogramImpl[] seismograms, String fileType, String[] phases, boolean relTime, CookieJar cookieJar) throws Exception {
        this.logger.debug("process() called");
        MemoryDataSetSeismogram memDSS = this.createDataSetSeismogram((EventAccessOperations)event, channel, original, seismograms);
        SeismogramDisplay bsd = this.createPopulatedDisplay((EventAccessOperations)event, channel, new DataSetSeismogram[]{memDSS}, phases);
        String picFileName = this.locator.getLocation(event, channel, fileType);
        this.writeImage(bsd, this.locator.getFileType(), picFileName);
        return new WaveformResult(seismograms, new StringTreeLeaf(this, true));
    }

    public SeismogramDisplay createPopulatedDisplay(EventAccessOperations event, Channel channel, DataSetSeismogram[] seis, String[] phases) throws Exception {
        MicroSecondTimeRange timeWindow = null;
        if (seis.length > 0) {
            timeWindow = SeismogramImageProcess.getTimeWindow(this.phaseWindow, seis[0]);
            this.updateTitles(event, channel, timeWindow);
        }
        SeismogramDisplay bsd = this.sdc.createDisplay();
        BasicTimeConfig tc = new BasicTimeConfig();
        bsd.setTimeConfig((TimeConfig)tc);
        this.populateDisplay(bsd, event, channel, seis, phases);
        if (seis.length > 0) {
            SeismogramImageProcess.setTimeWindow((TimeConfig)tc, timeWindow, tc.getTime(seis[0]));
        }
        return bsd;
    }

    private void populateDisplay(SeismogramDisplay sd, EventAccessOperations event, Channel channel, DataSetSeismogram[] seis, String[] phases) throws TauModelException {
        OriginImpl o = EventUtil.extractOrigin((EventAccessOperations)event);
        this.addFlags(this.getArrivals(channel, (Origin)o, phases), (Origin)o, sd, seis[0]);
        if (seis.length > 0) {
            sd.add(seis);
        }
    }

    private MemoryDataSetSeismogram createDataSetSeismogram(EventAccessOperations event, Channel channel, RequestFilter[] original, LocalSeismogramImpl[] seismograms) throws Exception {
        MemoryDataSetSeismogram memDSS = SeismogramImageProcess.createSeis(seismograms, original);
        MemoryDataSet dataset = new MemoryDataSet("temp", "Temp Dataset for " + memDSS.getName(), "temp", new AuditInfo[0]);
        dataset.addDataSetSeismogram((DataSetSeismogram)memDSS, new AuditInfo[0]);
        dataset.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", (Object)event, new AuditInfo[0]);
        dataset.addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)channel.get_id()), (Object)channel, new AuditInfo[0]);
        return memDSS;
    }

    public static void setTimeWindow(TimeConfig tc, DataSetSeismogram dss) throws Exception {
        SeismogramImageProcess.setTimeWindow(tc, null, dss);
    }

    public static void setTimeWindow(TimeConfig tc, PhaseWindow pw, DataSetSeismogram dss) throws Exception {
        SeismogramImageProcess.setTimeWindow(tc, SeismogramImageProcess.getTimeWindow(pw, dss), tc.getTime(dss));
    }

    public static void setTimeWindow(TimeConfig tc, MicroSecondTimeRange newTime, MicroSecondTimeRange currentTime) {
        double[] shiftNScale = DisplayUtils.getShiftAndScale((MicroSecondTimeRange)newTime, (MicroSecondTimeRange)currentTime);
        tc.shaleTime(shiftNScale[0], shiftNScale[1]);
    }

    public static MicroSecondTimeRange getTimeWindow(PhaseWindow pw, DataSetSeismogram dss) throws Exception {
        RequestFilter rf;
        if (pw != null) {
            PhaseRequest pr = pw.getPhaseRequest();
            rf = pr.generateRequest(dss.getEvent(), dss.getChannel());
        } else {
            rf = dss.getRequestFilter();
        }
        return new MicroSecondTimeRange(rf);
    }

    public void updateTitles(EventAccessOperations event, Channel channel, MicroSecondTimeRange timeRange) {
        if (this.titler != null) {
            this.titler.title(event, channel, timeRange);
        }
    }

    public BorderConfiguration getTitleBorder() {
        return this.titleBorder;
    }

    protected void writeImage(SeismogramDisplay disp, String fileType, String picFileName) throws Exception {
        SwingUtilities.invokeAndWait(new ImageWriter(disp, fileType, picFileName));
    }

    protected class ImageWriter
    implements Runnable {
        private final SeismogramDisplay bsd;
        private final String fileType;
        private final String picFileName;

        private ImageWriter(SeismogramDisplay bsd, String fileType, String picFileName) {
            this.bsd = bsd;
            this.fileType = fileType;
            this.picFileName = picFileName;
            if (!fileType.equals(SeismogramImageProcess.PDF) && !fileType.equals(SeismogramImageProcess.PNG)) {
                throw new IllegalArgumentException("Unknown fileType:" + fileType);
            }
        }

        @Override
        public void run() {
            block6: {
                SeismogramImageProcess.this.logger.debug("writing " + this.picFileName);
                try {
                    File outFile = new File(this.picFileName);
                    outFile.getParentFile().mkdirs();
                    if (this.fileType.equals(SeismogramImageProcess.PDF)) {
                        if (SeismogramImageProcess.this.titleBorder != null) {
                            this.bsd.outputToPDF(outFile, (TitleBorder)SeismogramImageProcess.this.titleBorder.createBorder(this.bsd));
                        } else {
                            this.bsd.outputToPDF(outFile);
                        }
                        break block6;
                    }
                    if (this.fileType.equals(SeismogramImageProcess.PNG)) {
                        this.bsd.outputToPNG(outFile, SeismogramImageProcess.this.dims);
                        break block6;
                    }
                    throw new RuntimeException("Unknown fileType:" + this.fileType);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle((String)("unable to save seismogram image to " + this.picFileName), (Throwable)e);
                }
            }
        }
    }
}

