/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.status.ChannelFormatter;
import edu.sc.seis.sod.status.EventFormatter;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.status.StationFormatter;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.velocity.event.VelocityEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeismogramImageOutputLocator {
    private String fileDir = "";
    private String prefix = "";
    private String configuredFileType = "png";
    private EventFormatter eventFormatter = EventFormatter.makeTime();
    private StationFormatter stationFormatter = StationFormatter.makeNetAndCode();
    private ChannelFormatter chanFormatter = ChannelFormatter.makeSiteAndCode();

    private SeismogramImageOutputLocator() {
    }

    public SeismogramImageOutputLocator(Element el) throws Exception {
        this(el, true);
    }

    public SeismogramImageOutputLocator(Element el, boolean useBase) throws Exception {
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("fileDir")) {
                NodeList fileNodes = ((Element)n).getChildNodes();
                for (int j = 0; j < fileNodes.getLength(); ++j) {
                    if (fileNodes.item(j).getNodeName().equals("statusBase")) {
                        if (!useBase) continue;
                        this.fileDir = this.fileDir + Start.getRunProps().getStatusBaseDir() + "/";
                        continue;
                    }
                    this.fileDir = this.fileDir + fileNodes.item(j).getNodeValue();
                }
                continue;
            }
            if (n.getNodeName().equals("seismogramConfig")) {
                if (this.fileDir.equals("")) {
                    this.fileDir = FileWritingTemplate.getBaseDirectoryName();
                }
                Element config = TemplateFileLoader.getTemplate((Element)n);
                this.parseOutputLocationCreators(SodUtil.getElement(config, "outputLocation"));
                continue;
            }
            if (n.getNodeName().equals("outputLocationCreators")) {
                this.parseOutputLocationCreators((Element)n);
                continue;
            }
            if (n.getNodeName().equals("prefix")) {
                this.prefix = SodUtil.getNestedText((Element)n);
                continue;
            }
            if (!n.getNodeName().equals("fileType")) continue;
            this.configuredFileType = SodUtil.getNestedText((Element)n);
        }
        if (this.fileDir.equals("")) {
            this.fileDir = FileWritingTemplate.getBaseDirectoryName();
        }
    }

    public static SeismogramImageOutputLocator createForLocalSeismogramTemplate(Element el) throws ConfigurationException {
        SeismogramImageOutputLocator out = new SeismogramImageOutputLocator();
        out.parseOutputLocationCreators(el);
        out.prefix = "original_";
        out.fileDir = FileWritingTemplate.getBaseDirectoryName();
        return out;
    }

    public String getFileType() {
        return this.configuredFileType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private void parseOutputLocationCreators(Element parent) throws ConfigurationException {
        Element eventDir = SodUtil.getElement(parent, "eventDir");
        this.eventFormatter = new EventFormatter(eventDir);
        Element stationDir = SodUtil.getElement(parent, "stationDir");
        this.stationFormatter = new StationFormatter(stationDir);
        Element picName = SodUtil.getElement(parent, "picName");
        this.chanFormatter = new ChannelFormatter(picName, true);
    }

    public String getLocation(VelocityEvent event, Channel channel) {
        return this.getLocation(event.getCacheEvent(), channel);
    }

    public String getLocation(CacheEvent event, Channel channel) {
        return this.getLocation(event, channel, this.configuredFileType);
    }

    public String getLocation(VelocityEvent event, Channel channel, String fileType) {
        return this.getLocation(event.getCacheEvent(), channel, fileType);
    }

    public String getLocation(CacheEvent event, Channel channel, String fileType) {
        return FissuresFormatter.filize(this.getDirectory(event, channel, true) + this.prefix + this.chanFormatter.getResult(channel) + "." + fileType);
    }

    public String getDirectory(CacheEvent event, Channel chan, boolean useStatusDir) {
        String dir = useStatusDir ? this.fileDir : "";
        dir = dir + '/' + this.eventFormatter.getResult(event) + '/' + this.stationFormatter.getResult(chan.getSite().getStation()) + '/';
        return dir;
    }
}

