/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.LongShortTrigger;
import edu.sc.seis.fissuresUtil.bag.PhaseNonExistent;
import edu.sc.seis.fissuresUtil.bag.SimplePhaseStoN;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PhaseSignalToNoise
implements WaveformProcess,
Threadable {
    public static final String PHASE_STON_PREFIX = "sod_phaseStoN_";
    protected SimplePhaseStoN phaseStoN;
    protected float ratio = 1.0f;
    protected String phaseName;
    protected TimeInterval shortOffsetBegin;
    protected TimeInterval shortOffsetEnd;
    protected TimeInterval longOffsetBegin;
    protected TimeInterval longOffsetEnd;
    protected String modelName = "prem";
    protected TimeInterval triggerWindow;
    protected TauPUtil taupUtil;

    public PhaseSignalToNoise(Element config) throws ConfigurationException, TauModelException {
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            Node node = childNodes.item(counter);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getTagName().equals("phaseName")) {
                this.phaseName = SodUtil.getNestedText(element);
                continue;
            }
            if (element.getTagName().equals("modelName")) {
                this.modelName = SodUtil.getNestedText(element);
                continue;
            }
            if (element.getTagName().equals("ratio")) {
                this.ratio = Float.parseFloat(SodUtil.getNestedText(element));
                continue;
            }
            if (element.getTagName().equals("shortOffsetBegin")) {
                this.shortOffsetBegin = SodUtil.loadTimeInterval(element);
                continue;
            }
            if (element.getTagName().equals("shortOffsetEnd")) {
                this.shortOffsetEnd = SodUtil.loadTimeInterval(element);
                continue;
            }
            if (element.getTagName().equals("longOffsetBegin")) {
                this.longOffsetBegin = SodUtil.loadTimeInterval(element);
                continue;
            }
            if (!element.getTagName().equals("longOffsetEnd")) continue;
            this.longOffsetEnd = SodUtil.loadTimeInterval(element);
        }
        this.taupUtil = TauPUtil.getTauPUtil((String)this.modelName);
        this.phaseStoN = new SimplePhaseStoN(this.phaseName, this.shortOffsetBegin, this.shortOffsetEnd, this.longOffsetBegin, this.longOffsetEnd, this.taupUtil);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        if (seismograms.length == 0) {
            return new WaveformResult(seismograms, new StringTreeLeaf(this, false, "no seismograms"));
        }
        try {
            LongShortTrigger trigger = this.calcTrigger((EventAccessOperations)event, (Channel)channel, seismograms);
            if (trigger != null) {
                if (trigger.getValue() > this.ratio) {
                    cookieJar.put(this.getCookieName(), (Serializable)trigger);
                    return new WaveformResult(seismograms, new StringTreeLeaf(this, true));
                }
                return new WaveformResult(seismograms, new StringTreeLeaf(this, false, "trigger=" + trigger.getValue() + " < " + this.ratio));
            }
            return new WaveformResult(seismograms, new StringTreeLeaf(this, false, "trigger is null"));
        }
        catch (PhaseNonExistent e) {
            return new WaveformResult(seismograms, new StringTreeLeaf(this, false, "Phase does not exist"));
        }
    }

    public LongShortTrigger calcTrigger(EventAccessOperations event, Channel channel, LocalSeismogramImpl[] seismograms) throws NoPreferredOrigin, FissuresException, PhaseNonExistent, TauModelException {
        for (int i = 0; i < seismograms.length; ++i) {
            LongShortTrigger trigger = this.phaseStoN.process(channel.getSite().getLocation(), event.get_preferred_origin(), seismograms[i]);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    public String getCookieName() {
        return PHASE_STON_PREFIX + this.getPhaseName();
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String toString() {
        return "PhaseSignalToNoise(" + this.getPhaseName() + ")";
    }
}

